/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.atsr;

import org.esa.s3tbx.dataio.atsr.AtsrConstants;
import org.junit.Assert;
import org.junit.Test;

public class AtsrConstantsTest {
    @Test
    public void testBasicConstants() {
        Assert.assertEquals((Object)"ATSR", (Object)"ATSR");
        Assert.assertEquals((Object)"ATSR1/ATSR2 products", (Object)"ATSR1/ATSR2 products");
    }

    @Test
    public void testHeaderByteSizeConstants() {
        Assert.assertEquals((long)4096L, (long)4096L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)60L, (long)60L);
        Assert.assertEquals((long)6L, (long)6L);
        Assert.assertEquals((long)5L, (long)5L);
        Assert.assertEquals((long)16L, (long)16L);
        Assert.assertEquals((long)25L, (long)25L);
        Assert.assertEquals((long)13L, (long)13L);
        Assert.assertEquals((long)9L, (long)9L);
        Assert.assertEquals((long)11L, (long)11L);
        Assert.assertEquals((long)16L, (long)16L);
        Assert.assertEquals((long)13L, (long)13L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)6L, (long)6L);
        Assert.assertEquals((long)25L, (long)25L);
        Assert.assertEquals((long)8L, (long)8L);
        Assert.assertEquals((long)9L, (long)9L);
        Assert.assertEquals((long)3L, (long)3L);
        Assert.assertEquals((long)6L, (long)6L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)6L, (long)6L);
        Assert.assertEquals((long)8L, (long)8L);
        Assert.assertEquals((long)9L, (long)9L);
        Assert.assertEquals((long)6L, (long)6L);
        Assert.assertEquals((long)8L, (long)8L);
        Assert.assertEquals((long)10L, (long)10L);
        Assert.assertEquals((long)4L, (long)4L);
    }

    @Test
    public void testHeaderConstants() {
        int n;
        char[] expByteOrder = new char[]{'A', 'B'};
        String[] expProductTypes = new String[]{"GBT", "GSST"};
        String[] expInstruments = new String[]{"ATSR1", "ATSR2"};
        for (n = 0; n < expByteOrder.length; ++n) {
            Assert.assertEquals((long)expByteOrder[n], (long)AtsrConstants.BYTE_ORDER_FIELD[n]);
        }
        for (n = 0; n < expProductTypes.length; ++n) {
            Assert.assertEquals((Object)expProductTypes[n], (Object)AtsrConstants.PRODUCT_TYPES[n]);
        }
        for (n = 0; n < expInstruments.length; ++n) {
            Assert.assertEquals((Object)expInstruments[n], (Object)AtsrConstants.INSTRUMENTS[n]);
        }
    }

    @Test
    public void testHeaderFieldNameConstants() {
        Assert.assertEquals((Object)"PRODUCT_FILE_NAME", (Object)"PRODUCT_FILE_NAME");
        Assert.assertEquals((Object)"INSTRUMENT_NAME", (Object)"INSTRUMENT_NAME");
        Assert.assertEquals((Object)"ERS_STATE_VECTOR_TYPE", (Object)"ERS_STATE_VECTOR_TYPE");
        Assert.assertEquals((Object)"ASCENDING_NODE_TIME", (Object)"ASCENDING_NODE_TIME");
        Assert.assertEquals((Object)"STATE_VECTOR_POSITION_X", (Object)"STATE_VECTOR_POSITION_X");
        Assert.assertEquals((Object)"STATE_VECTOR_POSITION_Y", (Object)"STATE_VECTOR_POSITION_Y");
        Assert.assertEquals((Object)"STATE_VECTOR_POSITION_Z", (Object)"STATE_VECTOR_POSITION_Z");
        Assert.assertEquals((Object)"STATE_VECTOR_VELOCITY_X", (Object)"STATE_VECTOR_VELOCITY_X");
        Assert.assertEquals((Object)"STATE_VECTOR_VELOCITY_Y", (Object)"STATE_VECTOR_VELOCITY_Y");
        Assert.assertEquals((Object)"STATE_VECTOR_VELOCITY_Z", (Object)"STATE_VECTOR_VELOCITY_Z");
        Assert.assertEquals((Object)"ASCENDING_NODE_LONGITUDE", (Object)"ASCENDING_NODE_LONGITUDE");
        Assert.assertEquals((Object)"REFERENCE_UT", (Object)"REFERENCE_UT");
        Assert.assertEquals((Object)"ERS_CLOCK_TIME", (Object)"ERS_CLOCK_TIME");
        Assert.assertEquals((Object)"ERS_CLOCK_PERIOD", (Object)"ERS_CLOCK_PERIOD");
        Assert.assertEquals((Object)"NADIR_ONLY_PRESENT", (Object)"NADIR_ONLY_PRESENT");
        Assert.assertEquals((Object)"THERMAL_RECORDS_PRESENT", (Object)"THERMAL_RECORDS_PRESENT");
        Assert.assertEquals((Object)"VISIBLE_RECORDS_PRESENT", (Object)"VISIBLE_RECORDS_PRESENT");
        Assert.assertEquals((Object)"LAT_LON_RECORDS_PRESENT", (Object)"LAT_LON_RECORDS_PRESENT");
        Assert.assertEquals((Object)"X_Y_RECORDS_PRESENT", (Object)"X_Y_RECORDS_PRESENT");
        Assert.assertEquals((Object)"FLAG_RECORDS_PRESENT", (Object)"FLAG_RECORDS_PRESENT");
        Assert.assertEquals((Object)"ALONG_TRACK_START_DISTANCE", (Object)"ALONG_TRACK_START_DISTANCE");
        Assert.assertEquals((Object)"ALONG_TRACK_END_DISTANCE", (Object)"ALONG_TRACK_END_DISTANCE");
        Assert.assertEquals((Object)"PRODUCT_START_TIME", (Object)"PRODUCT_START_TIME");
        Assert.assertEquals((Object)"PRODUCT_END_TIME", (Object)"PRODUCT_END_TIME");
        Assert.assertEquals((Object)"CORNER_LAT_LHS_START", (Object)"CORNER_LAT_LHS_START");
        Assert.assertEquals((Object)"CORNER_LAT_RHS_START", (Object)"CORNER_LAT_RHS_START");
        Assert.assertEquals((Object)"CORNER_LAT_LHS_END", (Object)"CORNER_LAT_LHS_END");
        Assert.assertEquals((Object)"CORNER_LAT_RHS_END", (Object)"CORNER_LAT_RHS_END");
        Assert.assertEquals((Object)"CORNER_LON_LHS_START", (Object)"CORNER_LON_LHS_START");
        Assert.assertEquals((Object)"CORNER_LON_RHS_START", (Object)"CORNER_LON_RHS_START");
        Assert.assertEquals((Object)"CORNER_LON_LHS_END", (Object)"CORNER_LON_LHS_END");
        Assert.assertEquals((Object)"CORNER_LON_RHS_END", (Object)"CORNER_LON_RHS_END");
        Assert.assertEquals((Object)"PIXEL_SELECTION_MAPS_NADIR", (Object)"PIXEL_SELECTION_MAPS_NADIR");
        Assert.assertEquals((Object)"PSM_CHANGE_DISTANCE_NADIR", (Object)"PSM_CHANGE_DISTANCE_NADIR");
        Assert.assertEquals((Object)"PIXEL_SELECTION_MAPS_FORWARD", (Object)"PIXEL_SELECTION_MAPS_FORWARD");
        Assert.assertEquals((Object)"PSM_CHANGE_DISTANCE_FORWARD", (Object)"PSM_CHANGE_DISTANCE_FORWARD");
        Assert.assertEquals((Object)"ATSR2_DATA_RATE_NADIR_VIEW", (Object)"ATSR2_DATA_RATE_NADIR_VIEW");
        Assert.assertEquals((Object)"ATSR2_DATA_RATE_CHANGE_NADIR_VIEW", (Object)"ATSR2_DATA_RATE_CHANGE_NADIR_VIEW");
        Assert.assertEquals((Object)"ATSR2_DATA_RATE_FORWARD_VIEW", (Object)"ATSR2_DATA_RATE_FORWARD_VIEW");
        Assert.assertEquals((Object)"ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW", (Object)"ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW");
        Assert.assertEquals((Object)"MINIMUM_SCC_TEMPERATURE", (Object)"MINIMUM_SCC_TEMPERATURE");
        Assert.assertEquals((Object)"MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM", (Object)"MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM");
        Assert.assertEquals((Object)"MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM", (Object)"MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM");
        Assert.assertEquals((Object)"MINIMUM_INSTRUMENT_TEMPERATURE_370_NM", (Object)"MINIMUM_INSTRUMENT_TEMPERATURE_370_NM");
        Assert.assertEquals((Object)"MINIMUM_INSTRUMENT_TEMPERATURE_160_NM", (Object)"MINIMUM_INSTRUMENT_TEMPERATURE_160_NM");
        Assert.assertEquals((Object)"MINIMUM_INSTRUMENT_TEMPERATURE_87_NM", (Object)"MINIMUM_INSTRUMENT_TEMPERATURE_87_NM");
        Assert.assertEquals((Object)"MAXIMUM_SCC_TEMPERATURE", (Object)"MAXIMUM_SCC_TEMPERATURE");
        Assert.assertEquals((Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM", (Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM");
        Assert.assertEquals((Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM", (Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM");
        Assert.assertEquals((Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM", (Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM");
        Assert.assertEquals((Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM", (Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM");
        Assert.assertEquals((Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM", (Object)"MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM");
        Assert.assertEquals((Object)"sun_elev_nadir", (Object)"sun_elev_nadir");
        Assert.assertEquals((Object)"view_elev_nadir", (Object)"view_elev_nadir");
        Assert.assertEquals((Object)"sun_azimuth_nadir", (Object)"sun_azimuth_nadir");
        Assert.assertEquals((Object)"view_azimuth_nadir", (Object)"view_azimuth_nadir");
        Assert.assertEquals((Object)"sun_elev_forward", (Object)"sun_elev_forward");
        Assert.assertEquals((Object)"view_elev_forward", (Object)"view_elev_forward");
        Assert.assertEquals((Object)"sun_azimuth_forward", (Object)"sun_azimuth_forward");
        Assert.assertEquals((Object)"view_azimuth_forward", (Object)"view_azimuth_forward");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_YSM_NADIR", (Object)"ERS_PLATFORM_MODE_YSM_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_FCM_NADIR", (Object)"ERS_PLATFORM_MODE_FCM_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_OCM_NADIR", (Object)"ERS_PLATFORM_MODE_OCM_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_FPM_NADIR", (Object)"ERS_PLATFORM_MODE_FPM_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_RTMM_NADIR", (Object)"ERS_PLATFORM_MODE_RTMM_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_RTMC_NADIR", (Object)"ERS_PLATFORM_MODE_RTMC_NADIR");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_YSM_FORWARD", (Object)"ERS_PLATFORM_MODE_YSM_FORWARD");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_FCM_FORWARD", (Object)"ERS_PLATFORM_MODE_FCM_FORWARD");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_OCM_FORWARD", (Object)"ERS_PLATFORM_MODE_OCM_FORWARD");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_FPM_FORWARD", (Object)"ERS_PLATFORM_MODE_FPM_FORWARD");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_RTMM_FORWARD", (Object)"ERS_PLATFORM_MODE_RTMM_FORWARD");
        Assert.assertEquals((Object)"ERS_PLATFORM_MODE_RTMC_FORWARD", (Object)"ERS_PLATFORM_MODE_RTMC_FORWARD");
        Assert.assertEquals((Object)"PCD_INFORMATION_NADIR", (Object)"PCD_INFORMATION_NADIR");
        Assert.assertEquals((Object)"PCD_INFORMATION_FORWARD", (Object)"PCD_INFORMATION_FORWARD");
        Assert.assertEquals((Object)"PACKET_INFORMATION_NADIR", (Object)"PACKET_INFORMATION_NADIR");
        Assert.assertEquals((Object)"PACKET_INFORMATION_FORWARD", (Object)"PACKET_INFORMATION_FORWARD");
        Assert.assertEquals((Object)"MAX_SINGLE_PIXEL_ERROR_CODE", (Object)"MAX_SINGLE_PIXEL_ERROR_CODE");
        Assert.assertEquals((Object)"latitude", (Object)"latitude");
        Assert.assertEquals((Object)"longitude", (Object)"longitude");
    }

    @Test
    public void testHeaderFieldDescriptionsandUnits() {
        Assert.assertEquals((Object)"Days since January 1st, 1950", (Object)"Days since January 1st, 1950");
        Assert.assertEquals((Object)"d", (Object)"d");
        Assert.assertEquals((Object)"Universal time at ascending node", (Object)"Universal time at ascending node");
        Assert.assertEquals((Object)"km", (Object)"km");
        Assert.assertEquals((Object)"Ascending node state vector position x", (Object)"Ascending node state vector position x");
        Assert.assertEquals((Object)"Ascending node state vector position y", (Object)"Ascending node state vector position y");
        Assert.assertEquals((Object)"Ascending node state vector position z", (Object)"Ascending node state vector position z");
        Assert.assertEquals((Object)"km/s", (Object)"km/s");
        Assert.assertEquals((Object)"Ascending node state vector velocity x", (Object)"Ascending node state vector velocity x");
        Assert.assertEquals((Object)"Ascending node state vector velocity y", (Object)"Ascending node state vector velocity y");
        Assert.assertEquals((Object)"Ascending node state vector velocity z", (Object)"Ascending node state vector velocity z");
        Assert.assertEquals((Object)"Longitude of ascending node", (Object)"Longitude of ascending node");
        Assert.assertEquals((Object)"dec. deg.", (Object)"dec. deg.");
        Assert.assertEquals((Object)"Reference universal time (days since January 1st, 1950)", (Object)"Reference universal time (days since January 1st, 1950)");
        Assert.assertEquals((Object)"d", (Object)"d");
        Assert.assertEquals((Object)"ns", (Object)"ns");
        Assert.assertEquals((Object)"Reference ERS satellite clock time", (Object)"Reference ERS satellite clock time");
        Assert.assertEquals((Object)"Period of ERS satellite clock", (Object)"Period of ERS satellite clock");
        Assert.assertEquals((Object)"Nadir-only records present", (Object)"Nadir-only records present");
        Assert.assertEquals((Object)"Thermal infra-red detector records present", (Object)"Thermal infra-red detector records present");
        Assert.assertEquals((Object)"Visible/near-infra-red detector records present", (Object)"Visible/near-infra-red detector records present");
        Assert.assertEquals((Object)"Latitude/longitude records present", (Object)"Latitude/longitude records present");
        Assert.assertEquals((Object)"X/Y coordinate records present", (Object)"X/Y coordinate records present");
        Assert.assertEquals((Object)"Cloud-clearing/land-flagging records present", (Object)"Cloud-clearing/land-flagging records present");
        Assert.assertEquals((Object)"km", (Object)"km");
        Assert.assertEquals((Object)"Along-track distance of product start", (Object)"Along-track distance of product start");
        Assert.assertEquals((Object)"Along-track distance of product end", (Object)"Along-track distance of product end");
        Assert.assertEquals((Object)"Universal time of data acquisition at product start", (Object)"Universal time of data acquisition at product start");
        Assert.assertEquals((Object)"Universal time of data acquisition at product end", (Object)"Universal time of data acquisition at product end");
        Assert.assertEquals((Object)"dec. deg.", (Object)"dec. deg.");
        Assert.assertEquals((Object)"Latitude of product LHS corner point at start", (Object)"Latitude of product LHS corner point at start");
        Assert.assertEquals((Object)"Latitude of product RHS corner point at start", (Object)"Latitude of product RHS corner point at start");
        Assert.assertEquals((Object)"Latitude of product LHS corner point at end", (Object)"Latitude of product LHS corner point at end");
        Assert.assertEquals((Object)"Latitude of product RHS corner point at end", (Object)"Latitude of product RHS corner point at end");
        Assert.assertEquals((Object)"Longitude of product LHS corner point at start", (Object)"Longitude of product LHS corner point at start");
        Assert.assertEquals((Object)"Longitude of product RHS corner point at start", (Object)"Longitude of product RHS corner point at start");
        Assert.assertEquals((Object)"Longitude of product LHS corner point at end", (Object)"Longitude of product LHS corner point at end");
        Assert.assertEquals((Object)"Longitude of product RHS corner point at end", (Object)"Longitude of product RHS corner point at end");
        Assert.assertEquals((Object)"1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view", (Object)"1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view");
        Assert.assertEquals((Object)"Along-track distance of 1st PSM change in nadir-view", (Object)"Along-track distance of 1st PSM change in nadir-view");
        Assert.assertEquals((Object)"km", (Object)"km");
        Assert.assertEquals((Object)"1st and 2nd ATSR-2 Pixel Selection Maps in forward-view", (Object)"1st and 2nd ATSR-2 Pixel Selection Maps in forward-view");
        Assert.assertEquals((Object)"Along-track distance of 1st PSM change in forward-view", (Object)"Along-track distance of 1st PSM change in forward-view");
        Assert.assertEquals((Object)"ATSR-2 data-rate at start of nadir-view", (Object)"ATSR-2 data-rate at start of nadir-view");
        Assert.assertEquals((Object)"Along-track distance of 1st ATSR-2 data-rate change in nadir-view", (Object)"Along-track distance of 1st ATSR-2 data-rate change in nadir-view");
        Assert.assertEquals((Object)"km", (Object)"km");
        Assert.assertEquals((Object)"ATSR-2 data-rate at start of forward-view", (Object)"ATSR-2 data-rate at start of forward-view");
        Assert.assertEquals((Object)"Along-track distance of 1st ATSR-2 data-rate change in forward-view", (Object)"Along-track distance of 1st ATSR-2 data-rate change in forward-view");
        Assert.assertEquals((Object)"Minimum Stirling Cycle Cooler cold-tip temperature", (Object)"Minimum Stirling Cycle Cooler cold-tip temperature");
        Assert.assertEquals((Object)"K", (Object)"K");
        Assert.assertEquals((Object)"Minimum instrument detector temperature at 1200 nm", (Object)"Minimum instrument detector temperature at 1200 nm");
        Assert.assertEquals((Object)"Minimum instrument detector temperature at 1100 nm", (Object)"Minimum instrument detector temperature at 1100 nm");
        Assert.assertEquals((Object)"Minimum instrument detector temperature at 370 nm", (Object)"Minimum instrument detector temperature at 370 nm");
        Assert.assertEquals((Object)"Minimum instrument detector temperature at 160 nm", (Object)"Minimum instrument detector temperature at 160 nm");
        Assert.assertEquals((Object)"Minimum instrument detector temperature at 87 nm", (Object)"Minimum instrument detector temperature at 87 nm");
        Assert.assertEquals((Object)"Maximum Stirling Cycle Cooler cold-tip temperature", (Object)"Maximum Stirling Cycle Cooler cold-tip temperature");
        Assert.assertEquals((Object)"Maximum instrument detector temperature at 1200 nm", (Object)"Maximum instrument detector temperature at 1200 nm");
        Assert.assertEquals((Object)"Maximum instrument detector temperature at 1100 nm", (Object)"Maximum instrument detector temperature at 1100 nm");
        Assert.assertEquals((Object)"Maximum instrument detector temperature at 370 nm", (Object)"Maximum instrument detector temperature at 370 nm");
        Assert.assertEquals((Object)"Maximum instrument detector temperature at 160 nm", (Object)"Maximum instrument detector temperature at 160 nm");
        Assert.assertEquals((Object)"Maximum instrument detector temperature at 87 nm", (Object)"Maximum instrument detector temperature at 87 nm");
        Assert.assertEquals((Object)"dec. deg.", (Object)"dec. deg.");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in YSM", (Object)"ERS platform modes during nadir view as # of scans in YSM");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in FCM", (Object)"ERS platform modes during nadir view as # of scans in FCM");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in OCM", (Object)"ERS platform modes during nadir view as # of scans in OCM");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in FPM", (Object)"ERS platform modes during nadir view as # of scans in FPM");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in RTMM", (Object)"ERS platform modes during nadir view as # of scans in RTMM");
        Assert.assertEquals((Object)"ERS platform modes during nadir view as # of scans in RTMC", (Object)"ERS platform modes during nadir view as # of scans in RTMC");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in YSM", (Object)"ERS platform modes during forward view as # of scans in YSM");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in FCM", (Object)"ERS platform modes during forward view as # of scans in FCM");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in OCM", (Object)"ERS platform modes during forward view as # of scans in OCM");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in FPM", (Object)"ERS platform modes during forward view as # of scans in FPM");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in RTMM", (Object)"ERS platform modes during forward view as # of scans in RTMM");
        Assert.assertEquals((Object)"ERS platform modes during forward view as # of scans in RTMC", (Object)"ERS platform modes during forward view as # of scans in RTMC");
        Assert.assertEquals((Object)"Acquisition of PCD information during nadir-view as # of scans for each condition", (Object)"Acquisition of PCD information during nadir-view as # of scans for each condition");
        Assert.assertEquals((Object)"Acquisition of PCD information during forward-view as # of scans for each condition", (Object)"Acquisition of PCD information during forward-view as # of scans for each condition");
        Assert.assertEquals((Object)"SADIST-2 packet validation during nadir-view as # of scans for each condition", (Object)"SADIST-2 packet validation during nadir-view as # of scans for each condition");
        Assert.assertEquals((Object)"SADIST-2 packet validation during forward-view as # of scans for each condition", (Object)"SADIST-2 packet validation during forward-view as # of scans for each condition");
        Assert.assertEquals((Object)"Maximum single-pixel error code", (Object)"Maximum single-pixel error code");
        Assert.assertEquals((Object)"Nadir-view solar elevation", (Object)"Nadir-view solar elevation");
        Assert.assertEquals((Object)"Nadir-view satellite elevation", (Object)"Nadir-view satellite elevation");
        Assert.assertEquals((Object)"Nadir-view solar azimuth", (Object)"Nadir-view solar azimuth");
        Assert.assertEquals((Object)"Nadir-view satellite azimuth", (Object)"Nadir-view satellite azimuth");
        Assert.assertEquals((Object)"Forward-view solar elevation", (Object)"Forward-view solar elevation");
        Assert.assertEquals((Object)"Forward-view satellite elevation", (Object)"Forward-view satellite elevation");
        Assert.assertEquals((Object)"Forward-view solar azimuth", (Object)"Forward-view solar azimuth");
        Assert.assertEquals((Object)"Forward-view satellite azimuth", (Object)"Forward-view satellite azimuth");
        Assert.assertEquals((Object)"Longitudes of image pixels", (Object)"Longitudes of image pixels");
        Assert.assertEquals((Object)"Latitudes of image pixels", (Object)"Latitudes of image pixels");
    }

    @Test
    public void testMetadataConstants() {
        Assert.assertEquals((Object)"MPH", (Object)"MPH");
        Assert.assertEquals((Object)"SPH", (Object)"SPH");
    }

    @Test
    public void testProductSizeConstants() {
        Assert.assertEquals((long)512L, (long)512L);
        Assert.assertEquals((long)512L, (long)512L);
        Assert.assertEquals((long)11L, (long)11L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)50L, (long)50L);
        Assert.assertEquals((long)512L, (long)512L);
        Assert.assertEquals((double)6.0, (double)6.0, (double)1.0E-6);
        Assert.assertEquals((long)16L, (long)16L);
        Assert.assertEquals((long)16L, (long)16L);
    }

    @Test
    public void testPixelSizes() {
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((long)4L, (long)4L);
        Assert.assertEquals((long)1L, (long)1L);
        Assert.assertEquals((long)2L, (long)2L);
    }

    @Test
    public void testConversionConstants() {
        Assert.assertEquals((double)0.001f, (double)0.001f, (double)1.0E-6);
    }

    @Test
    public void testFlagCodings() {
        Assert.assertEquals((Object)"Nadir-view cloud-clearing/land-flagging results", (Object)"Nadir-view cloud-clearing/land-flagging results");
        Assert.assertEquals((Object)"Forward-view cloud-clearing/land-flagging results", (Object)"Forward-view cloud-clearing/land-flagging results");
        Assert.assertEquals((Object)"cloud_flags_nadir", (Object)"cloud_flags_nadir");
        Assert.assertEquals((Object)"cloud_flags_fward", (Object)"cloud_flags_fward");
        Assert.assertEquals((Object)"LAND", (Object)"LAND");
        Assert.assertEquals((long)1L, (long)1L);
        Assert.assertEquals((Object)"Pixel is over land", (Object)"Pixel is over land");
        Assert.assertEquals((Object)"CLOUDY", (Object)"CLOUDY");
        Assert.assertEquals((long)2L, (long)2L);
        Assert.assertEquals((Object)"Pixel is cloudy (result of all cloud tests)", (Object)"Pixel is cloudy (result of all cloud tests)");
        Assert.assertEquals((Object)"SUN_GLINT", (Object)"SUN_GLINT");
        Assert.assertEquals((long)4L, (long)4L);
        Assert.assertEquals((Object)"Sunglint detected in pixel", (Object)"Sunglint detected in pixel");
        Assert.assertEquals((Object)"CLOUDY_REFL_HIST", (Object)"CLOUDY_REFL_HIST");
        Assert.assertEquals((long)8L, (long)8L);
        Assert.assertEquals((Object)"1.6 um reflectance histogram test (day-time only)", (Object)"1.6 um reflectance histogram test (day-time only)");
        Assert.assertEquals((Object)"CLOUDY_SPAT_COHER_16", (Object)"CLOUDY_SPAT_COHER_16");
        Assert.assertEquals((long)16L, (long)16L);
        Assert.assertEquals((Object)"1.6 um spatial coherence test (day-time only)", (Object)"1.6 um spatial coherence test (day-time only)");
        Assert.assertEquals((Object)"CLOUDY_SPAT_COHER_11", (Object)"CLOUDY_SPAT_COHER_11");
        Assert.assertEquals((long)32L, (long)32L);
        Assert.assertEquals((Object)"11 um spatial coherence test", (Object)"11 um spatial coherence test");
        Assert.assertEquals((Object)"CLOUDY_GROSS_12", (Object)"CLOUDY_GROSS_12");
        Assert.assertEquals((long)64L, (long)64L);
        Assert.assertEquals((Object)"12 um gross cloud test", (Object)"12 um gross cloud test");
        Assert.assertEquals((Object)"CLOUDY_CIRRUS_11_12", (Object)"CLOUDY_CIRRUS_11_12");
        Assert.assertEquals((long)128L, (long)128L);
        Assert.assertEquals((Object)"11/12 um thin cirrus test", (Object)"11/12 um thin cirrus test");
        Assert.assertEquals((Object)"CLOUDY_MED_HI_LEVEL_37_12", (Object)"CLOUDY_MED_HI_LEVEL_37_12");
        Assert.assertEquals((long)256L, (long)256L);
        Assert.assertEquals((Object)"3.7/12 um medium/high level test (night-time only)", (Object)"3.7/12 um medium/high level test (night-time only)");
        Assert.assertEquals((Object)"CLOUDY_FOG_LOW_STRATUS_11_37", (Object)"CLOUDY_FOG_LOW_STRATUS_11_37");
        Assert.assertEquals((long)512L, (long)512L);
        Assert.assertEquals((Object)"11/3.7 um fog/low stratus test (night-time only)", (Object)"11/3.7 um fog/low stratus test (night-time only)");
        Assert.assertEquals((Object)"CLOUDY_VW_DIFF_11_12", (Object)"CLOUDY_VW_DIFF_11_12");
        Assert.assertEquals((long)1024L, (long)1024L);
        Assert.assertEquals((Object)"11/12 um view difference test", (Object)"11/12 um view difference test");
        Assert.assertEquals((Object)"CLOUDY_VW_DIFF_37_11", (Object)"CLOUDY_VW_DIFF_37_11");
        Assert.assertEquals((long)2048L, (long)2048L);
        Assert.assertEquals((Object)"3.7/11 um view difference test (night-time only)", (Object)"3.7/11 um view difference test (night-time only)");
        Assert.assertEquals((Object)"CLOUDY_THERM_HIST_11_12", (Object)"CLOUDY_THERM_HIST_11_12");
        Assert.assertEquals((long)4096L, (long)4096L);
        Assert.assertEquals((Object)"11/12 um thermal histogram test", (Object)"11/12 um thermal histogram test");
    }
}

