/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.esa.beam.dataio.atsr.AtsrConstants;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;

class AtsrHeader
implements AtsrConstants {
    private MetadataElement _sph;
    private MetadataElement _mph;
    private MetadataElement _qads;
    private Vector _tiePointGrids = new Vector();
    private InputStreamReader _reader;
    private boolean _nadirOnly;
    private boolean _thermalPresent;
    private boolean _visiblePresent;
    private boolean _latlonPresent;
    private boolean _xyPresent;
    private boolean _flagsPresent;
    private String _fileName;
    private String _sensor;

    public void parse(byte[] rawHeaderData) throws IOException {
        this._reader = new InputStreamReader(new ByteArrayInputStream(rawHeaderData));
        this.createEmptyNodes();
        this.parseBaseParameter();
        this.parseOrbitParameter();
        this.parseClockCalibrationParameter();
        this.parseProductOptionalContentsParameter();
        this.parseProductPositionParameters();
        this.parseInstrumentModesAndTemperatureParameter();
        this.parseSolarAndViewAngleParameter();
        this.parseProductConfidenceInformation();
    }

    public MetadataElement getMetadata(MetadataElement root) {
        root.addElement(this._mph);
        root.addElement(this._sph);
        root.addElement(this._qads);
        return root;
    }

    public int getNumTiePointGrids() {
        int nRet = 0;
        if (this._tiePointGrids != null) {
            nRet = this._tiePointGrids.size();
        }
        return nRet;
    }

    public TiePointGrid getTiePointGridAt(int nIndex) {
        return (TiePointGrid)this._tiePointGrids.elementAt(nIndex);
    }

    void addTiePointGrid(TiePointGrid grid) {
        this._tiePointGrids.add(grid);
    }

    public boolean isNadirOnly() {
        return this._nadirOnly;
    }

    public boolean isThermalPresent() {
        return this._thermalPresent;
    }

    public boolean isVisiblePresent() {
        return this._visiblePresent;
    }

    public boolean isLatLonPresent() {
        return this._latlonPresent;
    }

    public boolean isXYPresent() {
        return this._xyPresent;
    }

    public boolean areFlagsPresent() {
        return this._flagsPresent;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getSensorType() {
        return this._sensor;
    }

    private void createEmptyNodes() {
        this._mph = new MetadataElement("MPH");
        this._sph = new MetadataElement("SPH");
        this._qads = new MetadataElement("QUALITY_ADS");
    }

    private void parseBaseParameter() throws IOException {
        MetadataAttribute attribute = null;
        this.parseString(2);
        attribute = this.parseStringAttribute(60, "PRODUCT_FILE_NAME", null, null);
        this._fileName = attribute.getData().getElemString();
        this._mph.addAttribute(attribute);
        attribute = this.parseStringAttribute(6, "INSTRUMENT_NAME", null, null);
        this._sensor = attribute.getData().getElemString();
        this._mph.addAttribute(attribute);
    }

    private void parseOrbitParameter() throws IOException {
        MetadataAttribute attribute = null;
        attribute = this.parseStringAttribute(5, "ERS_STATE_VECTOR_TYPE", null, null);
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(16, "ASCENDING_NODE_TIME", "Days since January 1st, 1950", "d");
        this._mph.addAttribute(attribute);
        attribute = this.parseStringAttribute(25, "ASCENDING_NODE_UT", "Universal time at ascending node", null);
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(13, "STATE_VECTOR_POSITION_X", "Ascending node state vector position x", "km");
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(13, "STATE_VECTOR_POSITION_Y", "Ascending node state vector position y", "km");
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(13, "STATE_VECTOR_POSITION_Z", "Ascending node state vector position z", "km");
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "STATE_VECTOR_VELOCITY_X", "Ascending node state vector velocity x", "km/s");
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "STATE_VECTOR_VELOCITY_Y", "Ascending node state vector velocity y", "km/s");
        this._mph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "STATE_VECTOR_VELOCITY_Z", "Ascending node state vector velocity z", "km/s");
        this._mph.addAttribute(attribute);
        attribute = this.parseStringAttribute(11, "ASCENDING_NODE_LONGITUDE", "Longitude of ascending node", "dec. deg.");
        this._mph.addAttribute(attribute);
    }

    private void parseClockCalibrationParameter() throws IOException {
        float fData = 0.0f;
        long nData = 0L;
        MetadataAttribute attribute = null;
        ProductData data = null;
        fData = this.parseFloat(16);
        data = ProductData.createInstance((float[])new float[]{fData});
        attribute = new MetadataAttribute("REFERENCE_UT", data, true);
        attribute.setUnit("d");
        attribute.setDescription("Reference universal time (days since January 1st, 1950)");
        this._mph.addAttribute(attribute);
        nData = this.parseLong(13);
        data = ProductData.createInstance((int)22, (int)1);
        data.setElemUInt(nData);
        attribute = new MetadataAttribute("ERS_CLOCK_TIME", data, true);
        attribute.setUnit("ns");
        attribute.setDescription("Reference ERS satellite clock time");
        this._mph.addAttribute(attribute);
        nData = this.parseLong(13);
        data = ProductData.createInstance((int)22, (int)1);
        data.setElemUInt(nData);
        attribute = new MetadataAttribute("ERS_CLOCK_PERIOD", data, true);
        attribute.setUnit("ns");
        attribute.setDescription("Period of ERS satellite clock");
        this._mph.addAttribute(attribute);
    }

    private void parseProductOptionalContentsParameter() throws IOException {
        int value = this.parseAndAddAttributeToSPH("NADIR_ONLY_PRESENT", "Nadir-only records present");
        this._nadirOnly = value > 0;
        value = this.parseAndAddAttributeToSPH("THERMAL_RECORDS_PRESENT", "Thermal infra-red detector records present");
        this._thermalPresent = value > 0;
        value = this.parseAndAddAttributeToSPH("VISIBLE_RECORDS_PRESENT", "Visible/near-infra-red detector records present");
        this._visiblePresent = value > 0;
        value = this.parseAndAddAttributeToSPH("LAT_LON_RECORDS_PRESENT", "Latitude/longitude records present");
        this._latlonPresent = value > 0;
        value = this.parseAndAddAttributeToSPH("X_Y_RECORDS_PRESENT", "X/Y coordinate records present");
        this._xyPresent = value > 0;
        value = this.parseAndAddAttributeToSPH("FLAG_RECORDS_PRESENT", "Cloud-clearing/land-flagging records present");
        this._flagsPresent = value > 0;
    }

    private int parseAndAddAttributeToSPH(String attributeName, String attributeDescription) throws IOException {
        int nData = this.parseInt(2);
        ProductData data = ProductData.createInstance((int[])new int[]{nData});
        MetadataAttribute attribute = new MetadataAttribute(attributeName, data, true);
        attribute.setDescription(attributeDescription);
        this._sph.addAttribute(attribute);
        return nData;
    }

    private void parseProductPositionParameters() throws IOException {
        MetadataAttribute attribute = null;
        attribute = this.parseIntAttribute(6, "ALONG_TRACK_START_DISTANCE", "Along-track distance of product start", "km");
        this._sph.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ALONG_TRACK_END_DISTANCE", "Along-track distance of product end", "km");
        this._sph.addAttribute(attribute);
        attribute = this.parseStringAttribute(25, "PRODUCT_START_TIME", "Universal time of data acquisition at product start", null);
        this._sph.addAttribute(attribute);
        attribute = this.parseStringAttribute(25, "PRODUCT_END_TIME", "Universal time of data acquisition at product end", null);
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "CORNER_LAT_LHS_START", "Latitude of product LHS corner point at start", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "CORNER_LAT_RHS_START", "Latitude of product RHS corner point at start", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "CORNER_LAT_LHS_END", "Latitude of product LHS corner point at end", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "CORNER_LAT_RHS_END", "Latitude of product RHS corner point at end", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "CORNER_LON_LHS_START", "Longitude of product LHS corner point at start", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "CORNER_LON_RHS_START", "Longitude of product RHS corner point at start", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "CORNER_LON_LHS_END", "Longitude of product LHS corner point at end", "dec. deg.");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(9, "CORNER_LON_RHS_END", "Longitude of product RHS corner point at end", "dec. deg.");
        this._sph.addAttribute(attribute);
    }

    private void parseInstrumentModesAndTemperatureParameter() throws IOException {
        int[] dataArray = new int[2];
        ProductData data = null;
        MetadataAttribute attribute = null;
        dataArray[0] = this.parseInt(3);
        dataArray[1] = this.parseInt(3);
        data = ProductData.createInstance((int[])dataArray);
        attribute = new MetadataAttribute("PIXEL_SELECTION_MAPS_NADIR", data, true);
        attribute.setDescription("1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view");
        this._sph.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "PSM_CHANGE_DISTANCE_NADIR", "Along-track distance of 1st PSM change in nadir-view", "km");
        this._sph.addAttribute(attribute);
        dataArray[0] = this.parseInt(3);
        dataArray[1] = this.parseInt(3);
        data = ProductData.createInstance((int[])dataArray);
        attribute = new MetadataAttribute("PIXEL_SELECTION_MAPS_FORWARD", data, true);
        attribute.setDescription("1st and 2nd ATSR-2 Pixel Selection Maps in forward-view");
        this._sph.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "PSM_CHANGE_DISTANCE_FORWARD", "Along-track distance of 1st PSM change in forward-view", "km");
        this._sph.addAttribute(attribute);
        attribute = this.parseStringAttribute(2, "ATSR2_DATA_RATE_NADIR_VIEW", "ATSR-2 data-rate at start of nadir-view", null);
        this._sph.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ATSR2_DATA_RATE_CHANGE_NADIR_VIEW", "Along-track distance of 1st ATSR-2 data-rate change in nadir-view", "km");
        this._sph.addAttribute(attribute);
        attribute = this.parseStringAttribute(2, "ATSR2_DATA_RATE_FORWARD_VIEW", "ATSR-2 data-rate at start of forward-view", null);
        this._sph.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW", "Along-track distance of 1st ATSR-2 data-rate change in forward-view", "km");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_SCC_TEMPERATURE", "Minimum Stirling Cycle Cooler cold-tip temperature", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM", "Minimum instrument detector temperature at 1200 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM", "Minimum instrument detector temperature at 1100 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_INSTRUMENT_TEMPERATURE_370_NM", "Minimum instrument detector temperature at 370 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_INSTRUMENT_TEMPERATURE_160_NM", "Minimum instrument detector temperature at 160 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MINIMUM_INSTRUMENT_TEMPERATURE_87_NM", "Minimum instrument detector temperature at 87 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_SCC_TEMPERATURE", "Maximum Stirling Cycle Cooler cold-tip temperature", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM", "Maximum instrument detector temperature at 1200 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM", "Maximum instrument detector temperature at 1100 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM", "Maximum instrument detector temperature at 370 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM", "Maximum instrument detector temperature at 160 nm", "K");
        this._sph.addAttribute(attribute);
        attribute = this.parseFloatAttribute(8, "MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM", "Maximum instrument detector temperature at 87 nm", "K");
        this._sph.addAttribute(attribute);
    }

    private void parseSolarAndViewAngleParameter() throws IOException {
        this.parseTiePointGrid("sun_elev_nadir", "Nadir-view solar elevation");
        this.parseTiePointGrid("view_elev_nadir", "Nadir-view satellite elevation");
        this.parseTiePointGrid("sun_azimuth_nadir", "Nadir-view solar azimuth");
        this.parseTiePointGrid("view_azimuth_nadir", "Nadir-view satellite azimuth");
        this.parseTiePointGrid("sun_elev_forward", "Forward-view solar elevation");
        this.parseTiePointGrid("view_elev_forward", "Forward-view satellite elevation");
        this.parseTiePointGrid("sun_azimuth_forward", "Forward-view solar azimuth");
        this.parseTiePointGrid("view_azimuth_forward", "Forward-view satellite azimuth");
    }

    private void parseProductConfidenceInformation() throws IOException {
        MetadataAttribute attribute = null;
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_YSM_NADIR", "ERS platform modes during nadir view as # of scans in YSM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_FCM_NADIR", "ERS platform modes during nadir view as # of scans in FCM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_OCM_NADIR", "ERS platform modes during nadir view as # of scans in OCM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_FPM_NADIR", "ERS platform modes during nadir view as # of scans in FPM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_RTMM_NADIR", "ERS platform modes during nadir view as # of scans in RTMM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_RTMC_NADIR", "ERS platform modes during nadir view as # of scans in RTMC", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_YSM_FORWARD", "ERS platform modes during forward view as # of scans in YSM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_FCM_FORWARD", "ERS platform modes during forward view as # of scans in FCM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_OCM_FORWARD", "ERS platform modes during forward view as # of scans in OCM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_FPM_FORWARD", "ERS platform modes during forward view as # of scans in FPM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_RTMM_FORWARD", "ERS platform modes during forward view as # of scans in RTMM", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(6, "ERS_PLATFORM_MODE_RTMC_FORWARD", "ERS platform modes during forward view as # of scans in RTMC", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntArrayAttribute(6, 8, "PCD_INFORMATION_NADIR", "Acquisition of PCD information during nadir-view as # of scans for each condition", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntArrayAttribute(6, 8, "PCD_INFORMATION_FORWARD", "Acquisition of PCD information during forward-view as # of scans for each condition", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntArrayAttribute(6, 10, "PACKET_INFORMATION_NADIR", "SADIST-2 packet validation during nadir-view as # of scans for each condition", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntArrayAttribute(6, 10, "PACKET_INFORMATION_FORWARD", "SADIST-2 packet validation during forward-view as # of scans for each condition", null);
        this._qads.addAttribute(attribute);
        attribute = this.parseIntAttribute(4, "MAX_SINGLE_PIXEL_ERROR_CODE", "Maximum single-pixel error code", null);
        this._qads.addAttribute(attribute);
    }

    private String parseString(int size) throws IOException {
        char[] array = new char[size];
        this._reader.read(array, 0, size);
        String strRet = new String(array);
        strRet = strRet.trim();
        return strRet;
    }

    private float parseFloat(int size) throws IOException {
        char[] array = new char[size];
        this._reader.read(array, 0, size);
        return Float.parseFloat(new String(array));
    }

    private float[] parseFloatArray(int size, int numElems) throws IOException {
        char[] array = new char[size];
        float[] fRet = new float[numElems];
        for (int n = 0; n < numElems; ++n) {
            this._reader.read(array, 0, size);
            fRet[n] = Float.parseFloat(new String(array));
        }
        return fRet;
    }

    private int parseInt(int size) throws IOException {
        char[] array = new char[size];
        this._reader.read(array, 0, size);
        String bufString = new String(array);
        bufString = bufString.trim();
        return Integer.parseInt(bufString);
    }

    private int[] parseIntArray(int size, int numElems) throws IOException {
        char[] array = new char[size];
        int[] nRet = new int[numElems];
        String str = null;
        for (int n = 0; n < numElems; ++n) {
            this._reader.read(array, 0, size);
            str = new String(array);
            str = str.trim();
            nRet[n] = Integer.parseInt(str);
        }
        return nRet;
    }

    private long parseLong(int size) throws IOException {
        char[] array = new char[size];
        this._reader.read(array, 0, size);
        String bufString = new String(array);
        bufString = bufString.trim();
        return Long.parseLong(bufString);
    }

    private MetadataAttribute parseStringAttribute(int size, String name, String description, String unit) throws IOException {
        String string = null;
        MetadataAttribute attribute = null;
        ProductData data = null;
        string = this.parseString(size);
        data = ProductData.createInstance((String)string);
        attribute = new MetadataAttribute(name, data, true);
        if (description != null) {
            attribute.setDescription(description);
        }
        if (unit != null) {
            attribute.setUnit(unit);
        }
        return attribute;
    }

    private MetadataAttribute parseIntAttribute(int size, String name, String description, String unit) throws IOException {
        int nData = 0;
        MetadataAttribute attribute = null;
        ProductData data = null;
        nData = this.parseInt(size);
        data = ProductData.createInstance((int[])new int[]{nData});
        attribute = new MetadataAttribute(name, data, true);
        if (description != null) {
            attribute.setDescription(description);
        }
        if (unit != null) {
            attribute.setUnit(unit);
        }
        return attribute;
    }

    private MetadataAttribute parseIntArrayAttribute(int size, int numElems, String name, String description, String unit) throws IOException {
        int[] nData = null;
        MetadataAttribute attribute = null;
        ProductData data = null;
        nData = this.parseIntArray(size, numElems);
        data = ProductData.createInstance((int[])nData);
        attribute = new MetadataAttribute(name, data, true);
        if (description != null) {
            attribute.setDescription(description);
        }
        if (unit != null) {
            attribute.setUnit(unit);
        }
        return attribute;
    }

    private MetadataAttribute parseFloatAttribute(int size, String name, String description, String unit) throws IOException {
        float fData = 0.0f;
        MetadataAttribute attribute = null;
        ProductData data = null;
        fData = this.parseFloat(size);
        data = ProductData.createInstance((float[])new float[]{fData});
        attribute = new MetadataAttribute(name, data, true);
        if (description != null) {
            attribute.setDescription(description);
        }
        if (unit != null) {
            attribute.setUnit(unit);
        }
        return attribute;
    }

    private void parseTiePointGrid(String tiePtName, String description) throws IOException {
        TiePointGrid grid = null;
        int arraySize = 22;
        float[] fData = this.parseFloatArray(9, arraySize);
        grid = new TiePointGrid(tiePtName, 11, 2, 6.0f, 0.0f, 50.0f, 512.0f, fData);
        grid.setUnit("dec. deg.");
        if (description != null) {
            grid.setDescription(description);
        }
        this._tiePointGrids.add(grid);
    }
}

