/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.atsr.AtsrConstants;
import org.esa.beam.dataio.atsr.AtsrFile;
import org.esa.beam.dataio.atsr.AtsrGBTFile;
import org.esa.beam.dataio.atsr.AtsrGSSTFile;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.util.Debug;

class AtsrFileFactory
implements AtsrConstants {
    AtsrFileFactory() {
    }

    public static AtsrFileFactory getInstance() {
        return Holder.instance;
    }

    public DecodeQualification getDecodeQualification(String path) {
        return this.getDecodeQualification(new File(path));
    }

    public DecodeQualification getDecodeQualification(File file) {
        DecodeQualification bRet = DecodeQualification.UNABLE;
        try {
            bRet = this.getDecodeQualification(new FileImageInputStream(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(ImageInputStream inStream) {
        DecodeQualification bRet = DecodeQualification.UNABLE;
        byte[] headerBegin = new byte[68];
        try {
            if (inStream.length() < (long)headerBegin.length) {
                bRet = DecodeQualification.UNABLE;
            } else {
                inStream.readFully(headerBegin, 0, headerBegin.length);
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(headerBegin));
                if (this.checkByteOrderField(reader) && this.checkProductFileNameField(reader) && this.checkInstrumentField(reader)) {
                    bRet = DecodeQualification.INTENDED;
                }
            }
        }
        catch (IOException e) {
            Debug.trace((Throwable)e);
            bRet = DecodeQualification.UNABLE;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                Debug.trace((Throwable)e);
            }
        }
        return bRet;
    }

    public AtsrFile open(String path) throws IOException {
        return this.open(new File(path));
    }

    public AtsrFile open(File file) throws IOException {
        return this.open(new FileImageInputStream(file), file);
    }

    public AtsrFile open(ImageInputStream inStream, File inFile) throws IOException {
        String prodType = this.readProductType(inStream);
        AtsrFile file = null;
        if (prodType == null) {
            throw new IOException("Unsupported product.\nOnly ATSR GBT and GSST products are (currently) supported.");
        }
        if (prodType.equalsIgnoreCase(PRODUCT_TYPES[0])) {
            file = new AtsrGBTFile();
        } else if (prodType.equalsIgnoreCase(PRODUCT_TYPES[1])) {
            file = new AtsrGSSTFile();
        } else {
            throw new IOException("Unsupported ATSR product.\nOnly GBT and GSST products are (currently) supported.");
        }
        ((AtsrFile)file).open(inStream, inFile);
        return file;
    }

    private boolean checkByteOrderField(InputStreamReader reader) throws IOException {
        boolean bRet = false;
        char[] field = new char[2];
        reader.read(field, 0, 2);
        if (field[0] == BYTE_ORDER_FIELD[0] && field[1] == BYTE_ORDER_FIELD[1]) {
            bRet = true;
        }
        return bRet;
    }

    private boolean checkProductFileNameField(InputStreamReader reader) throws IOException {
        boolean bRet = false;
        char[] field = new char[60];
        reader.read(field, 0, 60);
        String productName = new String(field);
        for (int n = 0; n < PRODUCT_TYPES.length; ++n) {
            if (-1 == productName.indexOf(PRODUCT_TYPES[n])) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private boolean checkInstrumentField(InputStreamReader reader) throws IOException {
        boolean bRet = false;
        char[] field = new char[6];
        reader.read(field, 0, 6);
        String instrument = new String(field);
        for (int n = 0; n < INSTRUMENTS.length; ++n) {
            if (-1 == instrument.indexOf(INSTRUMENTS[n])) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private String readProductType(ImageInputStream inStream) throws IOException {
        String strRet = null;
        byte[] headerBegin = new byte[60];
        inStream.seek(2L);
        inStream.readFully(headerBegin, 0, headerBegin.length);
        inStream.seek(0L);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(headerBegin));
        char[] fileName = new char[60];
        reader.read(fileName);
        String productName = new String(fileName);
        for (int n = 0; n < PRODUCT_TYPES.length; ++n) {
            if (-1 == productName.indexOf(PRODUCT_TYPES[n])) continue;
            strRet = PRODUCT_TYPES[n];
            break;
        }
        return strRet;
    }

    private static class Holder {
        private static final AtsrFileFactory instance = new AtsrFileFactory();

        private Holder() {
        }
    }
}

