/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.atsr.AtsrBandReader;
import org.esa.beam.dataio.atsr.AtsrHeader;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;

abstract class AtsrFile {
    private ImageInputStream _stream;
    private AtsrHeader _header;
    private File _file;
    private Vector _bands = new Vector();
    private HashMap _bandReader = new HashMap();
    private GeoCoding _geoCoding;

    public void open(ImageInputStream inStream, File file) throws IOException {
        this._stream = inStream;
        this._file = file;
        this.checkByteSwapping();
        this.readHeader();
    }

    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }

    public MetadataElement getMetadata(MetadataElement root) {
        return this._header.getMetadata(root);
    }

    public int getNumTiePointGrids() {
        return this._header.getNumTiePointGrids();
    }

    public TiePointGrid getTiePointGridAt(int nIndex) {
        return this._header.getTiePointGridAt(nIndex);
    }

    public GeoCoding getGeoCoding() {
        return this._geoCoding;
    }

    public String getFileName() {
        return this._header.getFileName();
    }

    public File getFile() {
        return this._file;
    }

    public String getSensorType() {
        return this._header.getSensorType();
    }

    public int getNumBands() {
        return this._bands.size();
    }

    public Band getBandAt(int index) {
        return (Band)this._bands.elementAt(index);
    }

    ImageInputStream getStream() {
        return this._stream;
    }

    AtsrBandReader getReader(Band band) {
        return (AtsrBandReader)this._bandReader.get(band);
    }

    void addBandReader(AtsrBandReader reader) {
        this._bandReader.put(this.getBand(reader.getBandName()), reader);
    }

    private Band getBand(String bandName) {
        for (int i = 0; i < this._bands.size(); ++i) {
            Band band = (Band)this._bands.elementAt(i);
            if (!band.getName().equalsIgnoreCase(bandName)) continue;
            return band;
        }
        return null;
    }

    protected AtsrHeader getHeader() {
        return this._header;
    }

    private void readHeader() throws IOException {
        byte[] rawHeader = new byte[4096];
        this._stream.readFully(rawHeader, 0, rawHeader.length);
        this._header = new AtsrHeader();
        this._header.parse(rawHeader);
    }

    protected void addBand(Band band) {
        this._bands.add(band);
    }

    protected void readLatLonTiePoints(int latOffset, int lonOffset) throws IOException {
        int width = 32;
        int widthInBytes = 2048;
        int height = 32;
        float[] latTiePoints = new float[width * height];
        float[] lonTiePoints = new float[width * height];
        int[] line = new int[512];
        int writeOffset = 0;
        for (int n = 0; n < height; ++n) {
            this._stream.seek(latOffset + n * 16 * widthInBytes);
            this._stream.readFully(line, 0, line.length);
            for (int m = 0; m < width; ++m) {
                latTiePoints[writeOffset] = (float)line[m * 16] * 0.001f;
                ++writeOffset;
            }
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", width, height, 0.0f, 0.0f, 16.0f, 16.0f, latTiePoints);
        latGrid.setDescription("Latitudes of image pixels");
        latGrid.setUnit("dec. deg.");
        this._header.addTiePointGrid(latGrid);
        writeOffset = 0;
        for (int n = 0; n < height; ++n) {
            this._stream.seek(lonOffset + n * 16 * widthInBytes);
            this._stream.readFully(line, 0, line.length);
            for (int m = 0; m < width; ++m) {
                lonTiePoints[writeOffset] = (float)line[m * 16] * 0.001f;
                ++writeOffset;
            }
        }
        TiePointGrid lonGrid = new TiePointGrid("longitude", width, height, 0.0f, 0.0f, 16.0f, 16.0f, lonTiePoints, TiePointGrid.DISCONT_AT_180);
        lonGrid.setDescription("Longitudes of image pixels");
        lonGrid.setUnit("dec. deg.");
        this._header.addTiePointGrid(lonGrid);
        this._geoCoding = new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84);
    }

    protected FlagCoding addCloudAndLandFlagsToCoding(FlagCoding coding) {
        coding.addFlag("LAND", 1, "Pixel is over land");
        coding.addFlag("CLOUDY", 2, "Pixel is cloudy (result of all cloud tests)");
        coding.addFlag("SUN_GLINT", 4, "Sunglint detected in pixel");
        coding.addFlag("CLOUDY_REFL_HIST", 8, "1.6 um reflectance histogram test (day-time only)");
        coding.addFlag("CLOUDY_SPAT_COHER_16", 16, "1.6 um spatial coherence test (day-time only)");
        coding.addFlag("CLOUDY_SPAT_COHER_11", 32, "11 um spatial coherence test");
        coding.addFlag("CLOUDY_GROSS_12", 64, "12 um gross cloud test");
        coding.addFlag("CLOUDY_MED_HI_LEVEL_37_12", 256, "3.7/12 um medium/high level test (night-time only)");
        coding.addFlag("CLOUDY_FOG_LOW_STRATUS_11_37", 512, "11/3.7 um fog/low stratus test (night-time only)");
        coding.addFlag("CLOUDY_VW_DIFF_11_12", 1024, "11/12 um view difference test");
        coding.addFlag("CLOUDY_VW_DIFF_37_11", 2048, "3.7/11 um view difference test (night-time only)");
        coding.addFlag("CLOUDY_THERM_HIST_11_12", 4096, "11/12 um thermal histogram test");
        return coding;
    }

    private void checkByteSwapping() throws IOException {
        this._stream.seek(0L);
        short swap = this._stream.readShort();
        if (swap == 16961) {
            this._stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            this._stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        this._stream.seek(0L);
    }
}

