/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.framework.datamodel.ProductData;

abstract class AtsrBandReader {
    protected String _bandName;
    protected long _startOffset;
    protected long _currentOffset;
    protected float _multiplier;
    protected ImageInputStream _stream;

    AtsrBandReader(String bandName, int offset, float mult, ImageInputStream stream) {
        this._bandName = bandName;
        this._startOffset = offset;
        this._multiplier = mult;
        this._stream = stream;
    }

    String getBandName() {
        return this._bandName;
    }

    abstract void readBandData(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, ProductData var11, ProgressMonitor var12) throws IOException;

    void setStreamPos(int sourceOffsetX, int sourceOffsetY, int pixelSize) throws IOException {
        this._currentOffset = (sourceOffsetY * 512 + sourceOffsetX) * pixelSize;
        this._currentOffset += this._startOffset;
        this._stream.seek(this._currentOffset);
    }

    void updateStreamPos(int delta, int pixelSize) throws IOException {
        this._currentOffset = (int)this._stream.getStreamPosition();
        this._currentOffset += (long)(delta * pixelSize);
        this._stream.seek(this._currentOffset);
    }
}

