/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.TextRecord;

public class TextRecordTest
extends TestCase {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "TextRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("TextRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        TextRecord textRecord = new TextRecord(this._reader);
        this.assertRecord(textRecord);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        TextRecord textRecord = new TextRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(textRecord);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.skipBytes(2);
        ios.writeBytes("PRODUCT:O1B2R_UB                        ");
        ios.writeBytes("PROCESS:JAPAN-JAXA-EOC-ALOS-DPS  20060410075225             ");
        ios.writeBytes("ORBIT:ALPSMB003062950                   ");
        ios.writeBytes("BSQ ");
        CeosTestHelper.writeBlanks(ios, 200);
    }

    private void assertRecord(TextRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        TextRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        TextRecordTest.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
        TextRecordTest.assertEquals((String)"A ", (String)record.getCodeCharacter());
        TextRecordTest.assertEquals((String)"O1B2R_UB", (String)record.getProductID());
        TextRecordTest.assertEquals((String)"PROCESS:JAPAN-JAXA-EOC-ALOS-DPS  20060410075225             ", (String)record.getFacility());
        TextRecordTest.assertEquals((String)"ALPSMB003062950", (String)record.getSceneID());
        TextRecordTest.assertEquals((String)"BSQ ", (String)record.getImageFormat());
    }
}

