/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;

public class CommonFileDescriptorRecordTest
extends TestCase {
    public void testInitCommonFileDescriptorRecord() throws IOException, IllegalCeosFormatException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        String prefix = "fdkjglsdkfhierr.m b9b0970w34";
        ios.writeBytes("fdkjglsdkfhierr.m b9b0970w34");
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        CommonFileDescriptorRecord record = new CommonFileDescriptorRecord(new CeosFileReader((ImageInputStream)ios), (long)"fdkjglsdkfhierr.m b9b0970w34".length());
        CommonFileDescriptorRecordTest.assertRecord(record);
        CommonFileDescriptorRecordTest.assertEquals((long)"fdkjglsdkfhierr.m b9b0970w34".length(), (long)record.getStartPos());
        CommonFileDescriptorRecordTest.assertEquals((long)("fdkjglsdkfhierr.m b9b0970w34".length() + 180), (long)ios.getStreamPosition());
    }

    public static void assertRecord(CommonFileDescriptorRecord record) {
        BaseRecordTest.assertRecord((BaseRecord)record);
        CommonFileDescriptorRecordTest.assertEquals((String)"A ", (String)record.getCodeCharacter());
        CommonFileDescriptorRecordTest.assertEquals((String)"manno       ", (String)record.getFileDocumentNumber());
        CommonFileDescriptorRecordTest.assertEquals((String)"A ", (String)record.getFileDokumentRevisionNumber());
        CommonFileDescriptorRecordTest.assertEquals((String)"A ", (String)record.getFileDesignRevisionLetter());
        CommonFileDescriptorRecordTest.assertEquals((String)"prdsys      ", (String)record.getLogicalVolPrepSysRelNum());
        CommonFileDescriptorRecordTest.assertEquals((int)1, (int)record.getFileNumber());
        CommonFileDescriptorRecordTest.assertEquals((String)"AL PSMB2LEADBSQ ", (String)record.getFileID());
        CommonFileDescriptorRecordTest.assertEquals((String)"FSEQ", (String)record.getFlagRecordComposition());
        CommonFileDescriptorRecordTest.assertEquals((int)1, (int)record.getRecordNumberPositionOfEachFile());
        CommonFileDescriptorRecordTest.assertEquals((int)4, (int)record.getFieldLengthForRecordData());
        CommonFileDescriptorRecordTest.assertEquals((String)"FTYP", (String)record.getFlagOfRecordTypeCode());
        CommonFileDescriptorRecordTest.assertEquals((int)5, (int)record.getRecordTypeCodeBytePosition());
        CommonFileDescriptorRecordTest.assertEquals((int)4, (int)record.getRecordTypeCodeFieldLength());
        CommonFileDescriptorRecordTest.assertEquals((String)"FLGT", (String)record.getFlagRecordLength());
        CommonFileDescriptorRecordTest.assertEquals((int)9, (int)record.getBytePosOfRecLength());
        CommonFileDescriptorRecordTest.assertEquals((int)4, (int)record.getNumOfBytesOfRecLength());
        CommonFileDescriptorRecordTest.assertEquals((String)"N", (String)record.getFlagDataConvInfFileDescRec());
        CommonFileDescriptorRecordTest.assertEquals((String)"O", (String)record.getFlagDataConvInOtherRecords());
        CommonFileDescriptorRecordTest.assertEquals((String)"P", (String)record.getFlagDataDispFileDescRecord());
        CommonFileDescriptorRecordTest.assertEquals((String)"Q", (String)record.getFlagDataDispInOtherRecords());
    }

    public static void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.writeBytes("  ");
        ios.writeBytes("manno       ");
        ios.writeBytes("A ");
        ios.writeBytes("A ");
        ios.writeBytes("prdsys      ");
        ios.writeBytes("   1");
        ios.writeBytes("AL PSMB2LEADBSQ ");
        ios.writeBytes("FSEQ");
        ios.writeBytes("       1");
        ios.writeBytes("   4");
        ios.writeBytes("FTYP");
        ios.writeBytes("       5");
        ios.writeBytes("   4");
        ios.writeBytes("FLGT");
        ios.writeBytes("       9");
        ios.writeBytes("   4");
        ios.writeBytes("N");
        ios.writeBytes("O");
        ios.writeBytes("P");
        ios.writeBytes("Q");
        CeosTestHelper.writeBlanks(ios, 64);
    }
}

