/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.BaseSceneHeaderRecord;

public abstract class BaseSceneHeaderRecordTest
extends TestCase {
    private final int _level1A = 0;
    private final int _level1B1 = 1;
    private final int _level1B2 = 2;
    private String _prefix;
    private ImageOutputStream _ios;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
    }

    public void testInit_Level1A_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios, 0);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        CeosFileReader reader = new CeosFileReader((ImageInputStream)this._ios);
        reader.seek((long)this._prefix.length());
        BaseSceneHeaderRecord record = this.createSceneHeaderRecord(reader);
        this.assertRecord(record, 0);
    }

    protected abstract BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    public void testInit_Level1B1() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios, 1);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        CeosFileReader reader = new CeosFileReader((ImageInputStream)this._ios);
        BaseSceneHeaderRecord record = this.createSceneHeaderRecord(reader, this._prefix.length());
        this.assertRecord(record, 1);
    }

    protected abstract BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    public void testInit_Level1B2() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios, 2);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        CeosFileReader reader = new CeosFileReader((ImageInputStream)this._ios);
        BaseSceneHeaderRecord record = this.createSceneHeaderRecord(reader, this._prefix.length());
        this.assertRecord(record, 2);
    }

    private void assertRecord(BaseSceneHeaderRecord record, int level) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        BaseSceneHeaderRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        BaseSceneHeaderRecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        BaseSceneHeaderRecordTest.assertEquals((int)4, (int)record.getHeaderRecordNumber());
        if (level == 0) {
            BaseSceneHeaderRecordTest.assertEquals((String)"O1A___UB        ", (String)record.getProductId());
            BaseSceneHeaderRecordTest.assertEquals((String)"1A", (String)record.getProductLevel());
        } else if (level == 1) {
            BaseSceneHeaderRecordTest.assertEquals((String)"O1B1__UB        ", (String)record.getProductId());
            BaseSceneHeaderRecordTest.assertEquals((String)"1B1", (String)record.getProductLevel());
        } else if (level == 2) {
            BaseSceneHeaderRecordTest.assertEquals((String)"O1B2R_UB        ", (String)record.getProductId());
            BaseSceneHeaderRecordTest.assertEquals((String)"1B2", (String)record.getProductLevel());
        }
        BaseSceneHeaderRecordTest.assertEquals((String)"uncorrected SCID", (String)record.getUncorrectedSceneId());
        BaseSceneHeaderRecordTest.assertEquals((double)1.2345678, (double)record.getSceneCenterLat_L1A_L1B1(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)2.3456789, (double)record.getSceneCenterLon_L1A_L1B1(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)3.4567891, (double)record.getSceneCenterLineNum_L1A_L1B1(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)4.5678912, (double)record.getSceneCenterPixelNum_L1A_L1B1(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((String)"?pkdfperioerngpeiun?werngpiufver", (String)record.getSceneCenterTime());
        BaseSceneHeaderRecordTest.assertEquals((long)5165486514651865L, (long)record.getTimeOffsetFromNominalRspCenter());
        BaseSceneHeaderRecordTest.assertEquals((String)"dgponronvsdkl   ", (String)record.getRspId());
        BaseSceneHeaderRecordTest.assertEquals((long)9845131842323841L, (long)record.getOrbitsPerCycle());
        BaseSceneHeaderRecordTest.assertEquals((String)"poerpov?md?refui", (String)record.getSceneID_L1B2());
        BaseSceneHeaderRecordTest.assertEquals((double)5.6789123, (double)record.getSceneCenterLat_L1B2(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)6.7891234, (double)record.getSceneCenterLon_L1B2(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)7.8912345, (double)record.getSceneCenterLineNum_L1B2(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)8.9123456, (double)record.getSceneCenterPixelNum_L1B2(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((String)"           NNN.N", (String)record.getOrientationAngle());
        BaseSceneHeaderRecordTest.assertEquals((String)"SNN.N           ", (String)record.getIncidentAngle());
        BaseSceneHeaderRecordTest.assertEquals((String)"ALOS            ", (String)record.getMissionId());
        BaseSceneHeaderRecordTest.assertEquals((String)"PRISM           ", (String)record.getSensorId());
        BaseSceneHeaderRecordTest.assertEquals((long)1231586482315865L, (long)record.getCalcOrbitNo());
        BaseSceneHeaderRecordTest.assertEquals((String)"A               ", (String)record.getOrbitDirection());
        this.assertFields30To31(record);
        BaseSceneHeaderRecordTest.assertEquals((int)2006, (int)record.getDateImageWasTaken().get(1));
        BaseSceneHeaderRecordTest.assertEquals((int)5, (int)record.getDateImageWasTaken().get(2));
        BaseSceneHeaderRecordTest.assertEquals((int)12, (int)record.getDateImageWasTaken().get(5));
        BaseSceneHeaderRecordTest.assertEquals((String)"C LDD-MM/WDDD-MM ", (String)record.getSceneCenterLonLat());
        BaseSceneHeaderRecordTest.assertEquals((String)"XXX BBBB  ", (String)record.getSensorTypeAndSpectrumBandIdentification());
        BaseSceneHeaderRecordTest.assertEquals((String)"SUN ELGGG AHHH", (String)record.getSceneCenterSunAngle());
        BaseSceneHeaderRecordTest.assertEquals((String)"GGP-R-XXX   ", (String)record.getProcessingCode());
        BaseSceneHeaderRecordTest.assertEquals((String)"JAXAALOS    ", (String)record.getCompetentAgentAndProjectIdentification());
        BaseSceneHeaderRecordTest.assertEquals((String)"AABBBCDDDDDEEEE ", (String)record.getSceneId());
        BaseSceneHeaderRecordTest.assertEquals((long)5674L, (long)record.getNumEffectiveBands());
        BaseSceneHeaderRecordTest.assertEquals((long)32000L, (long)record.getNumPixelsPerLineInImage());
        BaseSceneHeaderRecordTest.assertEquals((long)14000L, (long)record.getNumLinesInImage());
        BaseSceneHeaderRecordTest.assertEquals((long)574L, (long)record.getRadiometricResolution());
        BaseSceneHeaderRecordTest.assertEquals((String)"RGD             ", (String)record.getLevel1B2Option());
        BaseSceneHeaderRecordTest.assertEquals((String)"NNYNN           ", (String)record.getResamplingMethod());
        BaseSceneHeaderRecordTest.assertEquals((String)"NNNNY           ", (String)record.getMapProjectionMethod());
        BaseSceneHeaderRecordTest.assertEquals((String)"CORRECTIONLEVEL ", (String)record.getCorrectionLevel());
        BaseSceneHeaderRecordTest.assertEquals((long)147L, (long)record.getNumMapProjAncillaryRecords());
        BaseSceneHeaderRecordTest.assertEquals((long)65L, (long)record.getNumRadiometricAncillaryRecords());
        int[] effektiveBands = record.getEffektiveBands();
        BaseSceneHeaderRecordTest.assertEquals((int)64, (int)effektiveBands.length);
        for (int i = 0; i < effektiveBands.length; ++i) {
            int expected = (i + 1) % 10;
            BaseSceneHeaderRecordTest.assertEquals((int)expected, (int)effektiveBands[i]);
        }
        BaseSceneHeaderRecordTest.assertEquals((String)"BSQ             ", (String)record.getImageFormat());
        BaseSceneHeaderRecordTest.assertEquals((double)16.1111111, (double)record.getSceneCornerUpperLeftLat(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)17.2222222, (double)record.getSceneCornerUpperLeftLon(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)18.3333333, (double)record.getSceneCornerUpperRightLat(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)19.4444444, (double)record.getSceneCornerUpperRightLon(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)20.5555555, (double)record.getSceneCornerLowerLeftLat(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)21.6666666, (double)record.getSceneCornerLowerLeftLon(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)22.7777777, (double)record.getSceneCornerLowerRightLat(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((double)23.8888888, (double)record.getSceneCornerLowerRightLon(), (double)1.0E-8);
        BaseSceneHeaderRecordTest.assertEquals((String)"12", (String)record.getStatusTimeSystem());
        BaseSceneHeaderRecordTest.assertEquals((String)"34", (String)record.getStatusAbsoluteNavigation());
        BaseSceneHeaderRecordTest.assertEquals((String)"56", (String)record.getFlagAttitudeDetermination());
        BaseSceneHeaderRecordTest.assertEquals((String)"78", (String)record.getAccuracyUsedOrbitData());
        BaseSceneHeaderRecordTest.assertEquals((String)"90", (String)record.getAccuracyUsedAttitudeData());
        this.assertFields73ToEnd(record);
    }

    private void writeRecordData(ImageOutputStream ios, int level) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("   4");
        CeosTestHelper.writeBlanks(ios, 4);
        if (level == 0) {
            ios.writeBytes("O1A___UB        ");
        } else if (level == 1) {
            ios.writeBytes("O1B1__UB        ");
        } else if (level == 2) {
            ios.writeBytes("O1B2R_UB        ");
        }
        ios.writeBytes("uncorrected SCID");
        ios.writeBytes("       1.2345678");
        ios.writeBytes("       2.3456789");
        ios.writeBytes("       3.4567891");
        ios.writeBytes("       4.5678912");
        ios.writeBytes("?pkdfperioerngpeiun?werngpiufver");
        ios.writeBytes("5165486514651865");
        ios.writeBytes("dgponronvsdkl   ");
        ios.writeBytes("9845131842323841");
        ios.writeBytes("poerpov?md?refui");
        ios.writeBytes("       5.6789123");
        ios.writeBytes("       6.7891234");
        ios.writeBytes("       7.8912345");
        ios.writeBytes("       8.9123456");
        ios.writeBytes("           NNN.N");
        ios.writeBytes("SNN.N           ");
        ios.writeBytes("ALOS            ");
        ios.writeBytes("PRISM           ");
        ios.writeBytes("1231586482315865");
        ios.writeBytes("A               ");
        this.writeFields30To31(ios);
        CeosTestHelper.writeBlanks(ios, 11);
        ios.writeBytes("12Jun06 ");
        ios.writeBytes("C LDD-MM/WDDD-MM ");
        CeosTestHelper.writeBlanks(ios, 17);
        ios.writeBytes("XXX BBBB  ");
        ios.writeBytes("SUN ELGGG AHHH");
        ios.writeBytes("GGP-R-XXX   ");
        ios.writeBytes("JAXAALOS    ");
        ios.writeBytes("AABBBCDDDDDEEEE ");
        CeosTestHelper.writeBlanks(ios, 906);
        ios.writeBytes("            5674");
        ios.writeBytes("           32000");
        ios.writeBytes("           14000");
        CeosTestHelper.writeBlanks(ios, 16);
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("             574");
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("RGD             ");
        ios.writeBytes("NNYNN           ");
        ios.writeBytes("NNNNY           ");
        ios.writeBytes("CORRECTIONLEVEL ");
        ios.writeBytes("             147");
        ios.writeBytes("              65");
        CeosTestHelper.writeBlanks(ios, 32);
        ios.writeBytes("1234567890123456789012345678901234567890123456789012345678901234");
        ios.writeBytes("BSQ             ");
        ios.writeBytes("      16.1111111");
        ios.writeBytes("      17.2222222");
        ios.writeBytes("      18.3333333");
        ios.writeBytes("      19.4444444");
        ios.writeBytes("      20.5555555");
        ios.writeBytes("      21.6666666");
        ios.writeBytes("      22.7777777");
        ios.writeBytes("      23.8888888");
        ios.writeBytes("12");
        ios.writeBytes("34");
        ios.writeBytes("56");
        ios.writeBytes("78");
        ios.writeBytes("90");
        this.writeFields73ToEnd(ios);
    }

    protected abstract void writeFields30To31(ImageOutputStream var1) throws IOException;

    protected abstract void writeFields73ToEnd(ImageOutputStream var1) throws IOException;

    protected abstract void assertFields30To31(BaseSceneHeaderRecord var1);

    protected abstract void assertFields73ToEnd(BaseSceneHeaderRecord var1);
}

