/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseLeaderFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecordTest;

public abstract class BaseLeaderFileDescriptorRecordTest
extends TestCase {
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        CeosFileReader reader = this._reader;
        BaseLeaderFileDescriptorRecord record = this.createLeaderFDR(reader);
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        CeosFileReader reader = this._reader;
        int startPos = this._prefix.length();
        BaseLeaderFileDescriptorRecord record = this.createLeaderFDR(reader, startPos);
        this.assertRecord(record);
    }

    private void assertRecord(BaseLeaderFileDescriptorRecord record) throws IOException {
        CommonFileDescriptorRecordTest.assertRecord((CommonFileDescriptorRecord)record);
        BaseLeaderFileDescriptorRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        BaseLeaderFileDescriptorRecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        BaseLeaderFileDescriptorRecordTest.assertNotNull((Object)record);
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)1, (int)record.getNumSceneHeaderRecords());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)4680, (int)record.getSceneHeaderRecordLength());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)3, (int)record.getNumAncillaryRecords());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)4680, (int)record.getAncillaryRecordLength());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)1, (int)record.getSceneIdFieldLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)2, (int)record.getSceneIdFieldDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)3, (int)record.getSceneIdFieldNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"A", (String)record.getSceneIdFieldDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)4, (int)record.getRSPIdLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)5, (int)record.getRSPIdDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)6, (int)record.getRSPIdNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"B", (String)record.getRSPIdDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)7, (int)record.getMissionIdLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)8, (int)record.getMissionIdDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)9, (int)record.getMissionIdNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"C", (String)record.getMissionIdDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)10, (int)record.getSensorIdLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)11, (int)record.getSensorIdDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)12, (int)record.getSensorIdNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"D", (String)record.getSensorIdDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)13, (int)record.getSceneCenterTimeLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)14, (int)record.getSceneCenterTimeDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)15, (int)record.getSceneCenterTimeNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"E", (String)record.getSceneCenterTimeDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)16, (int)record.getSceneCenterLatLonLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)17, (int)record.getSceneCenterLatLonDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)18, (int)record.getSceneCenterLatLonNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"F", (String)record.getSceneCenterLatLonDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)19, (int)record.getProcessingLevelLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)20, (int)record.getProcessingLevelDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)21, (int)record.getProcessingLevelNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"G", (String)record.getProcessingLevelDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)22, (int)record.getImageFormatLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)23, (int)record.getImageFormatDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)24, (int)record.getImageFormatNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"H", (String)record.getImageFormatDataType());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)25, (int)record.getEffektiveBandLocator());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)26, (int)record.getEffektiveBandDataStart());
        BaseLeaderFileDescriptorRecordTest.assertEquals((int)27, (int)record.getEffektiveBandNumBytes());
        BaseLeaderFileDescriptorRecordTest.assertEquals((String)"I", (String)record.getEffektiveBandDataType());
        this.assertRecords17To21(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes("     1");
        ios.writeBytes("  4680");
        ios.writeBytes("     3");
        ios.writeBytes("  4680");
        ios.writeBytes("      ");
        ios.writeBytes("      ");
        ios.writeBytes("     1");
        ios.writeBytes("     2");
        ios.writeBytes("  3");
        ios.writeBytes("A");
        ios.writeBytes("     4");
        ios.writeBytes("     5");
        ios.writeBytes("  6");
        ios.writeBytes("B");
        ios.writeBytes("     7");
        ios.writeBytes("     8");
        ios.writeBytes("  9");
        ios.writeBytes("C");
        ios.writeBytes("    10");
        ios.writeBytes("    11");
        ios.writeBytes(" 12");
        ios.writeBytes("D");
        ios.writeBytes("    13");
        ios.writeBytes("    14");
        ios.writeBytes(" 15");
        ios.writeBytes("E");
        ios.writeBytes("    16");
        ios.writeBytes("    17");
        ios.writeBytes(" 18");
        ios.writeBytes("F");
        ios.writeBytes("    19");
        ios.writeBytes("    20");
        ios.writeBytes(" 21");
        ios.writeBytes("G");
        ios.writeBytes("    22");
        ios.writeBytes("    23");
        ios.writeBytes(" 24");
        ios.writeBytes("H");
        ios.writeBytes("    25");
        ios.writeBytes("    26");
        ios.writeBytes(" 27");
        ios.writeBytes("I");
        this.writeFields17To21(ios);
    }

    protected abstract BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract void writeFields17To21(ImageOutputStream var1) throws IOException;

    protected abstract void assertRecords17To21(BaseLeaderFileDescriptorRecord var1);
}

