/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecordTest;

public abstract class BaseImageFileDescriptorRecordTest
extends TestCase {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "AbstractImageFileDescriptorRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("AbstractImageFileDescriptorRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        BaseImageFileDescriptorRecord record = this.createImageFileDescriptorRecord(this._reader);
        BaseImageFileDescriptorRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        BaseImageFileDescriptorRecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        this.assertRecord(record);
    }

    public void testInit() throws IOException, IllegalCeosFormatException {
        BaseImageFileDescriptorRecord record = this.createImageFileDescriptor(this._reader, this._prefix.length());
        BaseImageFileDescriptorRecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        BaseImageFileDescriptorRecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        this.assertRecord(record);
    }

    protected void writeRecordData(ImageOutputStream ios) throws IOException {
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes(" 12546");
        ios.writeBytes(" 12487");
        CeosTestHelper.writeBlanks(ios, 24);
        ios.writeBytes(" 123");
        ios.writeBytes(" 234");
        ios.writeBytes(" 345");
        ios.writeBytes("abcd");
        ios.writeBytes(" 567");
        ios.writeBytes("14587962");
        ios.writeBytes("1245");
        ios.writeBytes("24568954");
        ios.writeBytes("6542");
        ios.writeBytes("5432");
        ios.writeBytes("4321");
        ios.writeBytes("bcde");
        ios.writeBytes(" 852");
        ios.writeBytes(" 963");
        ios.writeBytes(" 741");
        ios.writeBytes("24562583");
        ios.writeBytes(" 987");
        ios.writeBytes("sdef");
        ios.writeBytes("   1 4PB");
        ios.writeBytes("   5 4PB");
        ios.writeBytes("   9 6PB");
        ios.writeBytes("  15 4PB");
        ios.writeBytes("  19 4PB");
        this.writeBytes341To392(ios);
        ios.writeBytes("oiklfd4klsgjopesirmfdlknaoiawef5lkdd");
        ios.writeBytes("BVFR");
        ios.writeBytes(" 753");
        ios.writeBytes(" 357");
        ios.writeBytes(" 242");
        CeosTestHelper.writeBlanks(ios, 4);
        CeosTestHelper.writeBlanks(ios, 8);
        CeosTestHelper.writeBlanks(ios, 8);
        CeosTestHelper.writeBlanks(ios, 4216);
    }

    protected void assertRecord(BaseImageFileDescriptorRecord record) {
        CommonFileDescriptorRecordTest.assertRecord((CommonFileDescriptorRecord)record);
        BaseImageFileDescriptorRecordTest.assertEquals((int)12546, (int)record.getNumImageRecords());
        BaseImageFileDescriptorRecordTest.assertEquals((int)12487, (int)record.getImageRecordLength());
        BaseImageFileDescriptorRecordTest.assertEquals((int)123, (int)record.getNumBitsPerPixel());
        BaseImageFileDescriptorRecordTest.assertEquals((int)234, (int)record.getNumPixelsPerData());
        BaseImageFileDescriptorRecordTest.assertEquals((int)345, (int)record.getNumBytesPerData());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"abcd", (String)record.getBitlistOfPixel());
        BaseImageFileDescriptorRecordTest.assertEquals((int)567, (int)record.getNumBandsPerFile());
        BaseImageFileDescriptorRecordTest.assertEquals((int)14587962, (int)record.getNumLinesPerBand());
        BaseImageFileDescriptorRecordTest.assertEquals((int)1245, (int)record.getNumLeftBorderPixelsPerLine());
        BaseImageFileDescriptorRecordTest.assertEquals((int)24568954, (int)record.getNumImagePixelsPerLine());
        BaseImageFileDescriptorRecordTest.assertEquals((int)6542, (int)record.getNumRightBorderPixelsPerLine());
        BaseImageFileDescriptorRecordTest.assertEquals((int)5432, (int)record.getNumTopBorderLines());
        BaseImageFileDescriptorRecordTest.assertEquals((int)4321, (int)record.getNumBottomBorderLines());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"bcde", (String)record.getImageFormatID());
        BaseImageFileDescriptorRecordTest.assertEquals((int)852, (int)record.getNumRecordsPerLineSingleUnit());
        BaseImageFileDescriptorRecordTest.assertEquals((int)963, (int)record.getNumRecordsPerLine());
        BaseImageFileDescriptorRecordTest.assertEquals((int)741, (int)record.getNumBytesCoverIdentifierAndHeader());
        BaseImageFileDescriptorRecordTest.assertEquals((int)24562583, (int)record.getNumImgDataBytesPerRecAndDummyPix());
        BaseImageFileDescriptorRecordTest.assertEquals((int)987, (int)record.getNumBytesOfSuffixDataPerRecord());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"sdef", (String)record.getFlagPrefixDataRepeat());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"   1 4PB", (String)record.getLocatorLineNumber());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"   5 4PB", (String)record.getLocatorBandNumber());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"   9 6PB", (String)record.getLocatorScanStartTime());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"  15 4PB", (String)record.getLocatorLeftDummyPixel());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"  19 4PB", (String)record.getLocatorRightDummyPixel());
        this.assertBytes341To392(record);
        BaseImageFileDescriptorRecordTest.assertEquals((String)"oiklfd4klsgjopesirmfdlknaoiawef5lkdd", (String)record.getDataFormatTypeId());
        BaseImageFileDescriptorRecordTest.assertEquals((String)"BVFR", (String)record.getDataFormatTypeIdCode());
        BaseImageFileDescriptorRecordTest.assertEquals((int)753, (int)record.getNumLeftUnusedBitsInPixelData());
        BaseImageFileDescriptorRecordTest.assertEquals((int)357, (int)record.getNumRightUnusedBitsInPixelData());
        BaseImageFileDescriptorRecordTest.assertEquals((int)242, (int)record.getMaxPixelDataValue());
    }

    protected abstract BaseImageFileDescriptorRecord createImageFileDescriptorRecord(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract BaseImageFileDescriptorRecord createImageFileDescriptor(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract void writeBytes341To392(ImageOutputStream var1) throws IOException;

    protected abstract void assertBytes341To392(BaseImageFileDescriptorRecord var1);
}

