/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.Ancillary2Record;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;

public abstract class Ancillary2RecordTest
extends TestCase {
    private static final int RECORD_LENGTH = 4680;
    private MemoryCacheImageOutputStream _ios;
    protected String _prefix;
    private CeosFileReader _reader;

    protected void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    public void testInitRecord_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader.seek((long)this._prefix.length());
        Ancillary2Record record = this.createAncillary2Record(this._reader);
        this.assertRecord(record);
    }

    public void testInitRecord() throws IOException, IllegalCeosFormatException {
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        Ancillary2Record record = this.createAncillary2Record(this._reader, this._prefix.length());
        this.assertRecord(record);
    }

    protected abstract Ancillary2Record createAncillary2Record(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract Ancillary2Record createAncillary2Record(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract void writeSpecificRecordData(MemoryCacheImageOutputStream var1) throws IOException;

    protected abstract void assertSpecificRecordData(Ancillary2Record var1);

    private void writeRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("OB4 ");
        ios.writeBytes("1234");
        ios.writeBytes("3241");
        CeosTestHelper.writeBlanks(ios, 32);
        ios.writeBytes("abcdef");
        this.writeSpecificRecordData(ios);
    }

    private void assertRecord(Ancillary2Record record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Ancillary2RecordTest.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Ancillary2RecordTest.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        Ancillary2RecordTest.assertEquals((String)"OB4 ", (String)record.getSensorOperationMode());
        Ancillary2RecordTest.assertEquals((int)1234, (int)record.getLowerLimitOfStrengthAfterCorrection());
        Ancillary2RecordTest.assertEquals((int)3241, (int)record.getUpperLimitOfStrengthAfterCorrection());
        Ancillary2RecordTest.assertEquals((String)"abcdef", (String)record.getSensorGains());
        this.assertSpecificRecordData(record);
    }
}

