/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.prism.records.TrailerRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecordTest;

public class TrailerRecordTest
extends BaseTrailerRecordTest {
    @Override
    protected BaseTrailerRecord createTrailerRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new TrailerRecord(reader);
    }

    @Override
    protected BaseTrailerRecord createTrailerRecord(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new TrailerRecord(reader, (long)startPos);
    }

    @Override
    protected void writeHistograms(ImageOutputStream ios) throws IOException {
        for (int i = 0; i < 8000; i += 1000) {
            for (int j = 0; j < 256; ++j) {
                ios.writeInt(i + j);
            }
        }
    }

    @Override
    protected void assertHistograms(BaseTrailerRecord record) {
        TrailerRecord trailerRecord = (TrailerRecord)record;
        for (int i = 0; i < 8000; i += 1000) {
            int ccdNumber = i / 1000 + 1;
            int[] histoForCCD = trailerRecord.getHistogramFor(ccdNumber);
            for (int j = 0; j < 256; ++j) {
                TrailerRecordTest.assertEquals((int)(i + j), (int)histoForCCD[j]);
            }
        }
    }
}

