/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.prism.records.ImageFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecordTest;

public class ImageFileDescriptorRecordTest
extends BaseImageFileDescriptorRecordTest {
    @Override
    protected BaseImageFileDescriptorRecord createImageFileDescriptorRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new ImageFileDescriptorRecord(reader);
    }

    @Override
    protected BaseImageFileDescriptorRecord createImageFileDescriptor(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new ImageFileDescriptorRecord(reader, (long)startPos);
    }

    @Override
    protected void writeBytes341To392(ImageOutputStream ios) throws IOException {
        ios.writeBytes("   148SB");
        ios.writeBytes("  4912SB");
        ios.writeBytes("  61 4SB");
        CeosTestHelper.writeBlanks(ios, 28);
    }

    @Override
    protected void assertBytes341To392(BaseImageFileDescriptorRecord record) {
        ImageFileDescriptorRecord imageFileDescriptorRecord = (ImageFileDescriptorRecord)record;
        ImageFileDescriptorRecordTest.assertEquals((String)"   148SB", (String)imageFileDescriptorRecord.getLocatorAUXData());
        ImageFileDescriptorRecordTest.assertEquals((String)"  4912SB", (String)imageFileDescriptorRecord.getLocatorQualityInformation());
        ImageFileDescriptorRecordTest.assertEquals((String)"  61 4SB", (String)imageFileDescriptorRecord.getLocatorExtractionStartPoint());
    }
}

