/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2LeaderFDR;
import org.esa.s3tbx.dataio.ceos.records.BaseLeaderFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseLeaderFileDescriptorRecordTest;

public class Avnir2LeaderFDRTest
extends BaseLeaderFileDescriptorRecordTest {
    @Override
    protected BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new Avnir2LeaderFDR(reader, (long)startPos);
    }

    @Override
    protected BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new Avnir2LeaderFDR(reader);
    }

    @Override
    protected void writeFields17To21(ImageOutputStream ios) throws IOException {
        ios.writeBytes("                ");
        ios.writeBytes("     3");
        ios.writeBytes("   541");
        ios.writeBytes(" 32");
        ios.writeBytes("N");
        ios.writeBytes("                ");
        ios.writeBytes("                ");
        char[] blanks = new char[4256];
        Arrays.fill(blanks, ' ');
        ios.writeBytes(new String(blanks));
    }

    @Override
    protected void assertRecords17To21(BaseLeaderFileDescriptorRecord record) {
        Avnir2LeaderFDR avnir2Record = (Avnir2LeaderFDR)record;
        Avnir2LeaderFDRTest.assertEquals((long)3L, (long)avnir2Record.getPixelSizeLocator());
        Avnir2LeaderFDRTest.assertEquals((long)541L, (long)avnir2Record.getPixelSizeLocatorDataStart());
        Avnir2LeaderFDRTest.assertEquals((long)32L, (long)avnir2Record.getPixelSizeLocatorNumBytes());
        Avnir2LeaderFDRTest.assertEquals((String)"N", (String)avnir2Record.getPixelSizeLocatorDataType());
    }
}

