/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.sst;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.esa.s3tbx.aatsr.sst.SstCoefficientLoader;
import org.esa.s3tbx.aatsr.sst.SstCoefficientSet;
import org.esa.s3tbx.aatsr.sst.SstCoefficients;
import org.esa.snap.core.gpf.OperatorException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SstCoefficientLoaderTest {
    private static final String expNadirDesc = "test coefficients nadir";
    private static final String expDualDesc = "test coefficients dual";
    private SstCoefficientLoader loader;

    @Before
    public void setUp() {
        this.loader = new SstCoefficientLoader();
        Assert.assertNotNull((Object)this.loader);
    }

    @Test
    public void testLoadWithInvalidArguments() throws IOException {
        try {
            this.loader.load(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL noneExistent = this.createNonExistentUrl();
        try {
            this.loader.load(noneExistent);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadCorrectFile() throws IOException, URISyntaxException {
        URL nadirCoeff = this.createNadirCoeffUrl();
        URL dualCoeff = this.createDualCoeffUrl();
        SstCoefficientSet coeffs = this.loader.load(nadirCoeff);
        Assert.assertNotNull((Object)coeffs);
        coeffs = this.loader.load(dualCoeff);
        Assert.assertNotNull((Object)coeffs);
    }

    @Test
    public void testNadirStuffCorrectRead() throws IOException, URISyntaxException {
        int n;
        int n2;
        URL nadirCoeff = this.createNadirCoeffUrl();
        SstCoefficientSet coeffSet = this.loader.load(nadirCoeff);
        Assert.assertNotNull((Object)coeffSet);
        Assert.assertEquals((Object)expNadirDesc, (Object)coeffSet.getDescription());
        Assert.assertEquals((long)2L, (long)coeffSet.getNumCoefficients());
        SstCoefficients coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        Assert.assertEquals((long)0L, (long)coeffs.getStart());
        Assert.assertEquals((long)124L, (long)coeffs.getEnd());
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        Assert.assertEquals((long)125L, (long)coeffs.getStart());
        Assert.assertEquals((long)511L, (long)coeffs.getEnd());
        float[] exp_a_one = new float[]{1.23f, 2.34f, 3.45f};
        float[] exp_a_two = new float[]{0.12f, 1.23f, 2.34f};
        coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        float[] a_coeffs = coeffs.get_A_Coeffs();
        Assert.assertNotNull((Object)a_coeffs);
        Assert.assertEquals((long)3L, (long)a_coeffs.length);
        for (n2 = 0; n2 < a_coeffs.length; ++n2) {
            Assert.assertEquals((double)exp_a_one[n2], (double)a_coeffs[n2], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        a_coeffs = coeffs.get_A_Coeffs();
        Assert.assertNotNull((Object)a_coeffs);
        Assert.assertEquals((long)3L, (long)a_coeffs.length);
        for (n2 = 0; n2 < a_coeffs.length; ++n2) {
            Assert.assertEquals((double)exp_a_two[n2], (double)a_coeffs[n2], (double)1.0E-6);
        }
        float[] exp_b_one = new float[]{5.67f, 6.78f, 8.89f, 8.9f};
        float[] exp_b_two = new float[]{3.45f, 4.56f, 5.67f, 6.78f};
        coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        float[] b_coeffs = coeffs.get_B_Coeffs();
        Assert.assertNotNull((Object)b_coeffs);
        Assert.assertEquals((long)4L, (long)b_coeffs.length);
        for (n = 0; n < b_coeffs.length; ++n) {
            Assert.assertEquals((double)exp_b_one[n], (double)b_coeffs[n], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        b_coeffs = coeffs.get_B_Coeffs();
        Assert.assertNotNull((Object)b_coeffs);
        Assert.assertEquals((long)4L, (long)b_coeffs.length);
        for (n = 0; n < b_coeffs.length; ++n) {
            Assert.assertEquals((double)exp_b_two[n], (double)b_coeffs[n], (double)1.0E-6);
        }
        Assert.assertNull((Object)coeffs.get_C_Coeffs());
        Assert.assertNull((Object)coeffs.get_D_Coeffs());
    }

    @Test
    public void testDualStuffCorrectRead() throws IOException, URISyntaxException {
        int n;
        int n2;
        URL dualCoeff = this.createDualCoeffUrl();
        SstCoefficientSet coeffSet = this.loader.load(dualCoeff);
        Assert.assertNotNull((Object)coeffSet);
        Assert.assertEquals((Object)expDualDesc, (Object)coeffSet.getDescription());
        Assert.assertEquals((long)2L, (long)coeffSet.getNumCoefficients());
        SstCoefficients coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        Assert.assertEquals((long)0L, (long)coeffs.getStart());
        Assert.assertEquals((long)255L, (long)coeffs.getEnd());
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        Assert.assertEquals((long)256L, (long)coeffs.getStart());
        Assert.assertEquals((long)511L, (long)coeffs.getEnd());
        float[] exp_c_one = new float[]{1.23f, 2.34f, 3.45f, 4.56f, 5.67f};
        float[] exp_c_two = new float[]{3.45f, 4.56f, 5.67f, 6.78f, 7.89f};
        coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        float[] c_coeffs = coeffs.get_C_Coeffs();
        Assert.assertNotNull((Object)c_coeffs);
        Assert.assertEquals((long)5L, (long)c_coeffs.length);
        for (n2 = 0; n2 < c_coeffs.length; ++n2) {
            Assert.assertEquals((double)exp_c_one[n2], (double)c_coeffs[n2], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        c_coeffs = coeffs.get_C_Coeffs();
        Assert.assertNotNull((Object)c_coeffs);
        Assert.assertEquals((long)5L, (long)c_coeffs.length);
        for (n2 = 0; n2 < c_coeffs.length; ++n2) {
            Assert.assertEquals((double)exp_c_two[n2], (double)c_coeffs[n2], (double)1.0E-6);
        }
        float[] exp_d_one = new float[]{6.78f, 7.89f, 8.9f, 9.01f, 0.12f, 1.23f, 2.34f};
        float[] exp_d_two = new float[]{8.9f, 9.01f, 0.12f, 1.23f, 2.34f, 3.45f, 4.56f};
        coeffs = coeffSet.getCoefficientsAt(0);
        Assert.assertNotNull((Object)coeffs);
        float[] d_coeffs = coeffs.get_D_Coeffs();
        Assert.assertNotNull((Object)d_coeffs);
        Assert.assertEquals((long)7L, (long)d_coeffs.length);
        for (n = 0; n < d_coeffs.length; ++n) {
            Assert.assertEquals((double)exp_d_one[n], (double)d_coeffs[n], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        Assert.assertNotNull((Object)coeffs);
        d_coeffs = coeffs.get_D_Coeffs();
        Assert.assertNotNull((Object)d_coeffs);
        Assert.assertEquals((long)7L, (long)d_coeffs.length);
        for (n = 0; n < d_coeffs.length; ++n) {
            Assert.assertEquals((double)exp_d_two[n], (double)d_coeffs[n], (double)1.0E-6);
        }
    }

    @Test
    public void testNoDescriptionCorrectRead() throws IOException, URISyntaxException {
        URL noDescFile = this.createNoDescriptionCoeffUrl();
        SstCoefficientSet coeffs = this.loader.load(noDescFile);
        Assert.assertNotNull((Object)coeffs);
        Assert.assertEquals((Object)"", (Object)coeffs.getDescription());
    }

    @Test
    public void testIncorrectNumberOfMaps() throws IOException, URISyntaxException {
        URL illegalFile = this.createOneMapTooMuchUrl();
        try {
            this.loader.load(illegalFile);
            Assert.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        illegalFile = this.createMapOverlapUrl();
        try {
            this.loader.load(illegalFile);
            Assert.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        illegalFile = this.create_A_and_D_Url();
        try {
            this.loader.load(illegalFile);
            Assert.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadDescriptionInterface() throws IOException {
        try {
            this.loader.getDescription(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL nonExistent = this.createNonExistentUrl();
        String description = this.loader.getDescription(nonExistent);
        Assert.assertEquals((Object)"", (Object)description);
    }

    @Test
    public void testLoadDescription() throws IOException, URISyntaxException {
        URL url = this.createDualCoeffUrl();
        String description = this.loader.getDescription(url);
        Assert.assertEquals((Object)expDualDesc, (Object)description);
        url = this.createNadirCoeffUrl();
        description = this.loader.getDescription(url);
        Assert.assertEquals((Object)expNadirDesc, (Object)description);
    }

    private URL createNonExistentUrl() throws MalformedURLException {
        return new URL("file", "", "n:\nonexistentTestFile");
    }

    private URL createNadirCoeffUrl() throws MalformedURLException, URISyntaxException {
        File nadirCoeff = this.getTestFile("sstTestCoefficientsNadir.coef");
        Assert.assertEquals((Object)true, (Object)nadirCoeff.exists());
        return nadirCoeff.toURI().toURL();
    }

    private URL createDualCoeffUrl() throws MalformedURLException, URISyntaxException {
        File dualCoeff = this.getTestFile("sstTestCoefficientsDual.coef");
        Assert.assertEquals((Object)true, (Object)dualCoeff.exists());
        return dualCoeff.toURI().toURL();
    }

    private URL createNoDescriptionCoeffUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestCoefficientsNoDescription.coef");
        Assert.assertEquals((Object)true, (Object)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL createOneMapTooMuchUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestOneMapTooMuch.coef");
        Assert.assertEquals((Object)true, (Object)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL createMapOverlapUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestMapRangeOverlap.coef");
        Assert.assertEquals((Object)true, (Object)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL create_A_and_D_Url() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTest_a_and_d.coef");
        Assert.assertEquals((Object)true, (Object)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private File getTestFile(String s) throws URISyntaxException, MalformedURLException {
        URL resource = this.getClass().getResource(s);
        String encodedUrl = resource.toString().replace(" ", "%20");
        resource = new URL(encodedUrl);
        return new File(resource.toURI());
    }
}

