/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.sst;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import org.esa.s3tbx.aatsr.sst.SstCoefficientSet;
import org.esa.s3tbx.aatsr.sst.SstCoefficients;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;

public class SstCoefficientLoader {
    private static final String _descriptionKey = "description";
    private static final String _mapKeyStub = "map.";
    private static final String _aKeyStub = "a.";
    private static final String _bKeyStub = "b.";
    private static final String _cKeyStub = "c.";
    private static final String _dKeyStub = "d.";
    private static final char[] _separators = new char[]{','};
    private Properties _props = new Properties();
    private static final int _numACoeffs = 3;
    private static final int _numBCoeffs = 4;
    private static final int _numCCoeffs = 5;
    private static final int _numDCoeffs = 7;
    private Logger _logger = Logger.getLogger("beam.processor.sst");

    public SstCoefficientSet load(URL coeffFile) throws IOException {
        Guardian.assertNotNull((String)"coeffFile", (Object)coeffFile);
        this._logger.fine("Reading coefficient file: '" + coeffFile.getPath() + "'");
        this._props.clear();
        try (InputStream inStream = coeffFile.openStream();){
            this._props.load(inStream);
        }
        SstCoefficientSet set = new SstCoefficientSet();
        this.addDescription(set);
        this.addCoefficients(set);
        this.verify(set);
        this._logger.fine("... success");
        return set;
    }

    public String getDescription(URL coeffFile) throws IOException {
        Guardian.assertNotNull((String)"coeffFile", (Object)coeffFile);
        String desc = "";
        File file = null;
        try {
            file = new File(coeffFile.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (file != null && file.exists() && file.isFile()) {
            FileInputStream inStream = new FileInputStream(file);
            this._props.load(inStream);
            ((InputStream)inStream).close();
            desc = this._props.getProperty(_descriptionKey);
        }
        return desc;
    }

    private void addDescription(SstCoefficientSet set) {
        String description = this._props.getProperty(_descriptionKey);
        if (description != null) {
            set.setDescription(description);
            this._logger.fine("... coefficients description: '" + description + "'");
        } else {
            this._logger.fine("... coefficients have no description");
        }
    }

    private void addCoefficients(SstCoefficientSet set) {
        String value;
        int index = 0;
        String mapKey = _mapKeyStub + index;
        String aKey = _aKeyStub + index;
        String bKey = _bKeyStub + index;
        String cKey = _cKeyStub + index;
        String dKey = _dKeyStub + index;
        while ((value = this._props.getProperty(mapKey)) != null) {
            SstCoefficients coeffs = new SstCoefficients();
            SstCoefficientLoader.loadMapStringToCoefficients(value, coeffs);
            value = this._props.getProperty(aKey);
            if (value != null) {
                SstCoefficientLoader.load_A_ToCoefficients(value, coeffs);
            }
            if ((value = this._props.getProperty(bKey)) != null) {
                SstCoefficientLoader.load_B_ToCoefficients(value, coeffs);
            }
            if ((value = this._props.getProperty(cKey)) != null) {
                SstCoefficientLoader.load_C_ToCoefficients(value, coeffs);
            }
            if ((value = this._props.getProperty(dKey)) != null) {
                SstCoefficientLoader.load_D_ToCoefficients(value, coeffs);
            }
            set.addCoefficients(coeffs);
            mapKey = _mapKeyStub + ++index;
            aKey = _aKeyStub + index;
            bKey = _bKeyStub + index;
            cKey = _cKeyStub + index;
            dKey = _dKeyStub + index;
        }
    }

    private static void loadMapStringToCoefficients(String map, SstCoefficients coeffs) {
        String[] rangeStrings = StringUtils.split((String)map, (char[])_separators, (boolean)true);
        if (rangeStrings.length != 2) {
            throw new OperatorException("illegal coefficient file format: map.x must have two values");
        }
        coeffs.setRange(Integer.parseInt(rangeStrings[0]), Integer.parseInt(rangeStrings[1]));
    }

    private static void load_A_ToCoefficients(String a_values, SstCoefficients coeffs) {
        String[] aStrings = StringUtils.split((String)a_values, (char[])_separators, (boolean)true);
        if (aStrings.length != 3) {
            throw new OperatorException("illegal coefficient file format: a.x must have 3 values");
        }
        float[] aCoeffs = new float[aStrings.length];
        for (int n = 0; n < aStrings.length; ++n) {
            aCoeffs[n] = Float.parseFloat(aStrings[n]);
        }
        coeffs.set_A_Coeffs(aCoeffs);
    }

    private static void load_B_ToCoefficients(String b_values, SstCoefficients coeffs) {
        String[] bStrings = StringUtils.split((String)b_values, (char[])_separators, (boolean)true);
        if (bStrings.length != 4) {
            throw new OperatorException("illegal coefficient file format: b.x must have 4 values");
        }
        float[] bCoeffs = new float[bStrings.length];
        for (int n = 0; n < bStrings.length; ++n) {
            bCoeffs[n] = Float.parseFloat(bStrings[n]);
        }
        coeffs.set_B_Coeffs(bCoeffs);
    }

    private static void load_C_ToCoefficients(String c_values, SstCoefficients coeffs) {
        String[] cStrings = StringUtils.split((String)c_values, (char[])_separators, (boolean)true);
        if (cStrings.length != 5) {
            throw new OperatorException("illegal coefficient file format: c.x must have 5 values");
        }
        float[] cCoeffs = new float[cStrings.length];
        for (int n = 0; n < cStrings.length; ++n) {
            cCoeffs[n] = Float.parseFloat(cStrings[n]);
        }
        coeffs.set_C_Coeffs(cCoeffs);
    }

    private static void load_D_ToCoefficients(String d_values, SstCoefficients coeffs) {
        String[] dStrings = StringUtils.split((String)d_values, (char[])_separators, (boolean)true);
        if (dStrings.length != 7) {
            throw new OperatorException("illegal coefficient file format: d.x must have 7 values");
        }
        float[] dCoeffs = new float[dStrings.length];
        for (int n = 0; n < dStrings.length; ++n) {
            dCoeffs[n] = Float.parseFloat(dStrings[n]);
        }
        coeffs.set_D_Coeffs(dCoeffs);
    }

    private void verify(SstCoefficientSet set) {
        SstCoefficients coeffs;
        int nMaps = set.getNumCoefficients();
        int nExpStart = 0;
        for (int n = 0; n < nMaps; ++n) {
            coeffs = set.getCoefficientsAt(n);
            int nStart = coeffs.getStart();
            int nEnd = coeffs.getEnd();
            if (nStart < 0 || nEnd < 0 || nEnd < nStart) {
                throw new OperatorException("illegal coefficient file: map." + n + " start: " + nStart + " end: " + nEnd);
            }
            if (nStart != nExpStart) {
                throw new OperatorException("illegal coefficient file: map." + n + " expected start: " + nExpStart + " actual: " + nStart);
            }
            nExpStart = nEnd + 1;
            this._logger.finest("... map." + n + " : " + nStart + " - " + nEnd);
        }
        boolean bHasCoeffs = false;
        for (int n = 0; n < nMaps; ++n) {
            float[] testTwo;
            coeffs = set.getCoefficientsAt(n);
            float[] testOne = coeffs.get_A_Coeffs();
            if (testOne != null) {
                bHasCoeffs = true;
                testTwo = coeffs.get_B_Coeffs();
                if (testTwo == null) {
                    throw new OperatorException("illegal coefficient file: map." + n + "has a coefficients but no b coefficient set");
                }
                this._logger.finest("... a." + n + " : " + StringUtils.arrayToCsv((Object)testOne));
                this._logger.finest("... b." + n + " : " + StringUtils.arrayToCsv((Object)testTwo));
            }
            if ((testOne = coeffs.get_C_Coeffs()) != null) {
                bHasCoeffs = true;
                testTwo = coeffs.get_D_Coeffs();
                if (testTwo == null) {
                    throw new OperatorException("illegal coefficient file: map." + n + "has c coefficients but no d coefficient set");
                }
                this._logger.finest("... c." + n + " : " + StringUtils.arrayToCsv((Object)testOne));
                this._logger.finest("... d." + n + " : " + StringUtils.arrayToCsv((Object)testTwo));
            }
            if (!bHasCoeffs) {
                throw new OperatorException("illegal coefficient file: map." + n + " has neither a not c coefficients");
            }
            bHasCoeffs = false;
        }
    }
}

