/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.sst;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.s3tbx.aatsr.sst.SstCoefficients;

public class SstCoefficientsTest
extends TestCase {
    public SstCoefficientsTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(SstCoefficientsTest.class);
    }

    public void testDefaultConstructor() {
        SstCoefficients coeffs = new SstCoefficients();
        SstCoefficientsTest.assertEquals((int)0, (int)coeffs.getStart());
        SstCoefficientsTest.assertEquals((int)0, (int)coeffs.getEnd());
        SstCoefficientsTest.assertNull((Object)coeffs.get_A_Coeffs());
        SstCoefficientsTest.assertNull((Object)coeffs.get_B_Coeffs());
        SstCoefficientsTest.assertNull((Object)coeffs.get_C_Coeffs());
        SstCoefficientsTest.assertNull((Object)coeffs.get_D_Coeffs());
    }

    public void testParameterConstructor() {
        int start = 12;
        int end = 34;
        SstCoefficients range = new SstCoefficients(start, end);
        SstCoefficientsTest.assertEquals((int)start, (int)range.getStart());
        SstCoefficientsTest.assertEquals((int)end, (int)range.getEnd());
        start = 34;
        end = 8;
        try {
            range = new SstCoefficients(start, end);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetGetRange() {
        SstCoefficients range = new SstCoefficients();
        SstCoefficientsTest.assertEquals((int)0, (int)range.getStart());
        SstCoefficientsTest.assertEquals((int)0, (int)range.getEnd());
        int start = 12;
        int end = 13;
        range.setRange(start, end);
        SstCoefficientsTest.assertEquals((int)start, (int)range.getStart());
        SstCoefficientsTest.assertEquals((int)end, (int)range.getEnd());
        start = 34;
        end = 8;
        try {
            range.setRange(start, end);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetGetACoefficients() {
        SstCoefficients coeffs = new SstCoefficients();
        SstCoefficientsTest.assertEquals(null, (Object)coeffs.get_A_Coeffs());
        try {
            coeffs.set_A_Coeffs(null);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float[] one = new float[]{1.0f, 2.0f, 3.0f};
        float[] two = new float[]{4.0f, 5.0f, 6.0f};
        coeffs.set_A_Coeffs(one);
        SstCoefficientsTest.assertEquals((Object)one, (Object)coeffs.get_A_Coeffs());
        coeffs.set_A_Coeffs(two);
        SstCoefficientsTest.assertEquals((Object)two, (Object)coeffs.get_A_Coeffs());
    }

    public void testSetGetBCoefficients() {
        SstCoefficients coeffs = new SstCoefficients();
        SstCoefficientsTest.assertEquals(null, (Object)coeffs.get_B_Coeffs());
        try {
            coeffs.set_B_Coeffs(null);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float[] one = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        float[] two = new float[]{5.0f, 6.0f, 7.0f, 8.0f};
        coeffs.set_B_Coeffs(one);
        SstCoefficientsTest.assertEquals((Object)one, (Object)coeffs.get_B_Coeffs());
        coeffs.set_B_Coeffs(two);
        SstCoefficientsTest.assertEquals((Object)two, (Object)coeffs.get_B_Coeffs());
    }

    public void testSetGetCCoefficients() {
        SstCoefficients coeffs = new SstCoefficients();
        SstCoefficientsTest.assertEquals(null, (Object)coeffs.get_C_Coeffs());
        try {
            coeffs.set_C_Coeffs(null);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float[] one = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        float[] two = new float[]{6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
        coeffs.set_C_Coeffs(one);
        SstCoefficientsTest.assertEquals((Object)one, (Object)coeffs.get_C_Coeffs());
        coeffs.set_C_Coeffs(two);
        SstCoefficientsTest.assertEquals((Object)two, (Object)coeffs.get_C_Coeffs());
    }

    public void testSetGetDCoefficients() {
        SstCoefficients coeffs = new SstCoefficients();
        SstCoefficientsTest.assertEquals(null, (Object)coeffs.get_D_Coeffs());
        try {
            coeffs.set_D_Coeffs(null);
            SstCoefficientsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float[] one = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f};
        float[] two = new float[]{8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f};
        coeffs.set_D_Coeffs(one);
        SstCoefficientsTest.assertEquals((Object)one, (Object)coeffs.get_D_Coeffs());
        coeffs.set_D_Coeffs(two);
        SstCoefficientsTest.assertEquals((Object)two, (Object)coeffs.get_D_Coeffs());
    }
}

