/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.sst;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.s3tbx.aatsr.sst.SstCoefficientSet;
import org.esa.s3tbx.aatsr.sst.SstCoefficients;

public class SstCoefficientSetTest
extends TestCase {
    private SstCoefficientSet _set;

    public SstCoefficientSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(SstCoefficientSetTest.class);
    }

    protected void setUp() {
        this._set = new SstCoefficientSet();
        SstCoefficientSetTest.assertNotNull((Object)this._set);
    }

    public void testSetGetDescription() {
        String desc1 = "A coefficient description";
        String desc2 = "Another coefficient description";
        SstCoefficientSetTest.assertEquals((String)"", (String)this._set.getDescription());
        try {
            this._set.setDescription(null);
            SstCoefficientSetTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this._set.setDescription(desc1);
        SstCoefficientSetTest.assertEquals((String)desc1, (String)this._set.getDescription());
        this._set.setDescription(desc2);
        SstCoefficientSetTest.assertEquals((String)desc2, (String)this._set.getDescription());
    }

    public void testAddGetCoefficients() {
        SstCoefficients coeffs1 = new SstCoefficients(1, 2);
        SstCoefficients coeffs2 = new SstCoefficients(3, 5);
        SstCoefficients coeffs3 = new SstCoefficients(6, 11);
        SstCoefficientSetTest.assertEquals((int)0, (int)this._set.getNumCoefficients());
        try {
            this._set.addCoefficients(null);
            SstCoefficientSetTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this._set.addCoefficients(coeffs1);
        SstCoefficientSetTest.assertEquals((int)1, (int)this._set.getNumCoefficients());
        SstCoefficientSetTest.assertEquals((Object)coeffs1, (Object)this._set.getCoefficientsAt(0));
        this._set.addCoefficients(coeffs2);
        SstCoefficientSetTest.assertEquals((int)2, (int)this._set.getNumCoefficients());
        SstCoefficientSetTest.assertEquals((Object)coeffs2, (Object)this._set.getCoefficientsAt(1));
        this._set.addCoefficients(coeffs3);
        SstCoefficientSetTest.assertEquals((int)3, (int)this._set.getNumCoefficients());
        SstCoefficientSetTest.assertEquals((Object)coeffs3, (Object)this._set.getCoefficientsAt(2));
        try {
            this._set.getCoefficientsAt(-3);
            SstCoefficientSetTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._set.getCoefficientsAt(12);
            SstCoefficientSetTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

