/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.sst;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.s3tbx.aatsr.sst.SstCoefficientLoader;
import org.esa.s3tbx.aatsr.sst.SstCoefficientSet;
import org.esa.s3tbx.aatsr.sst.SstCoefficients;
import org.esa.snap.core.gpf.OperatorException;

public class SstCoefficientLoaderTest
extends TestCase {
    private static final String expNadirDesc = "test coefficients nadir";
    private static final String expDualDesc = "test coefficients dual";
    private SstCoefficientLoader loader;

    public SstCoefficientLoaderTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(SstCoefficientLoaderTest.class);
    }

    protected void setUp() {
        this.loader = new SstCoefficientLoader();
        SstCoefficientLoaderTest.assertNotNull((Object)this.loader);
    }

    public void testLoadWithInvalidArguments() throws IOException {
        try {
            this.loader.load(null);
            SstCoefficientLoaderTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL noneExistent = this.createNonExistentUrl();
        try {
            this.loader.load(noneExistent);
            SstCoefficientLoaderTest.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testLoadCorrectFile() throws IOException, URISyntaxException {
        URL nadirCoeff = this.createNadirCoeffUrl();
        URL dualCoeff = this.createDualCoeffUrl();
        SstCoefficientSet coeffs = this.loader.load(nadirCoeff);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        coeffs = this.loader.load(dualCoeff);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
    }

    public void testNadirStuffCorrectRead() throws IOException, URISyntaxException {
        int n;
        int n2;
        URL nadirCoeff = this.createNadirCoeffUrl();
        SstCoefficientSet coeffSet = this.loader.load(nadirCoeff);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffSet);
        SstCoefficientLoaderTest.assertEquals((String)expNadirDesc, (String)coeffSet.getDescription());
        SstCoefficientLoaderTest.assertEquals((int)2, (int)coeffSet.getNumCoefficients());
        SstCoefficients coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        SstCoefficientLoaderTest.assertEquals((int)0, (int)coeffs.getStart());
        SstCoefficientLoaderTest.assertEquals((int)124, (int)coeffs.getEnd());
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        SstCoefficientLoaderTest.assertEquals((int)125, (int)coeffs.getStart());
        SstCoefficientLoaderTest.assertEquals((int)511, (int)coeffs.getEnd());
        float[] exp_a_one = new float[]{1.23f, 2.34f, 3.45f};
        float[] exp_a_two = new float[]{0.12f, 1.23f, 2.34f};
        coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        float[] a_coeffs = coeffs.get_A_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)a_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)3, (int)a_coeffs.length);
        for (n2 = 0; n2 < a_coeffs.length; ++n2) {
            SstCoefficientLoaderTest.assertEquals((double)exp_a_one[n2], (double)a_coeffs[n2], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        a_coeffs = coeffs.get_A_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)a_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)3, (int)a_coeffs.length);
        for (n2 = 0; n2 < a_coeffs.length; ++n2) {
            SstCoefficientLoaderTest.assertEquals((double)exp_a_two[n2], (double)a_coeffs[n2], (double)1.0E-6);
        }
        float[] exp_b_one = new float[]{5.67f, 6.78f, 8.89f, 8.9f};
        float[] exp_b_two = new float[]{3.45f, 4.56f, 5.67f, 6.78f};
        coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        float[] b_coeffs = coeffs.get_B_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)b_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)4, (int)b_coeffs.length);
        for (n = 0; n < b_coeffs.length; ++n) {
            SstCoefficientLoaderTest.assertEquals((double)exp_b_one[n], (double)b_coeffs[n], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        b_coeffs = coeffs.get_B_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)b_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)4, (int)b_coeffs.length);
        for (n = 0; n < b_coeffs.length; ++n) {
            SstCoefficientLoaderTest.assertEquals((double)exp_b_two[n], (double)b_coeffs[n], (double)1.0E-6);
        }
        SstCoefficientLoaderTest.assertNull((Object)coeffs.get_C_Coeffs());
        SstCoefficientLoaderTest.assertNull((Object)coeffs.get_D_Coeffs());
    }

    public void testDualStuffCorrectRead() throws IOException, URISyntaxException {
        int n;
        int n2;
        URL dualCoeff = this.createDualCoeffUrl();
        SstCoefficientSet coeffSet = this.loader.load(dualCoeff);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffSet);
        SstCoefficientLoaderTest.assertEquals((String)expDualDesc, (String)coeffSet.getDescription());
        SstCoefficientLoaderTest.assertEquals((int)2, (int)coeffSet.getNumCoefficients());
        SstCoefficients coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        SstCoefficientLoaderTest.assertEquals((int)0, (int)coeffs.getStart());
        SstCoefficientLoaderTest.assertEquals((int)255, (int)coeffs.getEnd());
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        SstCoefficientLoaderTest.assertEquals((int)256, (int)coeffs.getStart());
        SstCoefficientLoaderTest.assertEquals((int)511, (int)coeffs.getEnd());
        float[] exp_c_one = new float[]{1.23f, 2.34f, 3.45f, 4.56f, 5.67f};
        float[] exp_c_two = new float[]{3.45f, 4.56f, 5.67f, 6.78f, 7.89f};
        coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        float[] c_coeffs = coeffs.get_C_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)c_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)5, (int)c_coeffs.length);
        for (n2 = 0; n2 < c_coeffs.length; ++n2) {
            SstCoefficientLoaderTest.assertEquals((double)exp_c_one[n2], (double)c_coeffs[n2], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        c_coeffs = coeffs.get_C_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)c_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)5, (int)c_coeffs.length);
        for (n2 = 0; n2 < c_coeffs.length; ++n2) {
            SstCoefficientLoaderTest.assertEquals((double)exp_c_two[n2], (double)c_coeffs[n2], (double)1.0E-6);
        }
        float[] exp_d_one = new float[]{6.78f, 7.89f, 8.9f, 9.01f, 0.12f, 1.23f, 2.34f};
        float[] exp_d_two = new float[]{8.9f, 9.01f, 0.12f, 1.23f, 2.34f, 3.45f, 4.56f};
        coeffs = coeffSet.getCoefficientsAt(0);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        float[] d_coeffs = coeffs.get_D_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)d_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)7, (int)d_coeffs.length);
        for (n = 0; n < d_coeffs.length; ++n) {
            SstCoefficientLoaderTest.assertEquals((double)exp_d_one[n], (double)d_coeffs[n], (double)1.0E-6);
        }
        coeffs = coeffSet.getCoefficientsAt(1);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        d_coeffs = coeffs.get_D_Coeffs();
        SstCoefficientLoaderTest.assertNotNull((Object)d_coeffs);
        SstCoefficientLoaderTest.assertEquals((int)7, (int)d_coeffs.length);
        for (n = 0; n < d_coeffs.length; ++n) {
            SstCoefficientLoaderTest.assertEquals((double)exp_d_two[n], (double)d_coeffs[n], (double)1.0E-6);
        }
    }

    public void testNoDescriptionCorrectRead() throws IOException, URISyntaxException {
        URL noDescFile = this.createNoDescriptionCoeffUrl();
        SstCoefficientSet coeffs = this.loader.load(noDescFile);
        SstCoefficientLoaderTest.assertNotNull((Object)coeffs);
        SstCoefficientLoaderTest.assertEquals((String)"", (String)coeffs.getDescription());
    }

    public void testIncorrectNumberOfMaps() throws IOException, URISyntaxException {
        URL illegalFile = this.createOneMapTooMuchUrl();
        try {
            this.loader.load(illegalFile);
            SstCoefficientLoaderTest.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        illegalFile = this.createMapOverlapUrl();
        try {
            this.loader.load(illegalFile);
            SstCoefficientLoaderTest.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        illegalFile = this.create_A_and_D_Url();
        try {
            this.loader.load(illegalFile);
            SstCoefficientLoaderTest.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    public void testLoadDescriptionInterface() throws IOException {
        try {
            this.loader.getDescription(null);
            SstCoefficientLoaderTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL nonExistent = this.createNonExistentUrl();
        String description = this.loader.getDescription(nonExistent);
        SstCoefficientLoaderTest.assertEquals((String)"", (String)description);
    }

    public void testLoadDescription() throws IOException, URISyntaxException {
        URL url = this.createDualCoeffUrl();
        String description = this.loader.getDescription(url);
        SstCoefficientLoaderTest.assertEquals((String)expDualDesc, (String)description);
        url = this.createNadirCoeffUrl();
        description = this.loader.getDescription(url);
        SstCoefficientLoaderTest.assertEquals((String)expNadirDesc, (String)description);
    }

    private URL createNonExistentUrl() throws MalformedURLException {
        return new URL("file", "", "n:\nonexistentTestFile");
    }

    private URL createNadirCoeffUrl() throws MalformedURLException, URISyntaxException {
        File nadirCoeff = this.getTestFile("sstTestCoefficientsNadir.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)nadirCoeff.exists());
        return nadirCoeff.toURI().toURL();
    }

    private URL createDualCoeffUrl() throws MalformedURLException, URISyntaxException {
        File dualCoeff = this.getTestFile("sstTestCoefficientsDual.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)dualCoeff.exists());
        return dualCoeff.toURI().toURL();
    }

    private URL createNoDescriptionCoeffUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestCoefficientsNoDescription.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL createOneMapTooMuchUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestOneMapTooMuch.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL createMapOverlapUrl() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTestMapRangeOverlap.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private URL create_A_and_D_Url() throws MalformedURLException, URISyntaxException {
        File noDescCoeff = this.getTestFile("sstTest_a_and_d.coef");
        SstCoefficientLoaderTest.assertEquals((boolean)true, (boolean)noDescCoeff.exists());
        return noDescCoeff.toURI().toURL();
    }

    private File getTestFile(String s) throws URISyntaxException, MalformedURLException {
        URL resource = ((Object)((Object)this)).getClass().getResource(s);
        String encodedUrl = resource.toString().replace(" ", "%20");
        resource = new URL(encodedUrl);
        return new File(resource.toURI());
    }
}

