/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjpeg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.SystemUtils;
import org.esa.s2tbx.dataio.BucketMap;
import org.esa.s2tbx.dataio.Utils;
import org.esa.s2tbx.dataio.jp2.TileLayout;
import org.esa.s2tbx.dataio.openjpeg.CommandOutput;

public class OpenJpegUtils {
    private static final BucketMap<Integer, Integer> dataTypeMap = new BucketMap<Integer, Integer>(){
        {
            this.put(1, 8, 0);
            this.put(9, 15, 1);
            this.put(16, 2);
            this.put(17, 32, 4);
        }
    };

    public static TileLayout getTileLayoutWithOpenJPEG(String opjdumpPath, Path jp2FilePath) throws IOException, InterruptedException {
        if (opjdumpPath == null) {
            throw new IllegalStateException("Cannot retrieve tile layout, opj_dump cannot be found");
        }
        String pathToImageFile = jp2FilePath.toAbsolutePath().toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            pathToImageFile = Utils.GetIterativeShortPathNameW(pathToImageFile);
        }
        ProcessBuilder builder = new ProcessBuilder(opjdumpPath, "-i", pathToImageFile);
        builder.redirectErrorStream(true);
        CommandOutput exit = OpenJpegUtils.runProcess(builder);
        if (exit.getErrorCode() != 0) {
            StringBuilder sbu = new StringBuilder();
            for (String fragment : builder.command()) {
                sbu.append(fragment);
                sbu.append(' ');
            }
            throw new IOException(String.format("Command [%s] failed with error code [%d], stdoutput [%s] and stderror [%s]", sbu.toString(), exit.getErrorCode(), exit.getTextOutput(), exit.getErrorOutput()));
        }
        TileLayout tileLayout = OpenJpegUtils.parseOpjDump(exit.getTextOutput());
        if (tileLayout.numResolutions == 0) {
            return null;
        }
        return tileLayout;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static CommandOutput runProcess(ProcessBuilder builder) throws InterruptedException, IOException {
        builder.environment().putAll(System.getenv());
        StringBuilder output = new StringBuilder();
        boolean isStopped = false;
        Process process = builder.start();
        try (BufferedReader outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            while (!isStopped) {
                if (!process.isAlive()) {
                    isStopped = true;
                } else {
                    Thread.yield();
                }
                while (outReader.ready()) {
                    String line = outReader.readLine();
                    if (line == null || line.isEmpty()) continue;
                    output.append(line);
                }
            }
            outReader.close();
        }
        int exitCode = process.exitValue();
        String errorOutput = OpenJpegUtils.convertStreamToString(process.getErrorStream());
        return new CommandOutput(exitCode, output.toString(), errorOutput);
    }

    public static TileLayout parseOpjDump(String content) {
        ArrayList<String> splittedContent = new ArrayList<String>();
        Collections.addAll(splittedContent, content.split(content.contains("\n") ? "\n" : "\t"));
        return OpenJpegUtils.parseOpjDump(splittedContent);
    }

    public static TileLayout parseOpjDump(List<String> content) {
        int Width = 0;
        int Height = 0;
        int tileWidth = 0;
        int tileHeight = 0;
        int xTiles = 0;
        int yTiles = 0;
        int resolutions = 0;
        int precision = 0;
        for (String line : content) {
            String[] segments;
            if (line.contains("x1") && line.contains("y1")) {
                segments = line.trim().split(",");
                Width = Integer.parseInt(segments[0].split("\\=")[1]);
                Height = Integer.parseInt(segments[1].split("\\=")[1]);
            }
            if (line.contains("tdx") && line.contains("tdy")) {
                segments = line.trim().split(",");
                tileWidth = Integer.parseInt(segments[0].split("\\=")[1]);
                tileHeight = Integer.parseInt(segments[1].split("\\=")[1]);
            }
            if (line.contains("tw") && line.contains("th")) {
                segments = line.trim().split(",");
                xTiles = Integer.parseInt(segments[0].split("\\=")[1]);
                yTiles = Integer.parseInt(segments[1].split("\\=")[1]);
            }
            if (line.contains("numresolutions")) {
                resolutions = Integer.parseInt(line.trim().split("\\=")[1]);
            }
            if (!line.contains("prec=")) continue;
            precision = Integer.parseInt(line.trim().split("\\=")[1]);
        }
        return new TileLayout(Width, Height, tileWidth, tileHeight, xTiles, yTiles, resolutions, (Integer)dataTypeMap.get((Object)precision));
    }

    public static boolean validateOpenJpegExecutables(String opjdumpPath, String opjdecompPath) {
        CommandOutput exit;
        ProcessBuilder builder = new ProcessBuilder(opjdumpPath, "-h");
        builder.redirectErrorStream(true);
        try {
            exit = OpenJpegUtils.runProcess(builder);
        }
        catch (Exception e) {
            return false;
        }
        if (exit.getErrorCode() != 1) {
            return false;
        }
        builder = new ProcessBuilder(opjdecompPath, "-h");
        builder.redirectErrorStream(true);
        try {
            exit = OpenJpegUtils.runProcess(builder);
        }
        catch (Exception e) {
            return false;
        }
        return exit.getErrorCode() == 1;
    }
}

