/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjpeg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;

public class OpenJpegExecRetriever {
    public static String getOpjCompress() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getCompressor());
    }

    public static String getOpjDecompress() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getDecompressor());
    }

    public static String getOpjDump() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getDump());
    }

    public static String getOpenJp2() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getCodec());
    }

    public static Path getOpenJPEGAuxDataPath() {
        Path versionFile = ResourceInstaller.findModuleCodeBasePath(OpenJpegExecRetriever.class).resolve("version").resolve("version.properties");
        Properties versionProp = new Properties();
        try (InputStream inputStream = Files.newInputStream(versionFile, new OpenOption[0]);){
            versionProp.load(inputStream);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("OpenJPEG configuration error: failed to read " + versionFile.toString());
            return null;
        }
        String version = versionProp.getProperty("project.version");
        if (version == null) {
            SystemUtils.LOG.severe("OpenJPEG configuration error: unable to get property project.version from " + versionFile.toString());
            return null;
        }
        return SystemUtils.getAuxDataPath().resolve("openjpeg").resolve(version);
    }

    private static String findOpenJpegExecPath(String endPath) {
        if (endPath == null) {
            return null;
        }
        Path path = OpenJpegExecRetriever.getOpenJPEGAuxDataPath().resolve(endPath);
        String pathString = null;
        if (path != null) {
            pathString = path.toString();
        }
        return pathString;
    }

    private static enum OSCategory {
        WIN_32("openjpeg-2.1.0-win32", Paths.get("bin", "opj_compress.exe").toString(), Paths.get("bin", "opj_decompress.exe").toString(), Paths.get("bin", "opj_dump.exe").toString(), Paths.get("bin", "libopenjp2.dll").toString()),
        WIN_64("openjpeg-2.1.0-win64", Paths.get("bin", "opj_compress.exe").toString(), Paths.get("bin", "opj_decompress.exe").toString(), Paths.get("bin", "opj_dump.exe").toString(), Paths.get("bin", "libopenjp2.dll").toString()),
        LINUX_64("openjpeg-2.1.0-linux64", Paths.get("bin", "opj_compress").toString(), Paths.get("bin", "opj_decompress").toString(), Paths.get("bin", "opj_dump").toString(), Paths.get("bin", "libopenjp2.so").toString()),
        MAC_OS_X("openjpeg-2.1.0-macosx", Paths.get("bin", "opj_compress").toString(), Paths.get("bin", "opj_decompress").toString(), Paths.get("bin", "opj_dump").toString(), Paths.get("bin", "libopenjp2.dylib").toString()),
        UNSUPPORTED(null, null, null, null, null);

        String directory;
        String compressor;
        String decompressor;
        String dump;
        String codec;

        private OSCategory(String directory, String compressor, String decompressor, String dump, String codec) {
            this.directory = directory;
            this.compressor = compressor;
            this.decompressor = decompressor;
            this.dump = dump;
            this.codec = codec;
        }

        String getCompressor() {
            return Paths.get(this.directory, this.compressor).toString();
        }

        String getDecompressor() {
            return Paths.get(this.directory, this.decompressor).toString();
        }

        String getDump() {
            return Paths.get(this.directory, this.dump).toString();
        }

        String getCodec() {
            return Paths.get(this.directory, this.codec).toString();
        }

        static OSCategory getOSCategory() {
            String sysArch;
            OSCategory category = org.apache.commons.lang.SystemUtils.IS_OS_LINUX ? LINUX_64 : (org.apache.commons.lang.SystemUtils.IS_OS_MAC_OSX ? MAC_OS_X : (org.apache.commons.lang.SystemUtils.IS_OS_WINDOWS ? ((sysArch = System.getProperty("os.arch").toLowerCase()).contains("amd64") || sysArch.contains("x86_x64") ? WIN_64 : WIN_32) : UNSUPPORTED));
            return category;
        }
    }
}

