/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjpeg;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import org.esa.s2tbx.dataio.openjpeg.OpenJpegExecRetriever;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Activator;

public class OpenJPEGActivator
implements Activator {
    public void start() {
        Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(this.getClass()).resolve("auxdata/openjpeg");
        Path auxdataDirectory = OpenJpegExecRetriever.getOpenJPEGAuxDataPath();
        if (auxdataDirectory == null) {
            SystemUtils.LOG.severe("OpenJPEG configuration error: failed to retrieve auxdata path");
            return;
        }
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDirectory);
        try {
            resourceInstaller.install(".*", ProgressMonitor.NULL);
            OpenJPEGActivator.fixUpPermissions(auxdataDirectory);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("OpenJPEG configuration error: failed to create " + auxdataDirectory);
            return;
        }
    }

    public void stop() {
    }

    private static void fixUpPermissions(Path destPath) throws IOException {
        Stream<Path> files = Files.list(destPath);
        files.forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    OpenJPEGActivator.fixUpPermissions(path);
                }
                catch (IOException e) {
                    SystemUtils.LOG.severe("OpenJPEG configuration error: failed to fix permissions on " + path);
                }
            } else {
                OpenJPEGActivator.setExecutablePermissions(path);
            }
        });
    }

    private static void setExecutablePermissions(Path executablePathName) {
        if (org.apache.commons.lang.SystemUtils.IS_OS_UNIX) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE));
            try {
                Files.setPosixFilePermissions(executablePathName, permissions);
            }
            catch (IOException e) {
                SystemUtils.LOG.severe("Can't set execution permissions for executable " + executablePathName.toString() + ". If required, please ask an authorised user to make the file executable.");
            }
        }
    }
}

