/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjp2;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.esa.s2tbx.dataio.openjp2.TileImageDescriptor;
import org.esa.snap.core.util.SystemUtils;

public class RasterUtils {
    private static final Map<String, Integer> extensions = new HashMap<String, Integer>(){
        {
            this.put("pgx", 11);
            this.put("pnm", 10);
            this.put("pgm", 10);
            this.put("ppm", 10);
            this.put("bmp", 12);
            this.put("tif", 14);
            this.put("raw", 15);
            this.put("rawl", 18);
            this.put("tga", 16);
            this.put("png", 17);
            this.put("j2k", 0);
            this.put("jp2", 1);
            this.put("jpt", 2);
            this.put("j2c", 0);
            this.put("jpc", 0);
        }
    };
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;

    static TileImageDescriptor<byte[]> readAsByteArray(Path path, Rectangle roi) throws IOException {
        TileImageDescriptor<byte[]> descriptor;
        int size = (int)Files.size(path);
        try (RandomAccessFile in = new RandomAccessFile(path.toFile(), "r");){
            try (FileChannel file = in.getChannel();){
                byte[] values;
                MappedByteBuffer buf = file.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                int width = buf.getInt();
                int height = buf.getInt();
                int offset = 8;
                int byteLen = size - offset;
                if (roi == null) {
                    values = new byte[byteLen];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = buf.get();
                    }
                } else {
                    values = new byte[roi.width * roi.height];
                    int maxVal = Math.min(roi.y + roi.height, height);
                    for (int col = roi.y; col < maxVal; ++col) {
                        try {
                            int srcPos = roi.x + col * width;
                            int dstPos = (col - roi.y) * roi.width;
                            if (srcPos >= byteLen || dstPos >= values.length) continue;
                            int fileOffset = offset + srcPos;
                            for (int i = 0; i < Math.min(roi.width, byteLen - srcPos); ++i) {
                                values[dstPos + i] = buf.get(fileOffset + i);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    width = roi.width;
                    height = roi.height;
                }
                descriptor = new TileImageDescriptor<byte[]>(width, height, values);
            }
            in.close();
        }
        return descriptor;
    }

    static TileImageDescriptor<short[]> readAsShortArray(Path path, Rectangle roi) throws IOException {
        TileImageDescriptor<short[]> descriptor;
        int size = (int)Files.size(path);
        try (RandomAccessFile in = new RandomAccessFile(path.toFile(), "r");){
            try (FileChannel file = in.getChannel();){
                short[] values;
                MappedByteBuffer buf = file.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                int width = buf.getInt();
                int height = buf.getInt();
                int offset = 8;
                int shortLen = (size - offset) / 2;
                if (roi == null) {
                    values = new short[shortLen];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = buf.getShort();
                    }
                } else {
                    values = new short[roi.width * roi.height];
                    int maxVal = Math.min(roi.y + roi.height, height);
                    for (int col = roi.y; col < maxVal; ++col) {
                        try {
                            int srcPos = roi.x + col * width;
                            int dstPos = (col - roi.y) * roi.width;
                            if (srcPos >= shortLen || dstPos >= values.length) continue;
                            int fileOffset = offset + srcPos * 2;
                            for (int i = 0; i < Math.min(roi.width, shortLen - srcPos); ++i) {
                                values[dstPos + i] = buf.getShort(fileOffset + i * 2);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    width = roi.width;
                    height = roi.height;
                }
                descriptor = new TileImageDescriptor<short[]>(width, height, values);
            }
            in.close();
        }
        return descriptor;
    }

    static TileImageDescriptor<int[]> readAsIntArray(Path path, Rectangle roi) throws IOException {
        TileImageDescriptor<int[]> descriptor;
        int size = (int)Files.size(path);
        try (RandomAccessFile in = new RandomAccessFile(path.toFile(), "r");){
            try (FileChannel file = in.getChannel();){
                int[] values;
                MappedByteBuffer buf = file.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                int width = buf.getInt();
                int height = buf.getInt();
                int offset = 8;
                int intLen = (size - offset) / 4;
                if (roi == null) {
                    values = new int[intLen];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = buf.getInt();
                    }
                } else {
                    values = new int[roi.width * roi.height];
                    int maxVal = Math.min(roi.y + roi.height, height);
                    for (int col = roi.y; col < maxVal; ++col) {
                        try {
                            int srcPos = roi.x + col * width;
                            int dstPos = (col - roi.y) * roi.width;
                            if (srcPos >= intLen || dstPos >= values.length) continue;
                            int fileOffset = offset + srcPos * 4;
                            for (int i = 0; i < Math.min(roi.width, intLen - srcPos); ++i) {
                                values[dstPos + i] = buf.getShort(fileOffset + i * 4);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    width = roi.width;
                    height = roi.height;
                }
                descriptor = new TileImageDescriptor<int[]>(width, height, values);
            }
            in.close();
        }
        return descriptor;
    }

    private static byte[] extractRangeAsByteArray(int[] values, int offset, int length) {
        if (values == null || values.length < offset + length || offset < 0 || length <= 0) {
            throw new RuntimeException("Invalid arguments");
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)values[offset + i];
        }
        return result;
    }

    private static short[] extractRangeAsShortArray(int[] values, int offset, int length) {
        if (values == null || values.length < offset + length || offset < 0 || length <= 0) {
            throw new RuntimeException("Invalid arguments");
        }
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (short)values[offset + i];
        }
        return result;
    }

    static DataBufferByte extractROIAsByteBuffer(int[] pixels, int imageWidth, int imageHeight, Rectangle roi) {
        byte[] values;
        if (roi != null) {
            values = new byte[roi.width * roi.height];
            int maxVal = Math.min(roi.y + roi.height, imageHeight);
            for (int col = roi.y; col < maxVal; ++col) {
                try {
                    int srcPos = roi.x + col * imageWidth;
                    int dstPos = (col - roi.y) * roi.width;
                    if (srcPos >= pixels.length || dstPos >= values.length) continue;
                    for (int i = 0; i < Math.min(roi.width, pixels.length - srcPos) - dstPos; ++i) {
                        values[dstPos + i] = (byte)pixels[srcPos + i];
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SystemUtils.LOG.warning("ROI fell outside the extracted range [" + e.getMessage() + "]");
                }
            }
        } else {
            values = RasterUtils.extractRangeAsByteArray(pixels, 0, pixels.length);
        }
        return new DataBufferByte(values, values.length);
    }

    static DataBufferUShort extractROIAsUShortBuffer(int[] pixels, int imageWidth, int imageHeight, Rectangle roi) {
        short[] values;
        if (roi != null) {
            values = new short[roi.width * roi.height];
            int maxVal = Math.min(roi.y + roi.height, imageHeight);
            for (int col = roi.y; col < maxVal; ++col) {
                try {
                    int srcPos = roi.x + col * imageWidth;
                    int dstPos = (col - roi.y) * roi.width;
                    if (srcPos >= pixels.length || dstPos >= values.length) continue;
                    for (int i = 0; i < Math.min(roi.width, pixels.length - srcPos); ++i) {
                        values[dstPos + i] = (short)pixels[srcPos + i];
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SystemUtils.LOG.warning("ROI fell outside the extracted range [" + e.getMessage() + "]");
                }
            }
        } else {
            values = RasterUtils.extractRangeAsShortArray(pixels, 0, pixels.length);
        }
        return new DataBufferUShort(values, values.length);
    }

    static DataBufferShort extractROIAsShortBuffer(int[] pixels, int imageWidth, int imageHeight, Rectangle roi) {
        short[] values;
        if (roi != null) {
            values = new short[roi.width * roi.height];
            int maxVal = Math.min(roi.y + roi.height, imageHeight);
            for (int col = roi.y; col < maxVal; ++col) {
                try {
                    int srcPos = roi.x + col * imageWidth;
                    int dstPos = (col - roi.y) * roi.width;
                    if (srcPos >= pixels.length || dstPos >= values.length) continue;
                    for (int i = 0; i < Math.min(roi.width, pixels.length - srcPos); ++i) {
                        values[dstPos + i] = (short)pixels[srcPos + i];
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SystemUtils.LOG.warning("ROI fell outside the extracted range [" + e.getMessage() + "]");
                }
            }
        } else {
            values = RasterUtils.extractRangeAsShortArray(pixels, 0, pixels.length);
        }
        return new DataBufferShort(values, values.length);
    }

    static DataBufferInt extractROI(int[] pixels, int imageWidth, int imageHeight, Rectangle roi) {
        int[] values = new int[roi.width * roi.height];
        int maxVal = Math.min(roi.y + roi.height, imageHeight);
        for (int col = roi.y; col < maxVal; ++col) {
            try {
                int srcPos = roi.x + col * imageWidth;
                int dstPos = (col - roi.y) * roi.width;
                if (srcPos >= pixels.length || dstPos >= values.length) continue;
                System.arraycopy(pixels, srcPos, values, dstPos, Math.min(roi.width, pixels.length - srcPos));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                SystemUtils.LOG.warning("ROI fell outside the extracted range [" + e.getMessage() + "]");
            }
        }
        return new DataBufferInt(values, values.length);
    }

    static Path write(int width, int height, int[] values, int dataType, Path toFile, Function<Path, Void> completionCallBack) {
        int pixSize;
        switch (dataType) {
            case 0: {
                pixSize = 1;
                break;
            }
            case 1: 
            case 2: {
                pixSize = 2;
                break;
            }
            default: {
                pixSize = 4;
            }
        }
        try (RandomAccessFile raf = new RandomAccessFile(toFile.toFile(), "rw");
             FileChannel file = raf.getChannel();){
            MappedByteBuffer buffer = file.map(FileChannel.MapMode.READ_WRITE, 0L, pixSize * values.length + 8);
            buffer.putInt(width);
            buffer.putInt(height);
            if (pixSize == 4) {
                for (int v : values) {
                    buffer.putInt(v);
                }
            } else if (pixSize == 2) {
                for (int v : values) {
                    buffer.putShort((short)v);
                }
            } else {
                for (int v : values) {
                    buffer.put((byte)v);
                }
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (completionCallBack != null) {
                completionCallBack.apply(toFile);
            }
        }
        return toFile;
    }

    static <T extends Structure> T dereference(Class<T> tClass, Pointer pointer) {
        Structure ref = null;
        if (tClass != null && pointer != null) {
            try {
                Constructor<T> ctor = tClass.getDeclaredConstructor(Pointer.class);
                ref = (Structure)ctor.newInstance(pointer);
                ref.read();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                SystemUtils.LOG.severe(e.getMessage());
            }
        }
        return (T)ref;
    }

    static int[] readRasterBandasIntArray(Raster raster, int bandIndex) {
        if (raster == null || bandIndex < 0 || bandIndex >= raster.getNumBands()) {
            throw new IllegalArgumentException("Raster not of int type or invalid band index");
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        return sampleModel.getSamples(0, 0, width, height, bandIndex, (int[])null, dataBuffer);
    }

    static int getFileFormat(Path file) {
        if (file == null) {
            return -1;
        }
        String fileName = file.getFileName().toString();
        String ext = fileName.substring(fileName.lastIndexOf("."));
        if (ext.isEmpty()) {
            return -1;
        }
        Integer code = extensions.get(ext = ext.toLowerCase().replace(".", ""));
        return code != null ? code : -1;
    }

    static int getFormat(String extension) {
        Integer code = extensions.get(extension = extension.toLowerCase().replace(".", ""));
        return code != null ? code : -1;
    }
}

