/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjp2;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.s2tbx.dataio.openjp2.RasterUtils;
import org.esa.s2tbx.dataio.openjp2.library.Callbacks;
import org.esa.s2tbx.dataio.openjp2.library.OpenJp2;
import org.esa.s2tbx.dataio.openjp2.struct.CompressionCodec;
import org.esa.s2tbx.dataio.openjp2.struct.CompressionParams;
import org.esa.s2tbx.dataio.openjp2.struct.Image;
import org.esa.s2tbx.dataio.openjp2.struct.ImageComponent;
import org.esa.s2tbx.dataio.openjp2.struct.ImageComponentParams;
import org.esa.snap.core.util.SystemUtils;

public class OpenJP2Encoder
implements AutoCloseable {
    private PointerByReference pStream;
    private CompressionCodec pCodec;
    private PointerByReference pImage;
    private RenderedImage theImage;
    private Logger logger = SystemUtils.LOG;

    public OpenJP2Encoder(RenderedImage image) {
        this.theImage = image;
    }

    public void write(Path outFile, int resolutions) throws IOException {
        int bitDepth;
        CompressionParams parameters = this.initEncodeParams(outFile, resolutions);
        Raster rasterData = this.theImage.getData();
        int numBands = rasterData.getNumBands();
        int signed = 0;
        ImageComponentParams.ByReference refParams = new ImageComponentParams.ByReference();
        ImageComponentParams[] imageCompParams = (ImageComponentParams[])refParams.toArray(numBands);
        int colorSpace = numBands == 1 ? 2 : (numBands >= 3 ? 1 : -1);
        switch (rasterData.getTransferType()) {
            case 0: {
                bitDepth = 8;
                break;
            }
            case 1: {
                signed = 0;
                bitDepth = 16;
                break;
            }
            case 2: {
                signed = 1;
                bitDepth = 16;
                break;
            }
            case 3: 
            case 4: {
                bitDepth = 32;
                break;
            }
            case 5: {
                bitDepth = 64;
                break;
            }
            default: {
                bitDepth = 16;
            }
        }
        for (int i = 0; i < numBands; ++i) {
            imageCompParams[i].prec = bitDepth;
            imageCompParams[i].bpp = bitDepth;
            imageCompParams[i].sgnd = signed;
            imageCompParams[i].dx = 1;
            imageCompParams[i].dy = 1;
            imageCompParams[i].w = rasterData.getWidth();
            imageCompParams[i].h = rasterData.getHeight();
        }
        this.pImage = OpenJp2.opj_image_create(numBands, imageCompParams[0], colorSpace);
        Image opjImage = RasterUtils.dereference(Image.class, this.pImage.getPointer());
        opjImage.x0 = 0;
        opjImage.y0 = 0;
        opjImage.x1 = rasterData.getWidth();
        opjImage.y1 = rasterData.getHeight();
        ImageComponent[] components = (ImageComponent[])opjImage.comps.toArray(numBands);
        if (bitDepth > 16) {
            OpenJp2.opj_image_destroy(this.pImage.getPointer());
            this.pImage = null;
            throw new RuntimeException("OpenJPEG cannot encode raw components with bit depth > 16 bits");
        }
        for (int i = 0; i < numBands; ++i) {
            int[] data = RasterUtils.readRasterBandasIntArray(rasterData, i);
            components[i].data.getPointer().write(0L, data, 0, data.length);
        }
        parameters.tcp_mct = numBands >= 3 ? (char)'\u0001' : '\u0000';
        switch (parameters.cod_format) {
            case 0: {
                this.pCodec = OpenJp2.opj_create_compress(0);
                break;
            }
            case 1: {
                this.pCodec = OpenJp2.opj_create_compress(2);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported codec");
            }
        }
        if (SystemUtils.LOG.getLevel().intValue() <= Level.FINE.intValue()) {
            OpenJp2.opj_set_info_handler(this.pCodec, new Callbacks.MessageFunction(){

                @Override
                public void invoke(Pointer msg, Pointer client_data) {
                    OpenJP2Encoder.this.logger.info(msg.getString(0L));
                }

                @Override
                public Pointer invoke(Pointer p_codec) {
                    return p_codec;
                }
            }, null);
            OpenJp2.opj_set_warning_handler(this.pCodec, new Callbacks.MessageFunction(){

                @Override
                public void invoke(Pointer msg, Pointer client_data) {
                    OpenJP2Encoder.this.logger.warning(msg.getString(0L));
                }

                @Override
                public Pointer invoke(Pointer p_codec) {
                    return p_codec;
                }
            }, null);
        }
        OpenJp2.opj_set_error_handler(this.pCodec, new Callbacks.MessageFunction(){

            @Override
            public void invoke(Pointer msg, Pointer client_data) {
                OpenJP2Encoder.this.logger.severe(msg.getString(0L));
            }

            @Override
            public Pointer invoke(Pointer p_codec) {
                return p_codec;
            }
        }, null);
        opjImage.write();
        if (OpenJp2.opj_setup_encoder(this.pCodec, parameters, this.pImage) == 0) {
            throw new RuntimeException("Failed to setup encoder");
        }
        opjImage = RasterUtils.dereference(Image.class, this.pImage.getPointer());
        this.pStream = OpenJp2.opj_stream_create_default_file_stream(outFile.toString(), 0);
        if (this.pStream == null || this.pStream.getValue() == null) {
            throw new RuntimeException("Failed to create the stream to the file");
        }
        if (OpenJp2.opj_start_compress(this.pCodec, opjImage, this.pStream) == 0) {
            throw new RuntimeException("Failed to encode image: opj_start_compress");
        }
        if (OpenJp2.opj_encode(this.pCodec, this.pStream) == 0) {
            throw new RuntimeException("Failed to encode image: opj_encode");
        }
        if (OpenJp2.opj_end_compress(this.pCodec, this.pStream) == 0) {
            throw new RuntimeException("Failed to encode image: opj_end_compress");
        }
    }

    private CompressionParams initEncodeParams(Path file, int numResolutions) {
        CompressionParams params = new CompressionParams();
        OpenJp2.opj_set_default_encoder_parameters(params);
        params.tcp_mct = '\u0001';
        params.decod_format = RasterUtils.getFormat("raw");
        params.cod_format = RasterUtils.getFileFormat(file);
        params.cp_tx0 = 0;
        params.cp_ty0 = 0;
        params.cp_tdx = 1024;
        params.cp_tdy = 1024;
        params.tile_size_on = 1;
        params.numresolution = numResolutions;
        params.outfile = file.toAbsolutePath().toString().getBytes();
        params.cp_disto_alloc = 0;
        params.cp_fixed_quality = 1;
        params.tcp_numlayers = 1;
        params.tcp_distoratio[0] = 100.0f;
        params.roi_compno = -1;
        params.subsampling_dx = 1;
        params.subsampling_dy = 1;
        return params;
    }

    @Override
    public void close() throws Exception {
        if (this.pCodec != null) {
            OpenJp2.opj_destroy_codec(this.pCodec.getPointer());
        }
        if (this.pStream != null && this.pStream.getValue() != null) {
            OpenJp2.opj_stream_destroy(this.pStream);
        }
        if (this.pImage != null && this.pImage.getValue() != null) {
            OpenJp2.opj_image_destroy(this.pImage.getPointer());
        }
    }
}

