/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2.segments;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.MarkerSegment;
import org.esa.s2tbx.dataio.jp2.MarkerType;

public class ImageAndTileSizeSegment
extends MarkerSegment {
    int lsiz;
    int rsiz;
    long xsiz;
    long ysiz;
    long xosiz;
    long yosiz;
    long xtsiz;
    long ytsiz;
    long xtosiz;
    long ytosiz;
    int csiz;
    int[] ssiz;
    int[] xrsiz;
    int[] yrsiz;

    public ImageAndTileSizeSegment(MarkerType markerType) {
        super(markerType);
    }

    public int getLsiz() {
        return this.lsiz;
    }

    public int getRsiz() {
        return this.rsiz;
    }

    public long getXsiz() {
        return this.xsiz;
    }

    public long getYsiz() {
        return this.ysiz;
    }

    public long getXosiz() {
        return this.xosiz;
    }

    public long getYosiz() {
        return this.yosiz;
    }

    public long getXtsiz() {
        return this.xtsiz;
    }

    public long getYtsiz() {
        return this.ytsiz;
    }

    public long getXtosiz() {
        return this.xtosiz;
    }

    public long getYtosiz() {
        return this.ytosiz;
    }

    public int getCsiz() {
        return this.csiz;
    }

    public int[] getSsiz() {
        return this.ssiz;
    }

    public int[] getXRsiz() {
        return this.xrsiz;
    }

    public int[] getYRsiz() {
        return this.yrsiz;
    }

    @Override
    public void readFrom(ImageInputStream stream) throws IOException {
        this.lsiz = stream.readShort() & 0xFFFFF;
        this.rsiz = stream.readShort() & 0xFFFFF;
        this.xsiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.ysiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.xosiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.yosiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.xtsiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.ytsiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.xtosiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.ytosiz = (long)stream.readInt() & 0xFFFFFFFFFFL;
        this.csiz = stream.readShort() & 0xFFFFF;
        if (this.csiz < 1 || this.csiz > 16384) {
            throw new IOException("Invalid SIZ parameter: Csiz = " + this.csiz);
        }
        this.ssiz = new int[this.csiz];
        this.xrsiz = new int[this.csiz];
        this.yrsiz = new int[this.csiz];
        for (int i = 0; i < this.csiz; ++i) {
            this.ssiz[i] = stream.readByte() & 0xFF;
            this.xrsiz[i] = stream.readByte() & 0xFF;
            this.yrsiz[i] = stream.readByte() & 0xFF;
        }
    }
}

