/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TileLayout {
    public final int width;
    public final int height;
    public final int tileWidth;
    public final int tileHeight;
    public final int numXTiles;
    public final int numYTiles;
    public final int numResolutions;
    public int numBands;
    public int dataType = 0;

    public TileLayout(int width, int height, int tileWidth, int tileHeight, int numXTiles, int numYTiles, int numResolutions) {
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.numXTiles = numXTiles;
        this.numYTiles = numYTiles;
        this.numResolutions = numResolutions;
        this.numBands = 1;
    }

    public TileLayout(int width, int height, int tileWidth, int tileHeight, int numXTiles, int numYTiles, int numResolutions, int dataType) {
        this(width, height, tileWidth, tileHeight, numXTiles, numYTiles, numResolutions);
        this.dataType = dataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TileLayout)) {
            return false;
        }
        TileLayout that = (TileLayout)o;
        if (this.height != that.height) {
            return false;
        }
        if (this.numResolutions != that.numResolutions) {
            return false;
        }
        if (this.numXTiles != that.numXTiles) {
            return false;
        }
        if (this.numYTiles != that.numYTiles) {
            return false;
        }
        if (this.tileHeight != that.tileHeight) {
            return false;
        }
        if (this.tileWidth != that.tileWidth) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        return this.dataType == that.dataType;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.tileWidth;
        result = 31 * result + this.tileHeight;
        result = 31 * result + this.numXTiles;
        result = 31 * result + this.numYTiles;
        result = 31 * result + this.numResolutions;
        result = 31 * result + this.dataType;
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

