/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.esa.s2tbx.dataio.jp2.Marker;
import org.esa.s2tbx.dataio.jp2.MarkerSegment;
import org.esa.s2tbx.dataio.jp2.segments.CodingStyleDefaultSegment;
import org.esa.s2tbx.dataio.jp2.segments.IgnoredSegment;
import org.esa.s2tbx.dataio.jp2.segments.ImageAndTileSizeSegment;

public enum MarkerType {
    ___(0, IgnoredSegment.class),
    SOC(65359, Marker.class),
    SOT(65424, Marker.class),
    SOD(65427, Marker.class),
    EOC(65497, Marker.class),
    SIZ(65361, ImageAndTileSizeSegment.class),
    COD(65362, CodingStyleDefaultSegment.class),
    COC(65363, Marker.class),
    RGN(65374, Marker.class),
    QCD(65372, Marker.class),
    QCC(65373, Marker.class),
    POC(65375, Marker.class),
    TLM(65365, Marker.class),
    PLM(65367, Marker.class),
    PLT(65368, Marker.class),
    PPM(65376, Marker.class),
    PPT(65377, Marker.class),
    SOP(65425, Marker.class),
    EPH(65426, Marker.class),
    CRG(65379, Marker.class),
    COM(65380, Marker.class);

    private static final Map<Integer, MarkerType> codeMap;
    private final int code;
    private final Class<? extends MarkerSegment> type;

    private MarkerType(int code, Class<? extends MarkerSegment> type) {
        this.code = code;
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public String toHexString() {
        return "0x" + Integer.toHexString(this.code).toUpperCase();
    }

    public MarkerSegment createSegment() {
        try {
            Constructor<? extends MarkerSegment> boxConstructor = this.type.getConstructor(MarkerType.class);
            return boxConstructor.newInstance(new Object[]{this});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static MarkerType get(Integer code) {
        return codeMap.get(code);
    }

    static {
        MarkerType[] values = MarkerType.values();
        codeMap = new HashMap<Integer, MarkerType>();
        for (MarkerType value : values) {
            codeMap.put(value.getCode(), value);
        }
    }
}

