/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;

public class Utils {
    public static String getStackTrace(Throwable tr) {
        StringWriter sw = new StringWriter();
        tr.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String GetShortPathNameW(String path) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return path;
        }
        if (!new File(path).exists()) {
            return "";
        }
        int sizeBuffer = 2048;
        char[] shortt = new char[sizeBuffer];
        CKernel32.INSTANCE.GetShortPathNameW(path, shortt, sizeBuffer);
        return Native.toString((char[])shortt);
    }

    public static String GetLongPathNameW(String path) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return path;
        }
        if (!new File(path).exists()) {
            return "";
        }
        int sizeBuffer = 2048;
        char[] longg = new char[sizeBuffer];
        CKernel32.INSTANCE.GetLongPathNameW(path, longg, sizeBuffer);
        return Native.toString((char[])longg);
    }

    public static String GetIterativeShortPathNameW(String path) throws IOException {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return path;
        }
        if (!new File(path).exists()) {
            return "";
        }
        String firstTry = Utils.GetShortPathNameW(path);
        if (firstTry.length() != 0) {
            return firstTry;
        }
        int lenght = 0;
        String workingPath = path;
        while (lenght == 0) {
            workingPath = new File(workingPath).getParent();
            lenght = Utils.GetShortPathNameW(workingPath).length();
        }
        String[] shortenedFragments = Utils.GetShortPathNameW(workingPath).split(Pattern.quote(File.separator));
        String[] fragments = path.split(Pattern.quote(File.separator));
        if (fragments.length == 1) {
            fragments = path.split(Pattern.quote("/"));
        }
        System.arraycopy(shortenedFragments, 0, fragments, 0, shortenedFragments.length);
        String complete = String.join((CharSequence)File.separator, fragments);
        String shortComplete = Utils.GetShortPathNameW(complete);
        if (shortComplete.length() != 0) {
            return shortComplete;
        }
        if (complete.equals(path)) {
            if (path.length() <= 260) {
                return path;
            }
            throw new IOException(String.format("The path %s is too long and it is not possible to get the windows short path. Please, try to copy the product to the root folder.", path));
        }
        return Utils.GetIterativeShortPathNameW(complete);
    }

    public static long diffLastModifiedTimes(File file1, File file2) {
        try {
            long time1 = file1.lastModified();
            long time2 = file2.lastModified();
            if (time1 != 0L && time2 != 0L) {
                return time1 - time2;
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String getMD5sum(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(input.getBytes());
            byte[] messageDigestMD5 = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (byte bytes : messageDigestMD5) {
                stringBuffer.append(String.format("%02x", bytes & 0xFF));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException exception) {
            return null;
        }
    }

    private static interface CKernel32
    extends Library {
        public static final CKernel32 INSTANCE = (CKernel32)Native.loadLibrary((String)"kernel32", CKernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);

        public int GetShortPathNameW(String var1, char[] var2, int var3);

        public int GetLongPathNameW(String var1, char[] var2, int var3);
    }
}

