/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.openjpeg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.s2tbx.dataio.openjpeg.OpenJpegUtils;
import org.esa.snap.core.util.SystemUtils;

public class OpenJpegExecRetriever {
    public static String getOpjCompress() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getCompressor());
    }

    public static String getOpjDecompress() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getDecompressor());
    }

    public static String getOpjDump() {
        return OpenJpegExecRetriever.findOpenJpegExecPath(OSCategory.getOSCategory().getDump());
    }

    private static String findOpenJpegExecPath(String endPath) {
        if (endPath == null) {
            return null;
        }
        Path path = SystemUtils.getAuxDataPath().resolve("openjpeg").resolve(endPath);
        String pathString = null;
        if (path != null) {
            pathString = path.toString();
        }
        return pathString;
    }

    private static enum OSCategory {
        WIN_32("openjpeg-2.1.0-win32-x86_dyn", "bin/opj_compress.exe", "bin/opj_decompress.exe", "bin/opj_dump.exe"),
        WIN_64("openjpeg-2.1.0-win32-x64_dyn", "bin/opj_compress.exe", "bin/opj_decompress.exe", "bin/opj_dump.exe"),
        LINUX_32("openjpeg-2.1.0-Linux-i386", "bin/opj_ccompress", "bin/opj_decompress", "bin/opj_dump"),
        LINUX_64("openjpeg-2.1.0-Linux-x64", "bin/opj_compress", "bin/opj_decompress", "bin/opj_dump"),
        MAC_OS_X("openjpeg-2.1.0-Darwin-i386", "bin/opj_compress", "bin/opj_decompress", "bin/opj_dump"),
        UNSUPPORTED(null, null, null, null);

        String directory;
        String compressor;
        String decompressor;
        String dump;

        private OSCategory(String directory, String compressor, String decompressor, String dump) {
            this.directory = directory;
            this.compressor = compressor;
            this.decompressor = decompressor;
            this.dump = dump;
        }

        String getCompressor() {
            return String.format("%s%s%s", this.directory, File.separator, this.decompressor);
        }

        String getDecompressor() {
            return String.format("%s%s%s", this.directory, File.separator, this.decompressor);
        }

        String getDump() {
            return String.format("%s%s%s", this.directory, File.separator, this.dump);
        }

        static OSCategory getOSCategory() {
            OSCategory category;
            if (org.apache.commons.lang.SystemUtils.IS_OS_LINUX) {
                category = LINUX_32;
                try {
                    Process p = Runtime.getRuntime().exec("uname -m");
                    p.waitFor();
                    String osArch = OpenJpegUtils.convertStreamToString(p.getInputStream());
                    if (!osArch.equalsIgnoreCase("i686")) {
                        category = LINUX_64;
                    }
                }
                catch (IOException | InterruptedException e) {
                    SystemUtils.LOG.warning("Could not find system architecture 32/64 bits, openjpeg executables for 32 bits will be used: " + e.getMessage());
                }
            } else {
                String sysArch;
                category = org.apache.commons.lang.SystemUtils.IS_OS_MAC_OSX ? MAC_OS_X : (org.apache.commons.lang.SystemUtils.IS_OS_WINDOWS ? ((sysArch = System.getProperty("os.arch").toLowerCase()).contains("amd64") || sysArch.contains("x86_x64") ? WIN_64 : WIN_32) : UNSUPPORTED);
            }
            return category;
        }
    }
}

