/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2.boxes;

import java.io.IOException;
import java.util.UUID;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.Box;
import org.esa.s2tbx.dataio.jp2.BoxReader;
import org.esa.s2tbx.dataio.jp2.BoxType;

public class UuidBox
extends Box {
    private UUID uiid;
    private byte[] data;

    public UuidBox(BoxType type, long position, long length, int dataOffset) {
        super(type, position, length, dataOffset);
    }

    public UUID getUiid() {
        return this.uiid;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void readFrom(BoxReader reader) throws IOException {
        ImageInputStream stream = reader.getStream();
        long mostSigBits = stream.readLong();
        long leastSigBits = stream.readLong();
        this.uiid = new UUID(mostSigBits, leastSigBits);
        long dataLength = this.length - (stream.getStreamPosition() - this.position);
        this.data = new byte[(int)dataLength];
        int bytesRead = stream.read(this.data);
        if ((long)bytesRead != dataLength) {
            throw new IOException(String.format("Unable to read requested %d bytes from UUID Box", dataLength));
        }
    }
}

