/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2.boxes;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.Box;
import org.esa.s2tbx.dataio.jp2.BoxReader;
import org.esa.s2tbx.dataio.jp2.BoxType;

public class ImageHeaderBox
extends Box {
    private long height;
    private long width;
    private int nc;
    private int bpc;
    private int c;
    private int unkC;
    private int ipr;

    public ImageHeaderBox(BoxType type, long position, long length, int dataOffset) {
        super(type, position, length, dataOffset);
    }

    public long getHeight() {
        return this.height;
    }

    public long getWidth() {
        return this.width;
    }

    public int getNc() {
        return this.nc;
    }

    public int getBpc() {
        return this.bpc;
    }

    public int getC() {
        return this.c;
    }

    public int getUnkC() {
        return this.unkC;
    }

    public int getIpr() {
        return this.ipr;
    }

    @Override
    public void readFrom(BoxReader reader) throws IOException {
        ImageInputStream stream = reader.getStream();
        this.height = (long)stream.readInt() & 0xFFFFFFFFL;
        this.width = (long)stream.readInt() & 0xFFFFFFFFL;
        this.nc = stream.readShort() & 0xFFFF;
        this.bpc = stream.readByte() & 0xFF;
        this.c = stream.readByte() & 0xFF;
        this.unkC = stream.readByte() & 0xFF;
        this.ipr = stream.readByte() & 0xFF;
    }
}

