/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2.boxes;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.Box;
import org.esa.s2tbx.dataio.jp2.BoxReader;
import org.esa.s2tbx.dataio.jp2.BoxType;

public class ColorSpecificationBox
extends Box {
    private int meth;
    private int prec;
    private int approx;
    private long enumCS;
    private byte[] profile;

    public ColorSpecificationBox(BoxType type, long position, long length, int dataOffset) {
        super(type, position, length, dataOffset);
    }

    public int getMeth() {
        return this.meth;
    }

    public int getPrec() {
        return this.prec;
    }

    public int getApprox() {
        return this.approx;
    }

    public long getEnumCS() {
        return this.enumCS;
    }

    public byte[] getProfile() {
        return this.profile;
    }

    @Override
    public void readFrom(BoxReader reader) throws IOException {
        ImageInputStream stream = reader.getStream();
        this.meth = stream.readByte() & 0xFF;
        this.prec = stream.readByte();
        this.approx = stream.readByte() & 0xFF;
        this.enumCS = (long)stream.readInt() & 0xFFFFFFFFL;
        long profileLength = this.length - (stream.getStreamPosition() - this.position);
        this.profile = new byte[(int)profileLength];
        int bytesRead = stream.read(this.profile);
        if ((long)bytesRead != profileLength) {
            throw new IOException(String.format("Unable to read requested %d bytes from ColorSpecificationBox", profileLength));
        }
    }
}

