/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.MarkerSegment;
import org.esa.s2tbx.dataio.jp2.MarkerType;
import org.esa.s2tbx.dataio.jp2.segments.IgnoredSegment;

public class CodestreamReader {
    ImageInputStream stream;
    private final long position;
    long length;
    boolean init;

    public CodestreamReader(ImageInputStream stream, long position, long length) {
        this.stream = stream;
        this.position = position;
        this.length = length;
    }

    public MarkerSegment readSegment() throws IOException {
        int code;
        MarkerType markerType;
        if (!this.init) {
            this.init = true;
            this.stream.seek(this.position);
        }
        if ((markerType = MarkerType.get(code = this.stream.readShort() & 0xFFFF)) != null) {
            MarkerSegment segment = markerType.createSegment();
            segment.readFrom(this.stream);
            return segment;
        }
        IgnoredSegment segment = new IgnoredSegment(code);
        ((MarkerSegment)segment).readFrom(this.stream);
        return segment;
    }
}

