/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.esa.s2tbx.dataio.jp2.Box;
import org.esa.s2tbx.dataio.jp2.boxes.BitsPerComponentBox;
import org.esa.s2tbx.dataio.jp2.boxes.ColorSpecificationBox;
import org.esa.s2tbx.dataio.jp2.boxes.ContiguousCodestreamBox;
import org.esa.s2tbx.dataio.jp2.boxes.FileTypeBox;
import org.esa.s2tbx.dataio.jp2.boxes.IgnoredBox;
import org.esa.s2tbx.dataio.jp2.boxes.ImageHeaderBox;
import org.esa.s2tbx.dataio.jp2.boxes.Jp2HeaderBox;
import org.esa.s2tbx.dataio.jp2.boxes.Jpeg2000SignatureBox;
import org.esa.s2tbx.dataio.jp2.boxes.UuidBox;

public enum BoxType {
    ____("    ", IgnoredBox.class),
    jP__("jP  ", Jpeg2000SignatureBox.class),
    ftyp("ftyp", FileTypeBox.class),
    jp2h("jp2h", Jp2HeaderBox.class),
    ihdr("ihdr", ImageHeaderBox.class),
    bpcc("bpcc", BitsPerComponentBox.class),
    colr("colr", ColorSpecificationBox.class),
    jp2c("jp2c", ContiguousCodestreamBox.class),
    uuid("uuid", UuidBox.class);

    private static final Map<Integer, BoxType> codeMap;
    private final String symbol;
    private final int code;
    private final Class<? extends Box> type;

    private BoxType(String symbol, Class<? extends Box> type) {
        this.symbol = symbol;
        this.code = BoxType.decode4b(symbol);
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getCode() {
        return this.code;
    }

    public Class<? extends Box> getType() {
        return this.type;
    }

    public Box createBox(long offset, long length, int dataOffset) {
        try {
            Constructor<? extends Box> boxConstructor = this.type.getConstructor(BoxType.class, Long.TYPE, Long.TYPE, Integer.TYPE);
            return boxConstructor.newInstance(new Object[]{this, offset, length, dataOffset});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static BoxType get(Integer code) {
        return codeMap.get(code);
    }

    public static int decode4b(String v) {
        if (v.length() != 4) {
            throw new IllegalArgumentException();
        }
        return v.charAt(0) << 24 | v.charAt(1) << 16 | v.charAt(2) << 8 | v.charAt(3);
    }

    public static String encode4b(int v) {
        return new String(new byte[]{(byte)((v & 0xFF000000) >> 24), (byte)((v & 0xFF0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)});
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    static {
        BoxType[] values = BoxType.values();
        codeMap = new HashMap<Integer, BoxType>();
        for (BoxType value : values) {
            codeMap.put(value.getCode(), value);
        }
    }
}

