/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio.jp2;

import java.io.EOFException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s2tbx.dataio.jp2.AEmptyListener;
import org.esa.s2tbx.dataio.jp2.Box;
import org.esa.s2tbx.dataio.jp2.BoxType;
import org.esa.s2tbx.dataio.jp2.boxes.IgnoredBox;

public class BoxReader {
    private final ImageInputStream stream;
    private final long fileLength;
    private final Listener listener;

    public BoxReader(ImageInputStream stream, long fileLength, Listener listener) {
        this.stream = stream;
        this.fileLength = fileLength;
        this.listener = listener == null ? new AEmptyListener() : listener;
    }

    public ImageInputStream getStream() {
        return this.stream;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public Box readBox() throws IOException {
        Box box;
        int nextInt32;
        long position = this.stream.getStreamPosition();
        try {
            nextInt32 = this.stream.readInt();
        }
        catch (EOFException e) {
            return null;
        }
        long length = (long)nextInt32 & 0xFFFFFFFFL;
        int type = this.stream.readInt();
        int dataOffset = 8;
        if (length == 0L) {
            length = this.fileLength - position;
        } else if (length == 1L) {
            length = this.stream.readLong();
            dataOffset += 8;
        }
        if (length == 0L || length == 1L || length >= 8L) {
            BoxType boxType = BoxType.get(type);
            if (boxType != null) {
                box = boxType.createBox(position, length, dataOffset);
                box.readFrom(this);
                this.listener.knownBoxSeen(box);
            } else {
                box = new IgnoredBox(type, position, length, dataOffset);
                this.stream.seek(position + length);
                this.listener.unknownBoxSeen(box);
            }
        } else {
            box = new IgnoredBox(type, position, length, dataOffset);
            this.listener.unknownBoxSeen(box);
        }
        return box;
    }

    public static interface Listener {
        public void knownBoxSeen(Box var1);

        public void unknownBoxSeen(Box var1);
    }
}

