/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s2tbx.dataio;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Pattern;

public class Utils {
    public static String getStackTrace(Throwable tr) {
        StringWriter sw = new StringWriter();
        tr.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String GetShortPathName(String path) {
        if (!new File(path).exists()) {
            return "";
        }
        int sizeBuffer = 2048;
        byte[] shortt = new byte[sizeBuffer];
        CKernel32.INSTANCE.GetShortPathNameA(path, shortt, sizeBuffer);
        return Native.toString((byte[])shortt);
    }

    public static String GetIterativeShortPathName(String path) {
        if (!new File(path).exists()) {
            return "";
        }
        String firstTry = Utils.GetShortPathName(path);
        if (firstTry.length() != 0) {
            return firstTry;
        }
        int lenght = 0;
        String workingPath = path;
        while (lenght == 0) {
            workingPath = new File(workingPath).getParent();
            lenght = Utils.GetShortPathName(workingPath).length();
        }
        String[] shortenedFragments = Utils.GetShortPathName(workingPath).split(Pattern.quote(File.separator));
        CharSequence[] fragments = path.split(Pattern.quote(File.separator));
        if (fragments.length == 1) {
            fragments = path.split(Pattern.quote("/"));
        }
        System.arraycopy(shortenedFragments, 0, fragments, 0, shortenedFragments.length);
        String complete = String.join((CharSequence)File.separator, fragments);
        String shortComplete = Utils.GetShortPathName(complete);
        if (shortComplete.length() != 0) {
            return shortComplete;
        }
        return Utils.GetIterativeShortPathName(complete);
    }

    public static interface CKernel32
    extends Library {
        public static final CKernel32 INSTANCE = (CKernel32)Native.loadLibrary((String)"kernel32", CKernel32.class);

        public int GetShortPathNameA(String var1, byte[] var2, int var3);
    }
}

