/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class SRGROpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JScrollPane bandListPane = new JScrollPane(this.bandList);
    private final JLabel bandListLabel = new JLabel("Source Bands:");
    private final JComboBox<Integer> warpPolynomialOrder = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4});
    private final JComboBox<String> interpolationMethod = new JComboBox<String>(new String[]{"Nearest-neighbor interpolation", "Linear interpolation", "Cubic interpolation", "Cubic2 interpolation", "Sinc interpolation"});

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        if (this.sourceProducts != null) {
            DialogUtils.enableComponents((JComponent)this.bandListLabel, (JComponent)this.bandListPane, (boolean)true);
        }
        this.warpPolynomialOrder.setSelectedItem(this.paramMap.get("warpPolynomialOrder"));
        this.interpolationMethod.setSelectedItem(this.paramMap.get("interpolationMethod"));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("warpPolynomialOrder", this.warpPolynomialOrder.getSelectedItem());
        this.paramMap.put("interpolationMethod", this.interpolationMethod.getSelectedItem());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Warp Polynomial Order:", this.warpPolynomialOrder);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Interpolation Method:", this.interpolationMethod);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

