/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.s1tbx.calibration.gpf.support.CalibrationFactory;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.s1tbx.commons.SARGeocoding;
import org.esa.s1tbx.sar.gpf.ui.geometric.MapProjectionHandler;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RangeDopplerGeocodingOpUI
extends BaseOperatorUI {
    private final JList<String> bandList = new JList();
    private final JComboBox<String> demName = new JComboBox<String>(DEMFactory.getDEMNameList());
    private static final String externalDEMStr = "External DEM";
    private JComboBox<String> demResamplingMethod = new JComboBox<String>(DEMFactory.getDEMResamplingMethods());
    final JComboBox<String> imgResamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    final JComboBox<String> incidenceAngleForGamma0 = new JComboBox<String>(new String[]{"Use projected local incidence angle from DEM", "Use local incidence angle from DEM", "Use incidence angle from Ellipsoid"});
    final JComboBox<String> incidenceAngleForSigma0 = new JComboBox<String>(new String[]{"Use projected local incidence angle from DEM", "Use local incidence angle from DEM", "Use incidence angle from Ellipsoid"});
    final JComboBox<String> auxFile = new JComboBox<String>(new String[]{"Latest Auxiliary File", "Product Auxiliary File", "External Auxiliary File"});
    final JTextField pixelSpacingInMeter = new JTextField("");
    final JTextField pixelSpacingInDegree = new JTextField("");
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("External DEM No Data Value:");
    private final JCheckBox externalDEMApplyEGMCheckBox = new JCheckBox("Apply Earth Gravitational Model");
    final JLabel sourcePixelSpacingsLabelPart1 = new JLabel("Source GR Pixel Spacings (az x rg):");
    final JLabel sourcePixelSpacingsLabelPart2 = new JLabel("0.0(m) x 0.0(m)");
    final JCheckBox nodataValueAtSeaCheckBox = new JCheckBox("Mask out areas without elevation");
    final JCheckBox outputComplexCheckBox = new JCheckBox("Output complex data");
    final JCheckBox saveDEMCheckBox = new JCheckBox("DEM");
    final JCheckBox saveLatLonCheckBox = new JCheckBox("Latitude & Longitude");
    final JCheckBox saveIncidenceAngleFromEllipsoidCheckBox = new JCheckBox("Incidence angle from ellipsoid");
    final JCheckBox saveLocalIncidenceAngleCheckBox = new JCheckBox("Local incidence angle");
    final JCheckBox saveProjectedLocalIncidenceAngleCheckBox = new JCheckBox("Projected local incidence angle");
    final JCheckBox saveSelectedSourceBandCheckBox = new JCheckBox("Selected source band");
    final JCheckBox applyRadiometricNormalizationCheckBox = new JCheckBox("Apply radiometric normalization");
    final JCheckBox saveBetaNoughtCheckBox = new JCheckBox("Save Beta0 band");
    final JCheckBox saveGammaNoughtCheckBox = new JCheckBox("Save Gamma0 band");
    final JCheckBox saveSigmaNoughtCheckBox = new JCheckBox("Save Sigma0 band");
    final JLabel auxFileLabel = new JLabel("Auxiliary File (ASAR only):");
    final JLabel externalAuxFileLabel = new JLabel("External Aux File:");
    final JTextField externalAuxFile = new JTextField("");
    final JButton externalAuxFileBrowseButton = new JButton("...");
    private Boolean nodataValueAtSea = true;
    private Boolean outputComplex = false;
    private Boolean saveDEM = false;
    private Boolean saveLatLon = false;
    private Boolean saveIncidenceAngleFromEllipsoid = false;
    private Boolean saveLocalIncidenceAngle = false;
    private Boolean saveProjectedLocalIncidenceAngle = false;
    private Boolean saveSelectedSourceBand = false;
    private Boolean applyRadiometricNormalization = false;
    private Boolean saveBetaNought = false;
    private Boolean saveGammaNought = false;
    private Boolean saveSigmaNought = false;
    private Boolean externalDEMApplyEGM = true;
    private Double extNoDataValue = 0.0;
    private Double azimuthPixelSpacing = 0.0;
    private Double rangePixelSpacing = 0.0;
    private Double pixMSaved = 0.0;
    private Double pixDSaved = 0.0;
    private Double savedAzimuthPixelSpacing = 0.0;
    private Double savedRangePixelSpacing = 0.0;
    protected boolean useAvgSceneHeight = false;
    protected final JButton crsButton = new JButton();
    private final MapProjectionHandler mapProjHandler = new MapProjectionHandler();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.demName.addItem(externalDEMStr);
        this.initializeOperatorUI(operatorName, parameterMap);
        JScrollPane panel = new JScrollPane(this.createPanel());
        this.initParameters();
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (((String)RangeDopplerGeocodingOpUI.this.demName.getSelectedItem()).startsWith(RangeDopplerGeocodingOpUI.externalDEMStr)) {
                    RangeDopplerGeocodingOpUI.this.enableExternalDEM(true);
                } else {
                    RangeDopplerGeocodingOpUI.this.externalDEMFile.setText("");
                    RangeDopplerGeocodingOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(24);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.auxFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String item = (String)RangeDopplerGeocodingOpUI.this.auxFile.getSelectedItem();
                if (item.equals("External Auxiliary File")) {
                    RangeDopplerGeocodingOpUI.this.enableExternalAuxFile(true);
                } else {
                    RangeDopplerGeocodingOpUI.this.externalAuxFile.setText("");
                    RangeDopplerGeocodingOpUI.this.enableExternalAuxFile(false);
                }
            }
        });
        this.externalAuxFile.setColumns(24);
        String auxFileParam = (String)parameterMap.get("auxFile");
        if (auxFileParam != null) {
            this.auxFile.setSelectedItem(auxFileParam);
        }
        this.enableExternalAuxFile(false);
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External DEM File", (boolean)false, null, (String)"snap.externalDEMDir");
                RangeDopplerGeocodingOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                RangeDopplerGeocodingOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                RangeDopplerGeocodingOpUI.this.externalDEMNoDataValue.setText(String.valueOf(RangeDopplerGeocodingOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMApplyEGMCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.externalDEMApplyEGM = e.getStateChange() == 1;
            }
        });
        this.nodataValueAtSeaCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.nodataValueAtSea = e.getStateChange() == 1;
            }
        });
        this.outputComplexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.outputComplex = e.getStateChange() == 1;
            }
        });
        this.saveDEMCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveDEM = e.getStateChange() == 1;
            }
        });
        this.saveLatLonCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveLatLon = e.getStateChange() == 1;
            }
        });
        this.saveIncidenceAngleFromEllipsoidCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveIncidenceAngleFromEllipsoid = e.getStateChange() == 1;
            }
        });
        this.saveLocalIncidenceAngleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveLocalIncidenceAngle = e.getStateChange() == 1;
            }
        });
        this.saveProjectedLocalIncidenceAngleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveProjectedLocalIncidenceAngle = e.getStateChange() == 1;
            }
        });
        this.saveSelectedSourceBandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveSelectedSourceBand = e.getStateChange() == 1;
            }
        });
        this.applyRadiometricNormalizationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.applyRadiometricNormalization = e.getStateChange() == 1;
                if (RangeDopplerGeocodingOpUI.this.applyRadiometricNormalization.booleanValue()) {
                    MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)RangeDopplerGeocodingOpUI.this.sourceProducts[0]);
                    if (absRoot != null) {
                        int isCalibrated = absRoot.getAttributeInt("abs_calibration_flag", 0);
                        if (isCalibrated == 0 && RangeDopplerGeocodingOpUI.this.canCalibrate()) {
                            RangeDopplerGeocodingOpUI.this.enableRadiometricNormalization(true);
                            RangeDopplerGeocodingOpUI.this.saveSigmaNoughtCheckBox.setSelected(RangeDopplerGeocodingOpUI.this.saveSigmaNought);
                            RangeDopplerGeocodingOpUI.this.saveGammaNoughtCheckBox.setSelected(RangeDopplerGeocodingOpUI.this.saveGammaNought);
                            RangeDopplerGeocodingOpUI.this.saveBetaNoughtCheckBox.setSelected(RangeDopplerGeocodingOpUI.this.saveBetaNought);
                            RangeDopplerGeocodingOpUI.this.saveSelectedSourceBandCheckBox.setSelected(false);
                        } else {
                            RangeDopplerGeocodingOpUI.this.enableRadiometricNormalization(false);
                            RangeDopplerGeocodingOpUI.this.saveSelectedSourceBandCheckBox.setSelected(true);
                        }
                    }
                } else {
                    RangeDopplerGeocodingOpUI.this.enableRadiometricNormalization(false);
                    RangeDopplerGeocodingOpUI.this.saveSelectedSourceBandCheckBox.setSelected(true);
                }
            }
        });
        this.saveBetaNoughtCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveBetaNought = e.getStateChange() == 1;
                if (RangeDopplerGeocodingOpUI.this.saveBetaNought.booleanValue()) {
                    RangeDopplerGeocodingOpUI.this.saveSigmaNoughtCheckBox.setSelected(true);
                    RangeDopplerGeocodingOpUI.this.saveProjectedLocalIncidenceAngleCheckBox.setSelected(true);
                }
            }
        });
        this.saveGammaNoughtCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveGammaNought = e.getStateChange() == 1;
                if (RangeDopplerGeocodingOpUI.this.saveGammaNought.booleanValue()) {
                    RangeDopplerGeocodingOpUI.this.saveSigmaNoughtCheckBox.setSelected(true);
                    RangeDopplerGeocodingOpUI.this.saveProjectedLocalIncidenceAngleCheckBox.setSelected(true);
                }
            }
        });
        this.saveSigmaNoughtCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RangeDopplerGeocodingOpUI.this.saveSigmaNought = e.getStateChange() == 1;
                if (RangeDopplerGeocodingOpUI.this.saveSigmaNought.booleanValue()) {
                    if (RangeDopplerGeocodingOpUI.this.incidenceAngleForSigma0.getSelectedItem().equals("Use projected local incidence angle from DEM")) {
                        RangeDopplerGeocodingOpUI.this.saveProjectedLocalIncidenceAngleCheckBox.setSelected(false);
                    } else {
                        RangeDopplerGeocodingOpUI.this.saveProjectedLocalIncidenceAngleCheckBox.setSelected(true);
                    }
                }
            }
        });
        this.externalAuxFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External Aux File", (boolean)false, null, (String)"s1tbx.calibration.aux.file");
                RangeDopplerGeocodingOpUI.this.externalAuxFile.setText(file.getAbsolutePath());
            }
        });
        this.crsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeDopplerGeocodingOpUI.this.mapProjHandler.promptForFeatureCrs(RangeDopplerGeocodingOpUI.this.sourceProducts);
                RangeDopplerGeocodingOpUI.this.crsButton.setText(RangeDopplerGeocodingOpUI.this.mapProjHandler.getCRSName());
            }
        });
        return panel;
    }

    private boolean canCalibrate() {
        Calibrator calibrator = null;
        try {
            calibrator = CalibrationFactory.createCalibrator((Product)this.sourceProducts[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calibrator != null;
    }

    public void initParameters() {
        File extAuxFile;
        String auxFileStr;
        MetadataElement absRoot;
        Boolean paramVal;
        File extDEMFile;
        OperatorUIUtils.initParamList(this.bandList, (String[])this.getBandNames());
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            ElevationModelDescriptor descriptor = ElevationModelRegistry.getInstance().getDescriptor(demNameParam);
            if (descriptor != null) {
                this.demName.setSelectedItem(DEMFactory.getDEMDisplayName((ElevationModelDescriptor)descriptor));
            } else {
                this.demName.setSelectedItem(demNameParam);
            }
        }
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("demResamplingMethod"));
        this.imgResamplingMethod.setSelectedItem(this.paramMap.get("imgResamplingMethod"));
        this.incidenceAngleForGamma0.setSelectedItem(this.paramMap.get("incidenceAngleForGamma0"));
        this.incidenceAngleForSigma0.setSelectedItem(this.paramMap.get("incidenceAngleForSigma0"));
        String mapProjection = (String)this.paramMap.get("mapProjection");
        this.mapProjHandler.initParameters(mapProjection, this.sourceProducts);
        this.crsButton.setText(this.mapProjHandler.getCRSName());
        this.pixMSaved = (Double)this.paramMap.get("pixelSpacingInMeter");
        if (this.pixMSaved != null && this.pixMSaved != 0.0) {
            this.pixelSpacingInMeter.setText(String.valueOf(this.pixMSaved));
        }
        this.pixDSaved = (Double)this.paramMap.get("pixelSpacingInDegree");
        if (this.pixDSaved != null && this.pixDSaved != 0.0) {
            this.pixelSpacingInDegree.setText(String.valueOf(this.pixDSaved));
        }
        if (this.sourceProducts != null) {
            MetadataElement absRoot2;
            try {
                this.azimuthPixelSpacing = SARGeocoding.getAzimuthPixelSpacing((Product)this.sourceProducts[0]);
                this.rangePixelSpacing = SARGeocoding.getRangePixelSpacing((Product)this.sourceProducts[0]);
                this.azimuthPixelSpacing = (double)((int)(this.azimuthPixelSpacing * 100.0 + 0.5)) / 100.0;
                this.rangePixelSpacing = (double)((int)(this.rangePixelSpacing * 100.0 + 0.5)) / 100.0;
            }
            catch (Exception e) {
                this.azimuthPixelSpacing = 0.0;
                this.rangePixelSpacing = 0.0;
            }
            String text = Double.toString(this.azimuthPixelSpacing) + "(m) x " + Double.toString(this.rangePixelSpacing) + "(m)";
            this.sourcePixelSpacingsLabelPart2.setText(text);
            if (this.savedAzimuthPixelSpacing.compareTo(0.0) != 0 && this.savedRangePixelSpacing.compareTo(0.0) != 0 && (this.savedAzimuthPixelSpacing.compareTo(this.azimuthPixelSpacing) != 0 || this.savedRangePixelSpacing.compareTo(this.rangePixelSpacing) != 0)) {
                this.pixDSaved = null;
            }
            if (this.pixDSaved == null || this.pixDSaved.equals(0.0)) {
                try {
                    if (this.pixMSaved == null || this.pixMSaved.equals(0.0)) {
                        this.pixMSaved = Math.max(this.azimuthPixelSpacing, this.rangePixelSpacing);
                    }
                    this.pixDSaved = SARGeocoding.getPixelSpacingInDegree((double)this.pixMSaved);
                }
                catch (Exception e) {
                    this.pixMSaved = 0.0;
                    this.pixDSaved = 0.0;
                }
                this.pixelSpacingInMeter.setText(String.valueOf(this.pixMSaved));
                this.pixelSpacingInDegree.setText(String.valueOf(this.pixDSaved));
                this.savedAzimuthPixelSpacing = this.azimuthPixelSpacing;
                this.savedRangePixelSpacing = this.rangePixelSpacing;
            }
            if (this.pixMSaved == null || this.pixMSaved.equals(0.0)) {
                try {
                    this.pixMSaved = SARGeocoding.getPixelSpacingInMeter((double)this.pixDSaved);
                }
                catch (Exception e) {
                    this.pixMSaved = 0.0;
                    this.pixDSaved = 0.0;
                }
                this.pixelSpacingInMeter.setText(String.valueOf(this.pixMSaved));
                this.pixelSpacingInDegree.setText(String.valueOf(this.pixDSaved));
                this.savedAzimuthPixelSpacing = this.azimuthPixelSpacing;
                this.savedRangePixelSpacing = this.rangePixelSpacing;
            }
            if ((absRoot2 = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0])) != null) {
                boolean isComplex = absRoot2.getAttributeString("sample_type").equals("COMPLEX");
                this.outputComplexCheckBox.setEnabled(isComplex);
            }
        }
        if ((extDEMFile = (File)this.paramMap.get("externalDEMFile")) != null) {
            this.externalDEMFile.setText(extDEMFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
            if ((paramVal = (Boolean)this.paramMap.get("externalDEMApplyEGM")) != null) {
                this.externalDEMApplyEGM = paramVal;
                this.externalDEMApplyEGMCheckBox.setSelected(this.externalDEMApplyEGM);
            }
        }
        if ((paramVal = (Boolean)this.paramMap.get("nodataValueAtSea")) != null) {
            this.nodataValueAtSea = paramVal;
            this.nodataValueAtSeaCheckBox.setSelected(this.nodataValueAtSea);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputComplex")) != null) {
            this.outputComplex = paramVal;
            this.outputComplexCheckBox.setSelected(this.outputComplex);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveDEM")) != null) {
            this.saveDEM = paramVal;
            this.saveDEMCheckBox.setSelected(this.saveDEM);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveLatLon")) != null) {
            this.saveLatLon = paramVal;
            this.saveLatLonCheckBox.setSelected(this.saveLatLon);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveIncidenceAngleFromEllipsoid")) != null) {
            this.saveIncidenceAngleFromEllipsoid = paramVal;
            this.saveIncidenceAngleFromEllipsoidCheckBox.setSelected(this.saveIncidenceAngleFromEllipsoid);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveLocalIncidenceAngle")) != null) {
            this.saveLocalIncidenceAngle = paramVal;
            this.saveLocalIncidenceAngleCheckBox.setSelected(this.saveLocalIncidenceAngle);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveProjectedLocalIncidenceAngle")) != null) {
            this.saveProjectedLocalIncidenceAngle = paramVal;
            this.saveProjectedLocalIncidenceAngleCheckBox.setSelected(this.saveProjectedLocalIncidenceAngle);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveSelectedSourceBand")) != null) {
            this.saveSelectedSourceBand = paramVal;
            this.saveSelectedSourceBandCheckBox.setSelected(this.saveSelectedSourceBand);
        }
        if ((paramVal = (Boolean)this.paramMap.get("applyRadiometricNormalization")) != null) {
            this.applyRadiometricNormalization = paramVal;
            this.applyRadiometricNormalizationCheckBox.setSelected(this.applyRadiometricNormalization);
            this.incidenceAngleForGamma0.setEnabled(this.applyRadiometricNormalization);
            this.incidenceAngleForSigma0.setEnabled(this.applyRadiometricNormalization);
            this.saveSigmaNoughtCheckBox.setEnabled(this.applyRadiometricNormalization);
            this.saveGammaNoughtCheckBox.setEnabled(this.applyRadiometricNormalization);
            this.saveBetaNoughtCheckBox.setEnabled(this.applyRadiometricNormalization);
        } else {
            this.enableRadiometricNormalization(false);
            this.saveSelectedSourceBandCheckBox.setSelected(true);
        }
        paramVal = (Boolean)this.paramMap.get("saveBetaNought");
        if (paramVal != null) {
            this.saveBetaNought = paramVal;
            this.saveBetaNoughtCheckBox.setSelected(this.saveBetaNought);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveGammaNought")) != null) {
            this.saveGammaNought = paramVal;
            this.saveGammaNoughtCheckBox.setSelected(this.saveGammaNought);
        }
        if ((paramVal = (Boolean)this.paramMap.get("saveSigmaNought")) != null) {
            this.saveSigmaNought = paramVal;
            this.saveSigmaNoughtCheckBox.setSelected(this.saveSigmaNought);
        }
        if (this.sourceProducts != null && (absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0])) != null) {
            String sampleType = absRoot.getAttributeString("SAMPLE_TYPE");
            if (sampleType.equals("COMPLEX")) {
                this.auxFile.removeItem("Product Auxiliary File");
            } else if (this.auxFile.getItemCount() == 2) {
                this.auxFile.addItem("Product Auxiliary File");
            }
        }
        if ((auxFileStr = (String)this.paramMap.get("auxFile")) != null) {
            this.auxFile.setSelectedItem(auxFileStr);
        }
        if ((extAuxFile = (File)this.paramMap.get("externalAuxFile")) != null) {
            this.externalAuxFile.setText(extAuxFile.getAbsolutePath());
        }
        if (this.applyRadiometricNormalization != null) {
            this.auxFile.setEnabled(this.applyRadiometricNormalization);
            this.auxFileLabel.setEnabled(this.applyRadiometricNormalization);
            this.externalAuxFile.setEnabled(this.applyRadiometricNormalization);
            this.externalAuxFileLabel.setEnabled(this.applyRadiometricNormalization);
            this.externalAuxFileBrowseButton.setEnabled(this.applyRadiometricNormalization);
        }
    }

    public UIValidation validateParameters() {
        MetadataElement absRoot;
        if (this.sourceProducts != null && (absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0])) != null) {
            boolean isPolsar;
            boolean antElevCorrFlag = absRoot.getAttributeInt("ant_elev_corr_flag") != 0;
            boolean multilookFlag = absRoot.getAttributeInt("multilook_flag") != 0;
            String mission = absRoot.getAttributeString("MISSION");
            boolean bl = isPolsar = absRoot.getAttributeInt("polsar_data", 0) == 1;
            if (isPolsar && this.applyRadiometricNormalization.booleanValue()) {
                this.applyRadiometricNormalization = false;
                this.enableRadiometricNormalization(false);
                this.saveSelectedSourceBandCheckBox.setSelected(true);
                return new UIValidation(UIValidation.State.WARNING, "Radiometric normalization is not available for polarimetric matrix products");
            }
            if ((mission.equals("ENVISAT") || mission.contains("ERS")) && this.applyRadiometricNormalization.booleanValue() && antElevCorrFlag && multilookFlag) {
                return new UIValidation(UIValidation.State.WARNING, "For multilooked products only constant and incidence angle corrections will be performed for radiometric normalization");
            }
            if (!this.canCalibrate() && this.applyRadiometricNormalization.booleanValue()) {
                this.applyRadiometricNormalization = false;
                this.enableRadiometricNormalization(false);
                this.saveSelectedSourceBandCheckBox.setSelected(true);
                return new UIValidation(UIValidation.State.WARNING, "Radiometric normalization currently is not available for " + mission + " products");
            }
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList(this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        String properDEMName = DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem()));
        this.paramMap.put("demName", properDEMName);
        this.paramMap.put("demResamplingMethod", this.demResamplingMethod.getSelectedItem());
        this.paramMap.put("imgResamplingMethod", this.imgResamplingMethod.getSelectedItem());
        this.paramMap.put("incidenceAngleForGamma0", this.incidenceAngleForGamma0.getSelectedItem());
        this.paramMap.put("incidenceAngleForSigma0", this.incidenceAngleForSigma0.getSelectedItem());
        if (this.pixelSpacingInMeter.getText().isEmpty()) {
            this.paramMap.put("pixelSpacingInMeter", 0.0);
        } else {
            this.paramMap.put("pixelSpacingInMeter", Double.parseDouble(this.pixelSpacingInMeter.getText()));
        }
        if (this.pixelSpacingInDegree.getText().isEmpty()) {
            this.paramMap.put("pixelSpacingInDegree", 0.0);
        } else {
            this.paramMap.put("pixelSpacingInDegree", Double.parseDouble(this.pixelSpacingInDegree.getText()));
        }
        if (properDEMName.equals(externalDEMStr)) {
            String extFileStr = this.externalDEMFile.getText();
            this.paramMap.put("externalDEMFile", new File(extFileStr));
            this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
            this.paramMap.put("externalDEMApplyEGM", this.externalDEMApplyEGM);
        }
        if (this.mapProjHandler.getCRS() != null) {
            CoordinateReferenceSystem crs = this.mapProjHandler.getCRS();
            try {
                this.paramMap.put("mapProjection", crs.toWKT());
            }
            catch (UnformattableObjectException e) {
                this.paramMap.put("mapProjection", crs.toString());
            }
        }
        this.paramMap.put("nodataValueAtSea", this.nodataValueAtSea);
        this.paramMap.put("outputComplex", this.outputComplex);
        this.paramMap.put("saveDEM", this.saveDEM);
        this.paramMap.put("saveLatLon", this.saveLatLon);
        this.paramMap.put("saveIncidenceAngleFromEllipsoid", this.saveIncidenceAngleFromEllipsoid);
        this.paramMap.put("saveLocalIncidenceAngle", this.saveLocalIncidenceAngle);
        this.paramMap.put("saveProjectedLocalIncidenceAngle", this.saveProjectedLocalIncidenceAngle);
        this.paramMap.put("saveSelectedSourceBand", this.saveSelectedSourceBand);
        this.paramMap.put("applyRadiometricNormalization", this.applyRadiometricNormalization);
        this.paramMap.put("saveBetaNought", this.saveBetaNought);
        this.paramMap.put("saveGammaNought", this.saveGammaNought);
        this.paramMap.put("saveSigmaNought", this.saveSigmaNought);
        this.paramMap.put("auxFile", this.auxFile.getSelectedItem());
        String extAuxFileStr = this.externalAuxFile.getText();
        if (!extAuxFileStr.isEmpty()) {
            this.paramMap.put("externalAuxFile", new File(extAuxFileStr));
        }
    }

    JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        if (!this.useAvgSceneHeight) {
            DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
            ++gbc.gridy;
            DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (JComponent)this.externalDEMBrowseButton);
            ++gbc.gridy;
            DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
            ++gbc.gridy;
            gbc.gridx = 1;
            contentPane.add((Component)this.externalDEMApplyEGMCheckBox, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"DEM Resampling Method:", this.demResamplingMethod);
            ++gbc.gridy;
        }
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Image Resampling Method:", this.imgResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.sourcePixelSpacingsLabelPart1, (JComponent)this.sourcePixelSpacingsLabelPart2);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Pixel Spacing (m):", (JComponent)this.pixelSpacingInMeter);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Pixel Spacing (deg):", (JComponent)this.pixelSpacingInDegree);
        this.pixelSpacingInMeter.addFocusListener(new PixelSpacingMeterListener());
        this.pixelSpacingInDegree.addFocusListener(new PixelSpacingDegreeListener());
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Map Projection:", (JComponent)this.crsButton);
        if (!this.useAvgSceneHeight) {
            ++gbc.gridy;
            contentPane.add((Component)this.nodataValueAtSeaCheckBox, gbc);
            gbc.gridx = 1;
            contentPane.add((Component)this.outputComplexCheckBox, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        JPanel saveBandsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = DialogUtils.createGridBagConstraints();
        saveBandsPanel.setBorder(BorderFactory.createTitledBorder("Output bands for:"));
        gbc2.gridx = 0;
        saveBandsPanel.add((Component)this.saveSelectedSourceBandCheckBox, gbc2);
        if (!this.useAvgSceneHeight) {
            gbc2.gridx = 1;
            saveBandsPanel.add((Component)this.saveDEMCheckBox, gbc2);
        }
        gbc2.gridx = 2;
        saveBandsPanel.add((Component)this.saveLatLonCheckBox, gbc2);
        ++gbc2.gridy;
        gbc2.gridx = 0;
        saveBandsPanel.add((Component)this.saveIncidenceAngleFromEllipsoidCheckBox, gbc2);
        if (!this.useAvgSceneHeight) {
            gbc2.gridx = 1;
            saveBandsPanel.add((Component)this.saveLocalIncidenceAngleCheckBox, gbc2);
            gbc2.gridx = 2;
            saveBandsPanel.add((Component)this.saveProjectedLocalIncidenceAngleCheckBox, gbc2);
        }
        gbc.gridwidth = 2;
        contentPane.add((Component)saveBandsPanel, gbc);
        if (!this.useAvgSceneHeight) {
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            ++gbc.gridy;
            contentPane.add((Component)this.applyRadiometricNormalizationCheckBox, gbc);
            ++gbc.gridy;
            gbc.insets.left = 20;
            contentPane.add((Component)this.saveSigmaNoughtCheckBox, gbc);
            gbc.gridx = 1;
            gbc.insets.left = 1;
            contentPane.add(this.incidenceAngleForSigma0, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.insets.left = 20;
            contentPane.add((Component)this.saveGammaNoughtCheckBox, gbc);
            gbc.gridx = 1;
            gbc.insets.left = 1;
            contentPane.add(this.incidenceAngleForGamma0, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.insets.left = 20;
            contentPane.add((Component)this.saveBetaNoughtCheckBox, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.insets.left = 0;
            DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.auxFileLabel, this.auxFile);
            ++gbc.gridy;
            DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalAuxFileLabel, (JComponent)this.externalAuxFile, (JComponent)this.externalAuxFileBrowseButton);
        }
        return contentPane;
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        if (!flag) {
            this.externalDEMFile.setText("");
        }
        this.externalDEMBrowseButton.setVisible(flag);
        this.externalDEMApplyEGMCheckBox.setVisible(flag);
    }

    private void enableExternalAuxFile(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalAuxFileLabel, (JComponent)this.externalAuxFile, (boolean)flag);
        this.externalAuxFileBrowseButton.setVisible(flag);
    }

    private void enableRadiometricNormalization(boolean flag) {
        this.saveSigmaNoughtCheckBox.setSelected(flag);
        if (!flag) {
            this.saveGammaNoughtCheckBox.setSelected(false);
            this.saveBetaNoughtCheckBox.setSelected(false);
        }
        this.saveSigmaNoughtCheckBox.setEnabled(flag);
        this.saveGammaNoughtCheckBox.setEnabled(flag);
        this.saveBetaNoughtCheckBox.setEnabled(flag);
        this.incidenceAngleForSigma0.setEnabled(flag);
        this.incidenceAngleForGamma0.setEnabled(flag);
        this.auxFile.setEnabled(flag);
        this.auxFileLabel.setEnabled(flag);
        this.externalAuxFile.setEnabled(flag);
        this.externalAuxFileLabel.setEnabled(flag);
        this.externalAuxFileBrowseButton.setEnabled(flag);
    }

    protected class PixelSpacingDegreeListener
    implements FocusListener {
        protected PixelSpacingDegreeListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Double pixM = 0.0;
            Double pixD = 0.0;
            try {
                pixD = Double.parseDouble(RangeDopplerGeocodingOpUI.this.pixelSpacingInDegree.getText());
                if (Double.compare(pixD, RangeDopplerGeocodingOpUI.this.pixDSaved) != 0) {
                    pixM = SARGeocoding.getPixelSpacingInMeter((double)pixD);
                    RangeDopplerGeocodingOpUI.this.pixelSpacingInMeter.setText(String.valueOf(pixM));
                    RangeDopplerGeocodingOpUI.this.pixMSaved = pixM;
                    RangeDopplerGeocodingOpUI.this.pixDSaved = pixD;
                }
            }
            catch (Exception ec) {
                pixM = 0.0;
            }
        }
    }

    protected class PixelSpacingMeterListener
    implements FocusListener {
        protected PixelSpacingMeterListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Double pixM = 0.0;
            Double pixD = 0.0;
            try {
                pixM = Double.parseDouble(RangeDopplerGeocodingOpUI.this.pixelSpacingInMeter.getText());
                if (Double.compare(pixM, RangeDopplerGeocodingOpUI.this.pixMSaved) != 0) {
                    pixD = SARGeocoding.getPixelSpacingInDegree((double)pixM);
                    RangeDopplerGeocodingOpUI.this.pixelSpacingInDegree.setText(String.valueOf(pixD));
                    RangeDopplerGeocodingOpUI.this.pixMSaved = pixM;
                    RangeDopplerGeocodingOpUI.this.pixDSaved = pixD;
                }
            }
            catch (Exception ec) {
                pixD = 0.0;
            }
        }
    }
}

