/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class ALOSDeskewingUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox demName = new JComboBox<String>(DEMFactory.getDEMNameList());

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            ElevationModelDescriptor descriptor = ElevationModelRegistry.getInstance().getDescriptor(demNameParam);
            if (descriptor != null) {
                this.demName.setSelectedItem(DEMFactory.getDEMDisplayName((ElevationModelDescriptor)descriptor));
            } else {
                this.demName.setSelectedItem(demNameParam);
            }
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", (JComponent)this.demName);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

