/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.filtering;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class SpeckleFilterOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> filter = new JComboBox<String>(new String[]{"None", "Boxcar", "Median", "Frost", "Gamma Map", "Lee", "Refined Lee", "Lee Sigma", "IDAN"});
    private final JComboBox<String> numLooks = new JComboBox<String>(new String[]{"1", "2", "3", "4"});
    private final JComboBox<String> windowSize = new JComboBox<String>(new String[]{"5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17"});
    private final JComboBox<String> targetWindowSize = new JComboBox<String>(new String[]{"3x3", "5x5"});
    private final JComboBox<String> sigmaStr = new JComboBox<String>(new String[]{"0.5", "0.6", "0.7", "0.8", "0.9"});
    private static final JLabel dampingFactorLabel = new JLabel("Damping Factor:");
    private static final JLabel filterSizeXLabel = new JLabel("Filter Size X (odd number):   ");
    private static final JLabel filterSizeYLabel = new JLabel("Filter Size Y (odd number):   ");
    private static final JLabel numLooksLabel = new JLabel("Number of Looks:");
    private static final JLabel windowSizeLabel = new JLabel("Window Size:");
    private static final JLabel sigmaStrLabel = new JLabel("Sigma:");
    private static final JLabel targetWindowSizeLabel = new JLabel("Target Window Size:");
    private final JTextField filterSizeX = new JTextField("");
    private final JTextField filterSizeY = new JTextField("");
    private final JTextField dampingFactor = new JTextField("");
    private final JLabel estimateENLCheckBoxLabel = new JLabel("Estimate Equivalent Number of Looks");
    private final JCheckBox estimateENLCheckBox = new JCheckBox("");
    private final JLabel enlLabel = new JLabel("Number of Looks:   ");
    private final JTextField enl = new JTextField("");
    private Boolean estimateENL = true;
    private final JLabel anSizeLabel = new JLabel("Adaptive Neighbour Size");
    private final JTextField anSize = new JTextField("");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.estimateENLCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SpeckleFilterOpUI.this.estimateENL = e.getStateChange() == 1;
                if (SpeckleFilterOpUI.this.estimateENL.booleanValue()) {
                    SpeckleFilterOpUI.this.enl.setEnabled(false);
                } else {
                    SpeckleFilterOpUI.this.enl.setEnabled(true);
                }
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String value = (String)this.paramMap.get("filter");
        if (value.equals("Mean")) {
            this.filter.setSelectedItem("Boxcar");
        } else {
            this.filter.setSelectedItem(this.paramMap.get("filter"));
        }
        this.filterSizeX.setText(String.valueOf(this.paramMap.get("filterSizeX")));
        this.filterSizeY.setText(String.valueOf(this.paramMap.get("filterSizeY")));
        this.dampingFactor.setText(String.valueOf(this.paramMap.get("dampingFactor")));
        this.estimateENLCheckBox.setSelected(true);
        this.estimateENL = true;
        this.enl.setEnabled(false);
        this.enl.setText(String.valueOf(this.paramMap.get("enl")));
        this.numLooks.setSelectedItem(this.paramMap.get("numLooksStr"));
        this.windowSize.setSelectedItem(this.paramMap.get("windowSize"));
        this.targetWindowSize.setSelectedItem(this.paramMap.get("targetWindowSizeStr"));
        this.sigmaStr.setSelectedItem(this.paramMap.get("sigmaStr"));
        Integer anSizeStr = (Integer)this.paramMap.get("anSize");
        this.anSize.setText(String.valueOf(anSizeStr == null ? 50 : anSizeStr));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("filter", this.filter.getSelectedItem());
        this.paramMap.put("filterSizeX", Integer.parseInt(this.filterSizeX.getText()));
        this.paramMap.put("filterSizeY", Integer.parseInt(this.filterSizeY.getText()));
        this.paramMap.put("dampingFactor", Integer.parseInt(this.dampingFactor.getText()));
        this.paramMap.put("estimateENL", this.estimateENL);
        this.paramMap.put("enl", Double.parseDouble(this.enl.getText()));
        this.paramMap.put("numLooksStr", this.numLooks.getSelectedItem());
        this.paramMap.put("windowSize", this.windowSize.getSelectedItem());
        this.paramMap.put("targetWindowSizeStr", this.targetWindowSize.getSelectedItem());
        this.paramMap.put("sigmaStr", this.sigmaStr.getSelectedItem());
        this.paramMap.put("anSize", Integer.parseInt(this.anSize.getText()));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.fill = 1;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Source Bands:", (JComponent)new JScrollPane(this.bandList));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Filter:", this.filter);
        this.filter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SpeckleFilterOpUI.this.updateFilterSelection();
            }
        });
        gbc.fill = 2;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)filterSizeXLabel, (JComponent)this.filterSizeX);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)numLooksLabel, this.numLooks);
        DialogUtils.enableComponents((JComponent)filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
        DialogUtils.enableComponents((JComponent)numLooksLabel, this.numLooks, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)filterSizeYLabel, (JComponent)this.filterSizeY);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)windowSizeLabel, this.windowSize);
        DialogUtils.enableComponents((JComponent)filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
        DialogUtils.enableComponents((JComponent)windowSizeLabel, this.windowSize, (boolean)false);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.anSizeLabel, (JComponent)this.anSize);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)dampingFactorLabel, (JComponent)this.dampingFactor);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)sigmaStrLabel, this.sigmaStr);
        DialogUtils.enableComponents((JComponent)dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)false);
        DialogUtils.enableComponents((JComponent)sigmaStrLabel, this.sigmaStr, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.enlLabel, (JComponent)this.enl);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)targetWindowSizeLabel, this.targetWindowSize);
        DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)false);
        DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, this.targetWindowSize, (boolean)false);
        gbc.weightx = 1.0;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void updateFilterSelection() {
        String item = (String)this.filter.getSelectedItem();
        DialogUtils.enableComponents((JComponent)filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)false);
        DialogUtils.enableComponents((JComponent)filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)false);
        DialogUtils.enableComponents((JComponent)dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)false);
        DialogUtils.enableComponents((JComponent)numLooksLabel, this.numLooks, (boolean)false);
        DialogUtils.enableComponents((JComponent)windowSizeLabel, this.windowSize, (boolean)false);
        DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, this.targetWindowSize, (boolean)false);
        DialogUtils.enableComponents((JComponent)sigmaStrLabel, this.sigmaStr, (boolean)false);
        DialogUtils.enableComponents((JComponent)this.anSizeLabel, (JComponent)this.anSize, (boolean)false);
        if (item.equals("Boxcar") || item.equals("Median")) {
            DialogUtils.enableComponents((JComponent)filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
            DialogUtils.enableComponents((JComponent)filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
        }
        if (item.equals("Frost")) {
            DialogUtils.enableComponents((JComponent)filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
            DialogUtils.enableComponents((JComponent)filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
            DialogUtils.enableComponents((JComponent)dampingFactorLabel, (JComponent)this.dampingFactor, (boolean)true);
        }
        if (item.equals("Gamma Map") || item.equals("Lee")) {
            DialogUtils.enableComponents((JComponent)filterSizeXLabel, (JComponent)this.filterSizeX, (boolean)true);
            DialogUtils.enableComponents((JComponent)filterSizeYLabel, (JComponent)this.filterSizeY, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.estimateENLCheckBoxLabel, (JComponent)this.estimateENLCheckBox, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.enlLabel, (JComponent)this.enl, (boolean)true);
            this.estimateENLCheckBox.setSelected(true);
            this.enl.setEnabled(false);
        }
        if (item.equals("Lee Sigma")) {
            DialogUtils.enableComponents((JComponent)numLooksLabel, this.numLooks, (boolean)true);
            DialogUtils.enableComponents((JComponent)windowSizeLabel, this.windowSize, (boolean)true);
            DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, this.targetWindowSize, (boolean)true);
            DialogUtils.enableComponents((JComponent)sigmaStrLabel, this.sigmaStr, (boolean)true);
        }
        if (item.equals("IDAN")) {
            DialogUtils.enableComponents((JComponent)numLooksLabel, this.numLooks, (boolean)true);
            DialogUtils.enableComponents((JComponent)this.anSizeLabel, (JComponent)this.anSize, (boolean)true);
        }
    }
}

