/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.esa.s1tbx.sar.gpf.MultilookOp;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class MultilookOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JTextField nRgLooks = new JTextField("");
    private final JTextField nAzLooks = new JTextField("");
    private final JTextField meanGRSqaurePixel = new JTextField("");
    private final JCheckBox grSquarePixelCheckBox = new JCheckBox("GR Square Pixel");
    private final JCheckBox independentLooksCheckBox = new JCheckBox("Independent Looks");
    private final JCheckBox outputIntensityCheckBox = new JCheckBox("Output Intensity");
    private Boolean outputIntensity = false;
    private Boolean grSquarePixel = true;
    private final MultilookOp.DerivedParams param = new MultilookOp.DerivedParams();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.outputIntensityCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.outputIntensity = e.getStateChange() == 1;
            }
        });
        this.grSquarePixelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.grSquarePixel = e.getStateChange() == 1;
                MultilookOpUI.this.independentLooksCheckBox.setSelected(MultilookOpUI.this.grSquarePixel == false);
                if (MultilookOpUI.this.grSquarePixel.booleanValue()) {
                    MultilookOpUI.this.nAzLooks.setText("");
                    MultilookOpUI.this.nAzLooks.setEditable(false);
                }
                MultilookOpUI.this.setAzimuthLooks();
                MultilookOpUI.this.setRangeLooks();
            }
        });
        this.independentLooksCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultilookOpUI.this.grSquarePixel = e.getStateChange() != 1;
                MultilookOpUI.this.grSquarePixelCheckBox.setSelected(MultilookOpUI.this.grSquarePixel);
                if (!MultilookOpUI.this.grSquarePixel.booleanValue()) {
                    MultilookOpUI.this.nAzLooks.setEditable(true);
                }
                MultilookOpUI.this.setAzimuthLooks();
                MultilookOpUI.this.setRangeLooks();
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        boolean isComplex;
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.nRgLooks.setText(String.valueOf(this.paramMap.get("nRgLooks")));
        this.nAzLooks.setText(String.valueOf(this.paramMap.get("nAzLooks")));
        this.outputIntensity = (Boolean)this.paramMap.get("outputIntensity");
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && !(isComplex = this.isComplexSrcProduct())) {
            this.outputIntensity = true;
        }
        if (this.outputIntensity != null) {
            this.outputIntensityCheckBox.setSelected(this.outputIntensity);
        }
        this.grSquarePixel = (Boolean)this.paramMap.get("grSquarePixel");
        if (this.grSquarePixel != null) {
            this.grSquarePixelCheckBox.setSelected(this.grSquarePixel);
            this.independentLooksCheckBox.setSelected(this.grSquarePixel == false);
            if (this.grSquarePixel.booleanValue()) {
                this.nAzLooks.setText("");
                this.nAzLooks.setEditable(false);
            } else {
                this.nAzLooks.setEditable(true);
            }
        }
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            this.setAzimuthLooks();
            this.setRangeLooks();
        }
    }

    private synchronized void setAzimuthLooks() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                if (this.grSquarePixelCheckBox.isSelected()) {
                    this.param.nRgLooks = Integer.parseInt(this.nRgLooks.getText());
                    MultilookOp.getDerivedParameters((Product)this.sourceProducts[0], (MultilookOp.DerivedParams)this.param);
                    this.nAzLooks.setText(String.valueOf(this.param.nAzLooks));
                    float meanSqaurePixel = this.param.meanGRSqaurePixel;
                    this.meanGRSqaurePixel.setText(String.valueOf(meanSqaurePixel));
                } else {
                    this.meanGRSqaurePixel.setText("");
                }
            }
            catch (Exception e) {
                this.meanGRSqaurePixel.setText("");
            }
        }
    }

    private void setRangeLooks() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && this.grSquarePixelCheckBox.isSelected()) {
            this.nRgLooks.setText(String.valueOf(this.param.nRgLooks));
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        String nRgLooksStr = this.nRgLooks.getText();
        String nAzLooksStr = this.nAzLooks.getText();
        if (nRgLooksStr != null && !nRgLooksStr.isEmpty()) {
            this.paramMap.put("nRgLooks", Integer.parseInt(nRgLooksStr));
        }
        if (nAzLooksStr != null && !nAzLooksStr.isEmpty()) {
            this.paramMap.put("nAzLooks", Integer.parseInt(nAzLooksStr));
        }
        this.paramMap.put("outputIntensity", this.outputIntensity);
        this.paramMap.put("grSquarePixel", this.grSquarePixel);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.grSquarePixelCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.independentLooksCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of Range Looks:", (JComponent)this.nRgLooks);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of Azimuth Looks:", (JComponent)this.nAzLooks);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Mean GR Square Pixel:", (JComponent)this.meanGRSqaurePixel);
        this.nAzLooks.setEditable(false);
        this.meanGRSqaurePixel.setEditable(false);
        this.nRgLooks.setDocument(new RgLooksDocument());
        ++gbc.gridy;
        contentPane.add((Component)this.outputIntensityCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"", (JComponent)new JTextArea("Note: Detection for complex data\nis done without resampling."));
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private boolean isComplexSrcProduct() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            String sampleType;
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
            return absRoot != null && (sampleType = absRoot.getAttributeString("SAMPLE_TYPE", "-").trim()).equalsIgnoreCase("complex");
        }
        return false;
    }

    private class RgLooksDocument
    extends PlainDocument {
        private RgLooksDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            MultilookOpUI.this.setAzimuthLooks();
        }
    }
}

