/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.support;

import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import org.esa.snap.core.datamodel.TiePointGrid;

public class TiePointInterpolator {
    private final TiePointGrid tpg;
    private final float[] tiePoints;
    private final int rasterWidth;
    private double[][] quadraticInterpCoeffs = null;
    private double[] biquadraticInterpCoeffs = null;

    public TiePointInterpolator(TiePointGrid tpg) {
        this.tpg = tpg;
        this.tiePoints = tpg.getTiePoints();
        this.rasterWidth = tpg.getRasterWidth();
    }

    private synchronized void computeQuadraticInterpCoeffs() {
        if (this.quadraticInterpCoeffs != null) {
            return;
        }
        int numCoeff = 3;
        int width = this.tpg.getGridWidth();
        int height = this.tpg.getGridHeight();
        double[][] sampleIndexArray = new double[width][3];
        for (int c = 0; c < width; ++c) {
            int x = (int)(this.tpg.getOffsetX() + (double)c * this.tpg.getSubSamplingX());
            sampleIndexArray[c][0] = 1.0;
            sampleIndexArray[c][1] = x;
            sampleIndexArray[c][2] = x * x;
        }
        Matrix A = new Matrix(sampleIndexArray);
        this.quadraticInterpCoeffs = new double[height][3];
        double[] tiePointArray = new double[width];
        for (int r = 0; r < height; ++r) {
            int rwidth = r * width;
            for (int c = 0; c < width; ++c) {
                tiePointArray[c] = this.tiePoints[rwidth + c];
            }
            Matrix b = new Matrix(tiePointArray, width);
            Matrix x = A.solve(b);
            this.quadraticInterpCoeffs[r] = x.getColumnPackedCopy();
        }
    }

    private synchronized void computeBiquadraticInterpCoeffs() {
        if (this.biquadraticInterpCoeffs != null) {
            return;
        }
        int numCoeff = 6;
        int w = this.tpg.getGridWidth();
        int h = this.tpg.getGridHeight();
        int n = w * h;
        double[][] sampleIndexArray = new double[n][6];
        for (int i = 0; i < h; ++i) {
            int y = (int)((double)i * this.tpg.getSubSamplingY());
            double yy = y * y;
            int iw = i * w;
            for (int j = 0; j < w; ++j) {
                int k = iw + j;
                int x = (int)((double)j * this.tpg.getSubSamplingX());
                sampleIndexArray[k][0] = 1.0;
                sampleIndexArray[k][1] = x;
                sampleIndexArray[k][2] = y;
                sampleIndexArray[k][3] = x * x;
                sampleIndexArray[k][4] = y * x;
                sampleIndexArray[k][5] = yy;
            }
        }
        Matrix A = new Matrix(sampleIndexArray);
        float[] tiePoints = this.tpg.getTiePoints();
        double[] tiePointArray = new double[n];
        System.arraycopy(tiePoints, 0, tiePointArray, 0, n);
        Matrix b = new Matrix(tiePointArray, n);
        Matrix x = A.solve(b);
        this.biquadraticInterpCoeffs = x.getColumnPackedCopy();
    }

    public double getPixelDouble(double x, double y, InterpMode interpMethod) {
        if (interpMethod == InterpMode.BILINEAR) {
            return this.tpg.getPixelDouble(x, y);
        }
        if (interpMethod == InterpMode.QUADRATIC) {
            int r;
            if (this.quadraticInterpCoeffs == null) {
                this.computeQuadraticInterpCoeffs();
            }
            if ((r = (int)((y - this.tpg.getOffsetY()) / this.tpg.getSubSamplingY())) >= this.quadraticInterpCoeffs.length) {
                r = this.quadraticInterpCoeffs.length - 1;
            }
            return this.quadraticInterpCoeffs[r][0] + this.quadraticInterpCoeffs[r][1] * x + this.quadraticInterpCoeffs[r][2] * x * x;
        }
        if (interpMethod == InterpMode.BIQUADRATIC) {
            if (this.biquadraticInterpCoeffs == null) {
                this.computeBiquadraticInterpCoeffs();
            }
            return this.biquadraticInterpCoeffs[0] + this.biquadraticInterpCoeffs[1] * x + this.biquadraticInterpCoeffs[2] * y + this.biquadraticInterpCoeffs[3] * x * x + this.biquadraticInterpCoeffs[4] * x * y + this.biquadraticInterpCoeffs[5] * y * y;
        }
        throw new IllegalArgumentException("unsupported interpolation method");
    }

    public double[] getPixels(int x0, int y0, int w, int h, double[] pixels, ProgressMonitor pm, InterpMode interpMethod) {
        pixels = TiePointInterpolator.ensureMinLengthArray(pixels, w * h);
        if (interpMethod == InterpMode.BILINEAR) {
            return this.tpg.getPixels(x0, y0, w, h, pixels, pm);
        }
        if (interpMethod == InterpMode.QUADRATIC || interpMethod == InterpMode.BIQUADRATIC) {
            int k = 0;
            int maxY = y0 + h;
            int maxX = x0 + w;
            for (int y = y0; y < maxY; ++y) {
                for (int x = x0; x < maxX; ++x) {
                    pixels[k++] = this.getPixelDouble(x, y, interpMethod);
                }
            }
            return pixels;
        }
        throw new IllegalArgumentException("unsupported interpolation method");
    }

    protected static double[] ensureMinLengthArray(double[] array, int length) {
        if (array == null) {
            return new double[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    public static enum InterpMode {
        BILINEAR,
        QUADRATIC,
        BIQUADRATIC;

    }
}

