/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.support;

import org.esa.s1tbx.calibration.gpf.calibrators.ALOSCalibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.ASARCalibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.CosmoSkymedCalibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.ERSCalibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.Kompsat5Calibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.RCMCalibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.Radarsat2Calibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.Risat1Calibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.calibration.gpf.calibrators.TerraSARXCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class CalibrationFactory {
    public static Calibrator createCalibrator(Product sourceProduct) throws OperatorException, IllegalArgumentException {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
        if (absRoot == null) {
            throw new OperatorException("AbstractMetadata is null");
        }
        String mission = absRoot.getAttributeString("MISSION");
        if (mission.equals("ENVISAT")) {
            return new ASARCalibrator();
        }
        if (mission.contains("ERS1") || mission.contains("ERS2")) {
            return new ERSCalibrator();
        }
        if (mission.equals("ALOS") || mission.equals("ALOS2")) {
            return new ALOSCalibrator();
        }
        if (mission.equals("RCM")) {
            return new RCMCalibrator();
        }
        if (mission.equals("RS2")) {
            return new Radarsat2Calibrator();
        }
        if (mission.contains("TSX") || mission.contains("TDX")) {
            return new TerraSARXCalibrator();
        }
        if (mission.contains("CSK")) {
            return new CosmoSkymedCalibrator();
        }
        if (mission.contains("SENTINEL-1")) {
            return new Sentinel1Calibrator();
        }
        if (mission.contains("Kompsat5")) {
            return new Kompsat5Calibrator();
        }
        if (mission.contains("RISAT1")) {
            return new Risat1Calibrator();
        }
        throw new OperatorException("Mission " + mission + " is currently not supported for calibration.");
    }

    public static void createSigmaNoughtVirtualBand(Product targetProduct, String incidenceAngleForSigma0) {
        Band[] bands;
        if (incidenceAngleForSigma0.contains("Use projected local incidence angle from DEM")) {
            return;
        }
        for (Band trgBand : bands = targetProduct.getBands()) {
            String trgBandName = trgBand.getName();
            if (trgBand instanceof VirtualBand || !trgBandName.contains("Sigma0")) continue;
            String expression = null;
            String sigmaNoughtVirtualBandName = null;
            String description = null;
            if (incidenceAngleForSigma0.contains("Use incidence angle from Ellipsoid")) {
                expression = trgBandName + "==" + trgBand.getNoDataValue() + '?' + trgBand.getNoDataValue() + ':' + trgBandName + " / sin(projectedLocalIncidenceAngle * PI/180.0) * sin(incidenceAngleFromEllipsoid * PI/180)";
                sigmaNoughtVirtualBandName = trgBandName + "_use_inci_angle_from_ellipsoid";
                description = "Sigma0 image created using incidence angle from ellipsoid";
            } else if (incidenceAngleForSigma0.contains("Use local incidence angle from DEM")) {
                expression = trgBandName + "==" + trgBand.getNoDataValue() + '?' + trgBand.getNoDataValue() + ':' + trgBandName + " / sin(projectedLocalIncidenceAngle * PI/180.0) * sin(localIncidenceAngle * PI/180)";
                sigmaNoughtVirtualBandName = trgBandName + "_use_local_inci_angle_from_dem";
                description = "Sigma0 image created using local incidence angle from DEM";
            }
            VirtualBand band = new VirtualBand(sigmaNoughtVirtualBandName, 30, trgBand.getRasterWidth(), trgBand.getRasterHeight(), expression);
            band.setUnit(trgBand.getUnit());
            band.setDescription(description);
            band.setNoDataValueUsed(true);
            targetProduct.addBand((Band)band);
        }
    }

    public static void createGammaNoughtVirtualBand(Product targetProduct, String incidenceAngleForGamma0) {
        Band[] bands;
        for (Band trgBand : bands = targetProduct.getBands()) {
            String description;
            String gammaNoughtVirtualBandName;
            String trgBandName = trgBand.getName();
            if (trgBand instanceof VirtualBand || !trgBandName.contains("Sigma0")) continue;
            String incidenceAngle = incidenceAngleForGamma0.contains("Use incidence angle from Ellipsoid") ? "incidenceAngleFromEllipsoid" : (incidenceAngleForGamma0.contains("Use local incidence angle from DEM") ? "localIncidenceAngle" : "projectedLocalIncidenceAngle");
            String expression = trgBandName + "==" + trgBand.getNoDataValue() + '?' + trgBand.getNoDataValue() + ':' + trgBandName + " / sin(projectedLocalIncidenceAngle * PI/180.0) * sin(" + incidenceAngle + " * PI/180) / cos(" + incidenceAngle + " * PI/180)";
            if (incidenceAngleForGamma0.contains("Use incidence angle from Ellipsoid")) {
                gammaNoughtVirtualBandName = "_use_inci_angle_from_ellipsoid";
                description = "Gamma0 image created using incidence angle from ellipsoid";
            } else if (incidenceAngleForGamma0.contains("Use local incidence angle from DEM")) {
                gammaNoughtVirtualBandName = "_use_local_inci_angle_from_dem";
                description = "Gamma0 image created using local incidence angle from DEM";
            } else {
                gammaNoughtVirtualBandName = "_use_projected_local_inci_angle_from_dem";
                description = "Gamma0 image created using projected local incidence angle from dem";
            }
            gammaNoughtVirtualBandName = trgBandName.contains("_HH") ? "Gamma0_HH" + gammaNoughtVirtualBandName : (trgBandName.contains("_VV") ? "Gamma0_VV" + gammaNoughtVirtualBandName : (trgBandName.contains("_HV") ? "Gamma0_HV" + gammaNoughtVirtualBandName : (trgBandName.contains("_VH") ? "Gamma0_VH" + gammaNoughtVirtualBandName : "Gamma0" + gammaNoughtVirtualBandName)));
            VirtualBand band = new VirtualBand(gammaNoughtVirtualBandName, 30, trgBand.getRasterWidth(), trgBand.getRasterHeight(), expression);
            band.setUnit(trgBand.getUnit());
            band.setDescription(description);
            band.setNoDataValueUsed(true);
            targetProduct.addBand((Band)band);
        }
    }

    public static void createBetaNoughtVirtualBand(Product targetProduct) {
        Band[] bands;
        for (Band trgBand : bands = targetProduct.getBands()) {
            String trgBandName = trgBand.getName();
            if (trgBand instanceof VirtualBand || !trgBandName.contains("Sigma0")) continue;
            String expression = trgBandName + "==" + trgBand.getNoDataValue() + '?' + trgBand.getNoDataValue() + ':' + trgBandName + " / sin(projectedLocalIncidenceAngle * PI/180.0)";
            String betaNoughtVirtualBandName = trgBandName.replace("Sigma0", "Beta0");
            VirtualBand band = new VirtualBand(betaNoughtVirtualBandName, 30, trgBand.getRasterWidth(), trgBand.getRasterHeight(), expression);
            band.setUnit(trgBand.getUnit());
            band.setDescription("Beta0 image");
            band.setNoDataValueUsed(true);
            targetProduct.addBand((Band)band);
        }
    }
}

