/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.sentinel1;

import Jama.Matrix;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.s1tbx.io.orbits.OrbitFile;
import org.esa.s1tbx.io.orbits.sentinel1.QCScraper;
import org.esa.s1tbx.io.orbits.sentinel1.SSLUtil;
import org.esa.s1tbx.io.orbits.sentinel1.StepAuxdataScraper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.download.DownloadableArchive;
import org.esa.snap.engine_utilities.download.DownloadableContentImpl;
import org.esa.snap.engine_utilities.util.Maths;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.engine_utilities.util.ZipUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SentinelPODOrbitFile
extends BaseOrbitFile
implements OrbitFile {
    public static final String RESTITUTED = "Sentinel Restituted";
    public static final String PRECISE = "Sentinel Precise";
    private final int polyDegree;
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyyMMdd-HHmmss");
    private static final DateFormat orbitDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private FixedHeader fixedHeader = null;
    private List<Orbits.OrbitVector> osvList = new ArrayList<Orbits.OrbitVector>();
    private static LoadingCache<File, List<Orbits.OrbitVector>> cache;

    public SentinelPODOrbitFile(MetadataElement absRoot, int polyDegree) throws Exception {
        super(absRoot);
        this.polyDegree = polyDegree;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{PRECISE, RESTITUTED};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        double stateVectorTime = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getMJD();
        Calendar calendar = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getAsCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String missionPrefix = SentinelPODOrbitFile.getMissionPrefix(this.absRoot);
        this.orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, year, month);
        if (this.orbitFile == null) {
            this.orbitFile = SentinelPODOrbitFile.downloadFromQCRestAPI(missionPrefix, orbitType, year, month, day, hour, minute, second, stateVectorTime);
        }
        if (this.orbitFile == null) {
            this.orbitFile = SentinelPODOrbitFile.downloadFromStepAuxdata(missionPrefix, orbitType, year, month, day, stateVectorTime);
        }
        if (this.orbitFile == null) {
            String timeStr = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").format();
            File destFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
            throw new IOException("No valid orbit file found for " + timeStr + "\nOrbit files may be downloaded from https://qc.sentinel1.eo.esa.int/\nand placed in " + destFolder.getAbsolutePath());
        }
        if (!this.orbitFile.exists()) {
            throw new IOException("SentinelPODOrbitFile: Unable to find POD orbit file");
        }
        this.readOrbitFile();
        return this.orbitFile;
    }

    private static String getMissionPrefix(MetadataElement absRoot) {
        String mission = absRoot.getAttributeString("MISSION");
        return "S1" + mission.substring(mission.length() - 1);
    }

    private static File downloadArchive(String missionPrefix, String orbitType, int year, int month, int day, double stateVectorTime) throws Exception {
        SentinelPODOrbitFile.getRemoteFiles(missionPrefix, orbitType, year, month);
        File orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, year, month);
        if (orbitFile == null) {
            NewDate newDate = SentinelPODOrbitFile.getNeighouringMonth(year, month, day);
            SentinelPODOrbitFile.getRemoteFiles(missionPrefix, orbitType, newDate.year, newDate.month);
            orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, newDate.year, newDate.month);
        }
        return orbitFile;
    }

    private static File downloadFromQCRestAPI(String missionPrefix, String orbitType, int year, int month, int day, int hour, int minute, int second, double stateVectorTime) throws Exception {
        String orbProductType = orbitType.equals(RESTITUTED) ? "AUX_RESORB" : "AUX_POEORB";
        String date = year + "-" + month + "-" + day;
        String endPoint = "https://qc.sentinel1.eo.esa.int/api/v1/?product_type=" + orbProductType;
        endPoint = endPoint + "&validity_stop__gt=" + date + "T23:59:59";
        endPoint = endPoint + "&validity_start__lt=" + date + "T" + hour + ":" + minute + ":" + second;
        endPoint = endPoint + "&ordering=-creation_date&page_size=1";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(endPoint);
            StringBuilder outputBuilder = new StringBuilder();
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                JSONObject result;
                JSONArray results;
                JSONParser parser;
                JSONObject json;
                int status = response.getStatusLine().getStatusCode();
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                    String line;
                    while ((line = rd.readLine()) != null) {
                        outputBuilder.append(line);
                    }
                }
                response.close();
                if (status == 200 && (json = (JSONObject)(parser = new JSONParser()).parse(outputBuilder.toString())).containsKey((Object)"results") && !(results = (JSONArray)json.get((Object)"results")).isEmpty() && (result = (JSONObject)results.get(0)).containsKey((Object)"remote_url")) {
                    String remoteURL = (String)result.get((Object)"remote_url");
                    SentinelPODOrbitFile.getQCFile(missionPrefix, orbitType, year, month, remoteURL);
                }
            }
            catch (IOException e) {
                System.out.println("Exception calling QC Rest API:  " + e.getMessage());
                throw e;
            }
        }
        File orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, year, month);
        return orbitFile;
    }

    private static File downloadFromStepAuxdata(String missionPrefix, String orbitType, int year, int month, int day, double stateVectorTime) throws Exception {
        SentinelPODOrbitFile.getStepAuxdataFiles(missionPrefix, orbitType, year, month, stateVectorTime);
        File orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, year, month);
        if (orbitFile == null) {
            NewDate newDate = SentinelPODOrbitFile.getNeighouringMonth(year, month, day);
            SentinelPODOrbitFile.getStepAuxdataFiles(missionPrefix, orbitType, newDate.year, newDate.month, stateVectorTime);
            orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, newDate.year, newDate.month);
        }
        return orbitFile;
    }

    private static File downloadFromQCWebsite(String missionPrefix, String orbitType, int year, int month, int day, double stateVectorTime) throws Exception {
        SentinelPODOrbitFile.getQCFiles(missionPrefix, orbitType, year, month, stateVectorTime);
        File orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, year, month);
        if (orbitFile == null) {
            NewDate newDate = SentinelPODOrbitFile.getNeighouringMonth(year, month, day);
            SentinelPODOrbitFile.getQCFiles(missionPrefix, orbitType, newDate.year, newDate.month, stateVectorTime);
            orbitFile = SentinelPODOrbitFile.findOrbitFile(missionPrefix, orbitType, stateVectorTime, newDate.year, newDate.month);
        }
        return orbitFile;
    }

    private static NewDate getNeighouringMonth(int year, int month, int day) {
        if (day < 15) {
            if (--month < 1) {
                month = 12;
                --year;
            }
        } else if (++month > 12) {
            month = 1;
            ++year;
        }
        return new NewDate(year, month);
    }

    static File getDestFolder(String missionPrefix, String orbitType, int year, int month) {
        File oldFolder;
        String prefOrbitPath = orbitType.startsWith(RESTITUTED) ? Settings.getPath((String)"OrbitFiles.sentinel1RESOrbitPath") : Settings.getPath((String)"OrbitFiles.sentinel1POEOrbitPath");
        File destFolder = new File(prefOrbitPath + File.separator + missionPrefix + File.separator + year + File.separator + StringUtils.padNum((int)month, (int)2, (char)'0'));
        if (month < 10 && (oldFolder = new File(prefOrbitPath + File.separator + missionPrefix + File.separator + year + File.separator + month)).exists()) {
            oldFolder.renameTo(destFolder);
        }
        destFolder.mkdirs();
        return destFolder;
    }

    private static File findOrbitFile(String missionPrefix, String orbitType, double stateVectorTime, int year, int month) {
        String prefix = orbitType.startsWith(RESTITUTED) ? missionPrefix + "_OPER_AUX_RESORB_OPOD_" : missionPrefix + "_OPER_AUX_POEORB_OPOD_";
        File orbitFileFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
        if (!orbitFileFolder.exists()) {
            return null;
        }
        File[] files = orbitFileFolder.listFiles(new S1OrbitFileFilter(prefix));
        if (files == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            if (!SentinelPODOrbitFile.isWithinRange(file.getName(), stateVectorTime)) continue;
            return file;
        }
        return null;
    }

    private static void getRemoteFiles(String missionPrefix, String orbitType, int year, int month) throws Exception {
        block2: {
            URL remotePath = orbitType.startsWith(RESTITUTED) ? new URL(Settings.getPath((String)"OrbitFiles.sentinel1RESOrbit_remotePath")) : new URL(Settings.getPath((String)"OrbitFiles.sentinel1POEOrbit_remotePath"));
            File orbitFileFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
            File localFile = new File(orbitFileFolder, year + "-" + month + ".zip");
            try {
                DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                archive.getContentFiles();
            }
            catch (Exception e) {
                if (!localFile.exists()) break block2;
                localFile.delete();
                DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                archive.getContentFiles();
            }
        }
    }

    private static void getStepAuxdataFiles(String missionPrefix, String orbitType, int year, int month, double stateVectorTime) throws Exception {
        File localFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
        StepAuxdataScraper step = new StepAuxdataScraper(orbitType);
        String[] orbitFiles = step.getFileURLs(missionPrefix, year, month);
        URL remotePath = new URL(step.getRemoteURL());
        SSLUtil ssl = new SSLUtil();
        ssl.disableSSLCertificateCheck();
        for (String file : orbitFiles) {
            if (!SentinelPODOrbitFile.isWithinRange(file, stateVectorTime)) continue;
            File localFile = new File(localFolder, file);
            DownloadableContentImpl.getRemoteHttpFile((URL)remotePath, (File)localFile);
            break;
        }
        ssl.enableSSLCertificateCheck();
    }

    private static void getQCFile(String missionPrefix, String orbitType, int year, int month, String remoteURL) throws Exception {
        File localFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
        int lastSlash = remoteURL.lastIndexOf("/") + 1;
        String remoteFolder = remoteURL.substring(0, lastSlash);
        String name = remoteURL.substring(lastSlash);
        URL remotePath = new URL(remoteFolder);
        SSLUtil ssl = new SSLUtil();
        ssl.disableSSLCertificateCheck();
        File localFile = new File(localFolder, name);
        DownloadableContentImpl.getRemoteHttpFile((URL)remotePath, (File)localFile);
        ssl.enableSSLCertificateCheck();
        if (localFile.exists()) {
            File localZipFile = FileUtils.exchangeExtension((File)localFile, (String)".EOF.zip");
            ZipUtils.zipFile((File)localFile, (File)localZipFile);
            localFile.delete();
        }
    }

    private static void getQCFiles(String missionPrefix, String orbitType, int year, int month, double stateVectorTime) throws Exception {
        File localFolder = SentinelPODOrbitFile.getDestFolder(missionPrefix, orbitType, year, month);
        QCScraper qc = new QCScraper(orbitType);
        String[] orbitFiles = qc.getFileURLs(missionPrefix, year, month);
        URL remotePath = new URL(qc.getRemoteURL());
        SSLUtil ssl = new SSLUtil();
        ssl.disableSSLCertificateCheck();
        for (String file : orbitFiles) {
            if (!SentinelPODOrbitFile.isWithinRange(file, stateVectorTime)) continue;
            File localFile = new File(localFolder, file);
            DownloadableContentImpl.getRemoteHttpFile((URL)remotePath, (File)localFile);
            if (!localFile.exists()) continue;
            File localZipFile = FileUtils.exchangeExtension((File)localFile, (String)".EOF.zip");
            ZipUtils.zipFile((File)localFile, (File)localZipFile);
            localFile.delete();
        }
        ssl.enableSSLCertificateCheck();
    }

    private void checkOrbitFileValidity() throws Exception {
        double stateVectorTime = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getMJD();
        String validityStartTimeStr = this.getValidityStartFromHeader();
        String validityStopTimeStr = this.getValidityStopFromHeader();
        double validityStartTimeMJD = SentinelPODOrbitFile.toUTC(validityStartTimeStr).getMJD();
        double validityStopTimeMJD = SentinelPODOrbitFile.toUTC(validityStopTimeStr).getMJD();
        if (stateVectorTime < validityStartTimeMJD || stateVectorTime > validityStopTimeMJD) {
            throw new IOException("Product acquisition time is not within the validity period of the orbit");
        }
    }

    public Orbits.OrbitVector[] getOrbitData(double startUTC, double endUTC) {
        Orbits.OrbitVector endOSV;
        int endIdx;
        Orbits.OrbitVector startOSV = new Orbits.OrbitVector(startUTC);
        int startIdx = Collections.binarySearch(this.osvList, startOSV, new Orbits.OrbitComparator());
        if (startIdx < 0) {
            int insertionPt = -(startIdx + 1);
            startIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt <= 0 ? 0 : insertionPt - 1);
        }
        if ((endIdx = Collections.binarySearch(this.osvList, endOSV = new Orbits.OrbitVector(endUTC), new Orbits.OrbitComparator())) < 0) {
            int insertionPt = -(endIdx + 1);
            endIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt == 0 ? 0 : insertionPt);
        }
        int numOSV = (endIdx += 3) - (startIdx -= 3) + 1;
        Orbits.OrbitVector[] orbitDataList = new Orbits.OrbitVector[numOSV];
        int idx = startIdx;
        for (int i = 0; i < numOSV; ++i) {
            orbitDataList[i] = this.osvList.get(idx);
            ++idx;
        }
        return orbitDataList;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) {
        int i;
        int numVectors = this.osvList.size();
        double t0 = this.osvList.get((int)0).utcMJD;
        double tN = this.osvList.get((int)(numVectors - 1)).utcMJD;
        int numVecPolyFit = this.polyDegree + 1;
        int halfNumVecPolyFit = numVecPolyFit / 2;
        int[] vectorIndices = new int[numVecPolyFit];
        int vecIdx = (int)((utc - t0) / (tN - t0) * (double)(numVectors - 1));
        if (vecIdx <= halfNumVecPolyFit - 1) {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = i;
            }
        } else if (vecIdx >= numVectors - halfNumVecPolyFit) {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = numVectors - numVecPolyFit + i;
            }
        } else {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = vecIdx - halfNumVecPolyFit + 1 + i;
            }
        }
        double[] timeArray = new double[numVecPolyFit];
        double[] xPosArray = new double[numVecPolyFit];
        double[] yPosArray = new double[numVecPolyFit];
        double[] zPosArray = new double[numVecPolyFit];
        double[] xVelArray = new double[numVecPolyFit];
        double[] yVelArray = new double[numVecPolyFit];
        double[] zVelArray = new double[numVecPolyFit];
        for (int i2 = 0; i2 < numVecPolyFit; ++i2) {
            timeArray[i2] = this.osvList.get((int)vectorIndices[i2]).utcMJD - t0;
            xPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).xPos;
            yPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).yPos;
            zPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).zPos;
            xVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).xVel;
            yVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).yVel;
            zVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).zVel;
        }
        Matrix A = Maths.createVandermondeMatrix((double[])timeArray, (int)this.polyDegree);
        double[] xPosCoeff = Maths.polyFit((Matrix)A, (double[])xPosArray);
        double[] yPosCoeff = Maths.polyFit((Matrix)A, (double[])yPosArray);
        double[] zPosCoeff = Maths.polyFit((Matrix)A, (double[])zPosArray);
        double[] xVelCoeff = Maths.polyFit((Matrix)A, (double[])xVelArray);
        double[] yVelCoeff = Maths.polyFit((Matrix)A, (double[])yVelArray);
        double[] zVelCoeff = Maths.polyFit((Matrix)A, (double[])zVelArray);
        double normalizedTime = utc - t0;
        return new Orbits.OrbitVector(utc, Maths.polyVal((double)normalizedTime, (double[])xPosCoeff), Maths.polyVal((double)normalizedTime, (double[])yPosCoeff), Maths.polyVal((double)normalizedTime, (double[])zPosCoeff), Maths.polyVal((double)normalizedTime, (double[])xVelCoeff), Maths.polyVal((double)normalizedTime, (double[])yVelCoeff), Maths.polyVal((double)normalizedTime, (double[])zVelCoeff));
    }

    private void readOrbitFile() throws Exception {
        Document doc;
        List cachedOSVList = (List)this.getCache().get((Object)this.orbitFile);
        if (cachedOSVList != null && !cachedOSVList.isEmpty()) {
            this.osvList = cachedOSVList;
            return;
        }
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        if (this.orbitFile.getName().toLowerCase().endsWith(".zip")) {
            ZipFile productZip = new ZipFile(this.orbitFile, 1);
            Enumeration<? extends ZipEntry> entries = productZip.entries();
            ZipEntry zipEntry = entries.nextElement();
            doc = documentBuilder.parse(productZip.getInputStream(zipEntry));
        } else {
            doc = documentBuilder.parse(this.orbitFile);
        }
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("Earth_Explorer_File");
        if (nodeList.getLength() != 1) {
            throw new Exception("SentinelPODOrbitFile.readOrbitFile: ERROR found too many Earth_Explorer_File " + nodeList.getLength());
        }
        Node fixedHeaderNode = null;
        Node variableHeaderNode = null;
        Node listOfOSVsNode = null;
        NodeList fileChildNodes = nodeList.item(0).getChildNodes();
        for (int i = 0; i < fileChildNodes.getLength(); ++i) {
            int j;
            Node fileChildNode = fileChildNodes.item(i);
            if (fileChildNode.getNodeName().equals("Earth_Explorer_Header")) {
                NodeList headerChildNodes = fileChildNode.getChildNodes();
                for (j = 0; j < headerChildNodes.getLength(); ++j) {
                    Node headerChildNode = headerChildNodes.item(j);
                    if (headerChildNode.getNodeName().equals("Fixed_Header")) {
                        fixedHeaderNode = headerChildNode;
                        continue;
                    }
                    if (!headerChildNode.getNodeName().equals("Variable_Header")) continue;
                    variableHeaderNode = headerChildNode;
                }
            } else if (fileChildNode.getNodeName().equals("Data_Block")) {
                NodeList dataBlockChildNodes = fileChildNode.getChildNodes();
                for (j = 0; j < dataBlockChildNodes.getLength(); ++j) {
                    Node dataBlockChildNode = dataBlockChildNodes.item(j);
                    if (!dataBlockChildNode.getNodeName().equals("List_of_OSVs")) continue;
                    listOfOSVsNode = dataBlockChildNode;
                }
            }
            if (fixedHeaderNode != null && variableHeaderNode != null && listOfOSVsNode != null) break;
        }
        if (fixedHeaderNode != null) {
            this.readFixedHeader(fixedHeaderNode);
        }
        if (listOfOSVsNode != null) {
            this.osvList = SentinelPODOrbitFile.readOSVList(listOfOSVsNode);
        }
        this.checkOrbitFileValidity();
        this.getCache().put((Object)this.orbitFile, this.osvList);
    }

    private void readFixedHeader(Node fixedHeaderNode) {
        NodeList fixedHeaderChildNodes = fixedHeaderNode.getChildNodes();
        String mission = null;
        String fileType = null;
        String validityStart = null;
        String validityStop = null;
        for (int i = 0; i < fixedHeaderChildNodes.getLength(); ++i) {
            Node fixedHeaderChildNode = fixedHeaderChildNodes.item(i);
            switch (fixedHeaderChildNode.getNodeName()) {
                case "Mission": {
                    mission = fixedHeaderChildNode.getTextContent();
                    break;
                }
                case "File_Type": {
                    fileType = fixedHeaderChildNode.getTextContent();
                    break;
                }
                case "Validity_Period": {
                    NodeList validityPeriodChildNodes = fixedHeaderChildNode.getChildNodes();
                    for (int j = 0; j < validityPeriodChildNodes.getLength(); ++j) {
                        Node validityPeriodChildNode = validityPeriodChildNodes.item(j);
                        if (validityPeriodChildNode.getNodeName().equals("Validity_Start")) {
                            validityStart = validityPeriodChildNode.getTextContent();
                            continue;
                        }
                        if (!validityPeriodChildNode.getNodeName().equals("Validity_Stop")) continue;
                        validityStop = validityPeriodChildNode.getTextContent();
                    }
                    break;
                }
            }
            if (mission == null || fileType == null || validityStart == null || validityStop == null) continue;
            this.fixedHeader = new FixedHeader(mission, fileType, validityStart, validityStop);
            break;
        }
    }

    private static List<Orbits.OrbitVector> readOSVList(Node listOfOSVsNode) throws Exception {
        Node attrCount = SentinelPODOrbitFile.getAttributeFromNode(listOfOSVsNode, "count");
        int count = Integer.parseInt(attrCount.getTextContent());
        ArrayList<Orbits.OrbitVector> osvList = new ArrayList<Orbits.OrbitVector>();
        int osvCnt = 0;
        for (Node childNode = listOfOSVsNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!childNode.getNodeName().equals("OSV")) continue;
            ++osvCnt;
            osvList.add(SentinelPODOrbitFile.readOneOSV(childNode));
        }
        osvList.sort((Comparator<Orbits.OrbitVector>)new Orbits.OrbitComparator());
        if (count != osvCnt) {
            SystemUtils.LOG.warning("SentinelPODOrbitFile.readOSVList: WARNING List_of_OSVs count = " + count + " but found only " + osvCnt + " OSV");
        }
        return osvList;
    }

    private static Orbits.OrbitVector readOneOSV(Node osvNode) throws Exception {
        String utc = "";
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        block18: for (Node childNode = osvNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            switch (childNode.getNodeName()) {
                case "UTC": {
                    utc = childNode.getTextContent();
                    continue block18;
                }
                case "X": {
                    x = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "Y": {
                    y = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "Z": {
                    z = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VX": {
                    vx = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VY": {
                    vy = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
                case "VZ": {
                    vz = Double.parseDouble(childNode.getTextContent());
                    continue block18;
                }
            }
        }
        double utcTime = SentinelPODOrbitFile.toUTC(utc).getMJD();
        return new Orbits.OrbitVector(utcTime, x, y, z, vx, vy, vz);
    }

    private static Node getAttributeFromNode(Node node, String attrName) {
        NamedNodeMap attr = node.getAttributes();
        Node attrNode = null;
        for (int j = 0; j < attr.getLength(); ++j) {
            if (!attr.item(j).getNodeName().equals(attrName)) continue;
            if (attrNode == null) {
                attrNode = attr.item(j);
                continue;
            }
            SystemUtils.LOG.warning("SentinelPODOrbitFile.getAttributeFromNode: WARNING more than one " + attrName + " in " + node.getNodeName());
        }
        if (attrNode == null) {
            SystemUtils.LOG.warning("SentinelPODOrbitFile.getAttributeFromNode: Failed to find " + attrName + " in " + node.getNodeName());
        }
        return attrNode;
    }

    private static String convertUTC(String utc) {
        return utc.replace("UTC=", "").replace("T", " ");
    }

    static String getMissionIDFromFilename(String filename) {
        return filename.substring(0, 3);
    }

    static String getFileTypeFromFilename(String filename) {
        return filename.substring(9, 19);
    }

    private static String extractUTCTimeFromFilename(String filename, int offset) {
        String yyyy = filename.substring(offset, offset + 4);
        String mmDate = filename.substring(offset + 4, offset + 6);
        String dd = filename.substring(offset + 6, offset + 8);
        String hh = filename.substring(offset + 9, offset + 11);
        String mmTime = filename.substring(offset + 11, offset + 13);
        String ss = filename.substring(offset + 13, offset + 15);
        return "UTC=" + yyyy + '-' + mmDate + '-' + dd + 'T' + hh + ':' + mmTime + ':' + ss;
    }

    private static String extractTimeFromFilename(String filename, int offset) {
        return filename.substring(offset, offset + 15).replace("T", "-");
    }

    static ProductData.UTC getValidityStartFromFilenameUTC(String filename) throws ParseException {
        if (filename.substring(41, 42).equals("V")) {
            String val = SentinelPODOrbitFile.extractTimeFromFilename(filename, 42);
            return ProductData.UTC.parse((String)val, (DateFormat)dateFormat);
        }
        return null;
    }

    static ProductData.UTC getValidityStopFromFilenameUTC(String filename) throws ParseException {
        if (filename.substring(41, 42).equals("V")) {
            String val = SentinelPODOrbitFile.extractTimeFromFilename(filename, 58);
            return ProductData.UTC.parse((String)val, (DateFormat)dateFormat);
        }
        return null;
    }

    static String getValidityStartFromFilename(String filename) {
        if (filename.substring(41, 42).equals("V")) {
            return SentinelPODOrbitFile.extractUTCTimeFromFilename(filename, 42);
        }
        return null;
    }

    static String getValidityStopFromFilename(String filename) {
        if (filename.substring(41, 42).equals("V")) {
            return SentinelPODOrbitFile.extractUTCTimeFromFilename(filename, 58);
        }
        return null;
    }

    String getMissionFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.mission;
        }
        return null;
    }

    String getFileTypeFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.fileType;
        }
        return null;
    }

    String getValidityStartFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.validityStart;
        }
        return null;
    }

    String getValidityStopFromHeader() {
        if (this.fixedHeader != null) {
            return this.fixedHeader.validityStop;
        }
        return null;
    }

    static ProductData.UTC toUTC(String str) throws ParseException {
        return ProductData.UTC.parse((String)SentinelPODOrbitFile.convertUTC(str), (DateFormat)orbitDateFormat);
    }

    private static boolean isWithinRange(String filename, double stateVectorTime) {
        try {
            ProductData.UTC utcStart = SentinelPODOrbitFile.getValidityStartFromFilenameUTC(filename);
            ProductData.UTC utcEnd = SentinelPODOrbitFile.getValidityStopFromFilenameUTC(filename);
            if (utcStart != null && utcEnd != null) {
                return stateVectorTime >= utcStart.getMJD() && stateVectorTime < utcEnd.getMJD();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private LoadingCache<File, List<Orbits.OrbitVector>> getCache() {
        if (cache == null) {
            cache = SentinelPODOrbitFile.createCache();
        }
        return cache;
    }

    private static LoadingCache<File, List<Orbits.OrbitVector>> createCache() {
        return CacheBuilder.newBuilder().maximumSize(6L).initialCapacity(6).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<File, List<Orbits.OrbitVector>>(){

            public List<Orbits.OrbitVector> load(File key) throws Exception {
                return new ArrayList<Orbits.OrbitVector>();
            }
        });
    }

    private static final class FixedHeader {
        private final String mission;
        private final String fileType;
        private final String validityStart;
        private final String validityStop;

        FixedHeader(String mission, String fileType, String validityStart, String validityStop) {
            this.mission = mission;
            this.fileType = fileType;
            this.validityStart = validityStart;
            this.validityStop = validityStop;
        }
    }

    private static class S1OrbitFileFilter
    implements FilenameFilter {
        private final String prefix;

        S1OrbitFileFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return ((name = name.toUpperCase()).endsWith(".ZIP") || name.endsWith(".EOF")) && name.startsWith(this.prefix);
        }
    }

    private static class NewDate {
        final int month;
        final int year;

        NewDate(int year, int month) {
            this.year = year;
            this.month = month;
        }
    }
}

