/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.k5;

import Jama.Matrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.s1tbx.io.orbits.OrbitFile;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Maths;

public class K5OrbitFile
extends BaseOrbitFile
implements OrbitFile {
    public static final String PRECISE = "Kompsat5 Precise";
    private static final String remoteURL = "ftp://aopod-ftp.kasi.re.kr/kompsat5rt/level1b/leoOrb/";
    private final int polyDegree;
    private final DateFormat orbitDateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private List<Orbits.OrbitVector> osvList;

    public K5OrbitFile(MetadataElement absRoot, int polyDegree) {
        super(absRoot);
        this.polyDegree = polyDegree;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{PRECISE};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        double stateVectorTime = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getMJD();
        Calendar calendar = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").getAsCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.orbitFile = this.findOrbitFile(orbitType, stateVectorTime, year, month);
        if (this.orbitFile == null) {
            String timeStr = this.absRoot.getAttributeUTC("STATE_VECTOR_TIME").format();
            File destFolder = K5OrbitFile.getDestFolder(orbitType, year, month);
            throw new IOException("No valid orbit file found for " + timeStr + "\nOrbit files may be downloaded from " + remoteURL + "\nand placed in " + destFolder.getAbsolutePath());
        }
        this.osvList = this.readOrbitFile(this.orbitFile);
        return this.orbitFile;
    }

    private static File getDestFolder(String orbitType, int year, int month) {
        return SystemUtils.getAuxDataPath().resolve("Orbits").resolve("K5").resolve("POEORB").toFile();
    }

    private File findOrbitFile(String orbitType, double stateVectorTime, int year, int month) throws Exception {
        File[] files;
        String prefix = "LEOORB_" + year;
        File orbitFileFolder = K5OrbitFile.getDestFolder(orbitType, year, month);
        if (!orbitFileFolder.exists()) {
            orbitFileFolder.mkdirs();
        }
        if ((files = orbitFileFolder.listFiles(new K5OrbitFileFilter(prefix))) == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            List<Orbits.OrbitVector> orbitVectors = this.readOrbitFile(file);
            if (!K5OrbitFile.isWithinRange(orbitVectors, stateVectorTime)) continue;
            return file;
        }
        return null;
    }

    private static boolean isWithinRange(List<Orbits.OrbitVector> orbitVectors, double stateVectorTime) {
        return orbitVectors.get((int)0).utcMJD <= stateVectorTime && orbitVectors.get((int)(orbitVectors.size() - 1)).utcMJD > stateVectorTime;
    }

    public Orbits.OrbitVector[] getOrbitData(double startUTC, double endUTC) throws Exception {
        Orbits.OrbitVector endOSV;
        int endIdx;
        Orbits.OrbitVector startOSV = new Orbits.OrbitVector(startUTC);
        int startIdx = Collections.binarySearch(this.osvList, startOSV, new Orbits.OrbitComparator());
        if (startIdx < 0) {
            int insertionPt = -(startIdx + 1);
            startIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt <= 0 ? 0 : insertionPt - 1);
        }
        if ((endIdx = Collections.binarySearch(this.osvList, endOSV = new Orbits.OrbitVector(endUTC), new Orbits.OrbitComparator())) < 0) {
            int insertionPt = -(endIdx + 1);
            endIdx = insertionPt == this.osvList.size() ? insertionPt - 1 : (insertionPt == 0 ? 0 : insertionPt);
        }
        int numOSV = (endIdx += 3) - (startIdx -= 3) + 1;
        Orbits.OrbitVector[] orbitDataList = new Orbits.OrbitVector[numOSV];
        int idx = startIdx;
        for (int i = 0; i < numOSV; ++i) {
            orbitDataList[i] = this.osvList.get(idx);
            ++idx;
        }
        return orbitDataList;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) throws Exception {
        int i;
        int numVectors = this.osvList.size();
        double t0 = this.osvList.get((int)0).utcMJD;
        double tN = this.osvList.get((int)(numVectors - 1)).utcMJD;
        int numVecPolyFit = this.polyDegree + 1;
        int halfNumVecPolyFit = numVecPolyFit / 2;
        int[] vectorIndices = new int[numVecPolyFit];
        int vecIdx = (int)((utc - t0) / (tN - t0) * (double)(numVectors - 1));
        if (vecIdx <= halfNumVecPolyFit - 1) {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = i;
            }
        } else if (vecIdx >= numVectors - halfNumVecPolyFit) {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = numVectors - numVecPolyFit + i;
            }
        } else {
            for (i = 0; i < numVecPolyFit; ++i) {
                vectorIndices[i] = vecIdx - halfNumVecPolyFit + 1 + i;
            }
        }
        double[] timeArray = new double[numVecPolyFit];
        double[] xPosArray = new double[numVecPolyFit];
        double[] yPosArray = new double[numVecPolyFit];
        double[] zPosArray = new double[numVecPolyFit];
        double[] xVelArray = new double[numVecPolyFit];
        double[] yVelArray = new double[numVecPolyFit];
        double[] zVelArray = new double[numVecPolyFit];
        for (int i2 = 0; i2 < numVecPolyFit; ++i2) {
            timeArray[i2] = this.osvList.get((int)vectorIndices[i2]).utcMJD - t0;
            xPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).xPos;
            yPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).yPos;
            zPosArray[i2] = this.osvList.get((int)vectorIndices[i2]).zPos;
            xVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).xVel;
            yVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).yVel;
            zVelArray[i2] = this.osvList.get((int)vectorIndices[i2]).zVel;
        }
        Matrix A = Maths.createVandermondeMatrix((double[])timeArray, (int)this.polyDegree);
        double[] xPosCoeff = Maths.polyFit((Matrix)A, (double[])xPosArray);
        double[] yPosCoeff = Maths.polyFit((Matrix)A, (double[])yPosArray);
        double[] zPosCoeff = Maths.polyFit((Matrix)A, (double[])zPosArray);
        double[] xVelCoeff = Maths.polyFit((Matrix)A, (double[])xVelArray);
        double[] yVelCoeff = Maths.polyFit((Matrix)A, (double[])yVelArray);
        double[] zVelCoeff = Maths.polyFit((Matrix)A, (double[])zVelArray);
        double normalizedTime = utc - t0;
        return new Orbits.OrbitVector(utc, Maths.polyVal((double)normalizedTime, (double[])xPosCoeff), Maths.polyVal((double)normalizedTime, (double[])yPosCoeff), Maths.polyVal((double)normalizedTime, (double[])zPosCoeff), Maths.polyVal((double)normalizedTime, (double[])xVelCoeff), Maths.polyVal((double)normalizedTime, (double[])yVelCoeff), Maths.polyVal((double)normalizedTime, (double[])zVelCoeff));
    }

    private List<Orbits.OrbitVector> readOrbitFile(File file) throws Exception {
        ArrayList<Orbits.OrbitVector> osvList = new ArrayList<Orbits.OrbitVector>();
        try (BufferedReader lineReader = new BufferedReader(new FileReader(file));){
            String line = lineReader.readLine();
            while (line != null) {
                if (line.startsWith("*")) {
                    ProductData.UTC time = this.parseTime(line);
                    Orbits.OrbitVector orbitVector = new Orbits.OrbitVector(time.getMJD());
                    line = lineReader.readLine();
                    K5OrbitFile.parsePosition(line, orbitVector);
                    line = lineReader.readLine();
                    K5OrbitFile.parseVelocity(line, orbitVector);
                    osvList.add(orbitVector);
                }
                line = lineReader.readLine();
            }
        }
        return osvList;
    }

    private ProductData.UTC parseTime(String line) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        int year = Integer.parseInt(tokenizer.nextToken());
        int month = Integer.parseInt(tokenizer.nextToken());
        int day = Integer.parseInt(tokenizer.nextToken());
        int hour = Integer.parseInt(tokenizer.nextToken());
        int minute = Integer.parseInt(tokenizer.nextToken());
        String date = "" + year + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + 0;
        return ProductData.UTC.parse((String)date, (DateFormat)this.orbitDateFormat);
    }

    private static void parsePosition(String line, Orbits.OrbitVector orbitVector) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        orbitVector.xPos = Double.parseDouble(tokenizer.nextToken()) * 1000.0;
        orbitVector.yPos = Double.parseDouble(tokenizer.nextToken()) * 1000.0;
        orbitVector.zPos = Double.parseDouble(tokenizer.nextToken()) * 1000.0;
    }

    private static void parseVelocity(String line, Orbits.OrbitVector orbitVector) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        orbitVector.xVel = Double.parseDouble(tokenizer.nextToken()) / 10.0;
        orbitVector.yVel = Double.parseDouble(tokenizer.nextToken()) / 10.0;
        orbitVector.zVel = Double.parseDouble(tokenizer.nextToken()) / 10.0;
    }

    private static class K5OrbitFileFilter
    implements FilenameFilter {
        private final String prefix;

        public K5OrbitFileFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return ((name = name.toUpperCase()).endsWith(".ZIP") || name.endsWith("SP3")) && name.startsWith(this.prefix);
        }
    }
}

