/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.delft;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.util.Maths;

public final class OrbitalDataRecordReader {
    private DataInputStream in = null;
    private String productSpecifier;
    private String satelliteName;
    private int arcStart;
    private int lengthOfRepeatCycle;
    private int arcNumber;
    private int numRecords = 0;
    private int version;
    private OrbitDataRecord[] dataRecords = null;
    private OrbitPositionRecord[] orbitPositions = null;
    private double[] recordTimes = null;
    private double days1985To2000;
    private static final double halfSecond = 5.787037037037037E-6;
    public static final int invalidArcNumber = -1;
    private static final int INTERPOLATION_ORDER = 8;

    public boolean readOrbitFile(Path path) throws Exception {
        if (this.OpenOrbitFile(path)) {
            this.parseHeader1();
            this.parseHeader2();
            if (this.numRecords > 0) {
                this.dataRecords = new OrbitDataRecord[this.numRecords];
                this.orbitPositions = new OrbitPositionRecord[this.numRecords];
                this.recordTimes = new double[this.numRecords];
                this.days1985To2000 = ProductData.UTC.parse((String)"01-JAN-1985 00:00:00").getMJD();
                for (int i = 0; i < this.numRecords; ++i) {
                    this.dataRecords[i] = this.parseDataRecord();
                    this.orbitPositions[i] = this.computeOrbitPosition(this.dataRecords[i]);
                    this.recordTimes[i] = this.orbitPositions[i].utcTime;
                }
            }
            return true;
        }
        return false;
    }

    boolean OpenOrbitFile(Path path) {
        try {
            this.in = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
        }
        catch (Exception e) {
            this.in = null;
            return false;
        }
        return true;
    }

    void parseHeader1() {
        if (this.in == null) {
            return;
        }
        try {
            this.productSpecifier = this.readAn(4);
            this.satelliteName = this.readAn(8);
            this.arcStart = this.in.readInt();
        }
        catch (IOException e) {
            System.out.print(e);
        }
    }

    void parseHeader2() {
        if (this.in == null) {
            return;
        }
        try {
            this.lengthOfRepeatCycle = this.in.readInt();
            this.arcNumber = this.in.readInt();
            this.numRecords = this.in.readInt();
            this.version = this.in.readInt();
        }
        catch (IOException e) {
            System.out.print(e);
        }
    }

    OrbitDataRecord parseDataRecord() {
        OrbitDataRecord data = new OrbitDataRecord();
        try {
            data.time = this.in.readInt();
            data.latitude = this.in.readInt();
            data.longitude = this.in.readInt();
            data.heightOfCenterOfMass = this.in.readInt();
        }
        catch (IOException e) {
            System.out.print(e);
        }
        return data;
    }

    public String getProductSpecifier() {
        return this.productSpecifier;
    }

    public String getSatelliteName() {
        return this.satelliteName;
    }

    public int getArcStart() {
        return this.arcStart;
    }

    public int getLengthOfRepeatCycle() {
        return this.lengthOfRepeatCycle;
    }

    public int getArcNumber() {
        return this.arcNumber;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getVersion() {
        return this.version;
    }

    public OrbitDataRecord[] getDataRecords() {
        return this.dataRecords;
    }

    String readAn(int n) throws IOException {
        byte[] bytes = new byte[n];
        int bytesRead = this.in.read(bytes);
        if (bytesRead != n) {
            String message = "Error parsing file: expecting " + n + " bytes but got " + bytesRead;
            throw new IOException(message);
        }
        return new String(bytes);
    }

    private OrbitPositionRecord computeOrbitPosition(OrbitDataRecord dataRecord) throws IOException {
        double lon;
        double lat;
        double time = (double)dataRecord.time / 86400.0;
        double utcTime = time + this.days1985To2000;
        double alt = (double)dataRecord.heightOfCenterOfMass / 1000.0;
        if (this.productSpecifier.contains("xODR")) {
            lat = (double)dataRecord.latitude / 1.0E7;
            lon = (double)dataRecord.longitude / 1.0E7;
        } else if (this.productSpecifier.contains("@ODR")) {
            lat = (double)dataRecord.latitude / 1000000.0;
            lon = (double)dataRecord.longitude / 1000000.0;
            if (lon > 180.0) {
                lon -= 360.0;
            }
        } else {
            throw new IOException("Invalid product specifier: " + this.productSpecifier);
        }
        double[] xyz = new double[3];
        GeoUtils.polar2cartesian((double)lat, (double)lon, (double)alt, (double[])xyz);
        OrbitPositionRecord orbitPosition = new OrbitPositionRecord();
        orbitPosition.utcTime = utcTime;
        orbitPosition.xPos = xyz[0];
        orbitPosition.yPos = xyz[1];
        orbitPosition.zPos = xyz[2];
        return orbitPosition;
    }

    private OrbitPositionRecord getOrbitPosition(double utc) throws Exception {
        int itRel;
        int order = 8;
        int nRecords = this.recordTimes.length;
        double t0 = this.recordTimes[0];
        double tN = this.recordTimes[nRecords - 1];
        double tRel = (utc - t0) / (tN - t0) * (double)(nRecords - 1);
        int n0 = itRel = (int)Math.max(1L, Math.min(Math.round(tRel) - 4L, (long)(nRecords - 1 - 8)));
        int n1 = itRel + 1;
        int n2 = itRel + 2;
        int n3 = itRel + 3;
        int n4 = itRel + 4;
        int n5 = itRel + 5;
        int n6 = itRel + 6;
        int n7 = itRel + 7;
        int n8 = itRel + 8;
        if (n0 < 0 || n1 < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 > nRecords || n6 > nRecords || n7 > nRecords || n8 > nRecords) {
            throw new Exception("Incorrect UTC time");
        }
        double[] xPosArray = new double[]{this.orbitPositions[n0].xPos, this.orbitPositions[n1].xPos, this.orbitPositions[n2].xPos, this.orbitPositions[n3].xPos, this.orbitPositions[n4].xPos, this.orbitPositions[n5].xPos, this.orbitPositions[n6].xPos, this.orbitPositions[n7].xPos, this.orbitPositions[n8].xPos};
        double[] yPosArray = new double[]{this.orbitPositions[n0].yPos, this.orbitPositions[n1].yPos, this.orbitPositions[n2].yPos, this.orbitPositions[n3].yPos, this.orbitPositions[n4].yPos, this.orbitPositions[n5].yPos, this.orbitPositions[n6].yPos, this.orbitPositions[n7].yPos, this.orbitPositions[n8].yPos};
        double[] zPosArray = new double[]{this.orbitPositions[n0].zPos, this.orbitPositions[n1].zPos, this.orbitPositions[n2].zPos, this.orbitPositions[n3].zPos, this.orbitPositions[n4].zPos, this.orbitPositions[n5].zPos, this.orbitPositions[n6].zPos, this.orbitPositions[n7].zPos, this.orbitPositions[n8].zPos};
        OrbitPositionRecord orbitPosition = new OrbitPositionRecord();
        orbitPosition.utcTime = utc;
        double ref = tRel - (double)itRel;
        double[] xyz = new double[3];
        double[] phiLamHeight = new double[3];
        xyz[0] = Maths.lagrangeEightOrderInterpolation((double[])xPosArray, (double)ref);
        xyz[1] = Maths.lagrangeEightOrderInterpolation((double[])yPosArray, (double)ref);
        xyz[2] = Maths.lagrangeEightOrderInterpolation((double[])zPosArray, (double)ref);
        GeoUtils.cartesian2polar((double[])xyz, (double[])phiLamHeight);
        GeoUtils.geo2xyz((double)(phiLamHeight[0] * 57.29577951308232), (double)(phiLamHeight[1] * 57.29577951308232), (double)phiLamHeight[2], (double[])xyz, (GeoUtils.EarthModel)GeoUtils.EarthModel.GRS80);
        orbitPosition.xPos = xyz[0];
        orbitPosition.yPos = xyz[1];
        orbitPosition.zPos = xyz[2];
        return orbitPosition;
    }

    public OrbitVector getOrbitVector(double utc) throws Exception {
        OrbitPositionRecord orbitPos = this.getOrbitPosition(utc);
        OrbitPositionRecord orbitPosFw = this.getOrbitPosition(utc + 5.787037037037037E-6);
        OrbitPositionRecord orbitPosBw = this.getOrbitPosition(utc - 5.787037037037037E-6);
        OrbitVector orbitVector = new OrbitVector();
        orbitVector.utcTime = orbitPos.utcTime;
        orbitVector.xPos = orbitPos.xPos;
        orbitVector.yPos = orbitPos.yPos;
        orbitVector.zPos = orbitPos.zPos;
        orbitVector.xVel = orbitPosFw.xPos - orbitPosBw.xPos;
        orbitVector.yVel = orbitPosFw.yPos - orbitPosBw.yPos;
        orbitVector.zVel = orbitPosFw.zPos - orbitPosBw.zPos;
        return orbitVector;
    }

    public static int getArcNumber(File file, Date productDate) throws Exception {
        FileInputStream stream;
        String fileName = file.getAbsolutePath();
        try {
            stream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new IOException("File not found: " + fileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String titleLine = "Arc# ------- Arc interval ------ -SLR-xover-altim  Repeat Ver  ---- Begin ----";
        SimpleDateFormat dateformat = new SimpleDateFormat("yyMMdd HH:mm");
        int arcNum = -1;
        String line = "";
        while ((line = reader.readLine()) != null && !line.equals("Arc# ------- Arc interval ------ -SLR-xover-altim  Repeat Ver  ---- Begin ----")) {
        }
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            int recordArcNum = Integer.parseInt(st.nextToken());
            Date startDate = dateformat.parse(st.nextToken() + " " + st.nextToken());
            String hyphen = st.nextToken();
            Date endDate = dateformat.parse(st.nextToken() + " " + st.nextToken());
            if (productDate.compareTo(startDate) < 0 || productDate.compareTo(endDate) >= 0) continue;
            arcNum = recordArcNum;
            break;
        }
        reader.close();
        stream.close();
        return arcNum;
    }

    public static OrbitalDataRecordReader getInstance() {
        return Holder.instance;
    }

    private static class Holder {
        private static final OrbitalDataRecordReader instance = new OrbitalDataRecordReader();

        private Holder() {
        }
    }

    public static final class OrbitVector {
        public double utcTime = 0.0;
        public double xPos = 0.0;
        public double yPos = 0.0;
        public double zPos = 0.0;
        public double xVel = 0.0;
        public double yVel = 0.0;
        public double zVel = 0.0;
    }

    static class OrbitPositionRecord {
        double utcTime = 0.0;
        double xPos = 0.0;
        double yPos = 0.0;
        double zPos = 0.0;

        OrbitPositionRecord() {
        }
    }

    static class OrbitDataRecord {
        int time;
        int latitude;
        int longitude;
        int heightOfCenterOfMass;

        OrbitDataRecord() {
        }
    }
}

