/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.io.orbits.delft;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.esa.s1tbx.io.orbits.BaseOrbitFile;
import org.esa.s1tbx.io.orbits.delft.OrbitalDataRecordReader;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.Orbits;
import org.esa.snap.engine_utilities.util.Settings;

public class DelftOrbitFile
extends BaseOrbitFile {
    public static final String DELFT_PRECISE = "DELFT Precise";
    private OrbitalDataRecordReader delftReader = null;
    private final Product sourceProduct;

    public DelftOrbitFile(MetadataElement absRoot, Product sourceProduct) throws Exception {
        super(absRoot);
        this.sourceProduct = sourceProduct;
    }

    @Override
    public String[] getAvailableOrbitTypes() {
        return new String[]{DELFT_PRECISE};
    }

    @Override
    public File retrieveOrbitFile(String orbitType) throws Exception {
        this.delftReader = OrbitalDataRecordReader.getInstance();
        Date startDate = this.sourceProduct.getStartTime().getAsDate();
        this.orbitFile = this.FindDelftOrbitFile(this.delftReader, startDate);
        if (this.orbitFile == null) {
            throw new IOException("Unable to find suitable orbit file.\nPlease refer to http://www.deos.tudelft.nl/ers/precorbs/orbits/ \nERS1 orbits are available until 1996\nERS2 orbits are available until 2003\nENVISAT orbits are available until 2008");
        }
        return this.orbitFile;
    }

    @Override
    public Orbits.OrbitVector getOrbitData(double utc) throws Exception {
        OrbitalDataRecordReader.OrbitVector orb = this.delftReader.getOrbitVector(utc);
        return new Orbits.OrbitVector(utc, orb.xPos, orb.yPos, orb.zPos, orb.xVel, orb.yVel, orb.zVel);
    }

    private File FindDelftOrbitFile(OrbitalDataRecordReader delftReader, Date productDate) throws Exception {
        String mission = this.absRoot.getAttributeString("MISSION");
        String orbitPathStr = "";
        String delftFTPPath = "";
        switch (mission) {
            case "ENVISAT": {
                orbitPathStr = Settings.getPath((String)"OrbitFiles.delftEnvisatOrbitPath");
                delftFTPPath = Settings.getPath((String)"OrbitFiles.delftFTP_ENVISAT_precise_remotePath");
                break;
            }
            case "ERS1": {
                orbitPathStr = Settings.getPath((String)"OrbitFiles.delftERS1OrbitPath");
                delftFTPPath = Settings.getPath((String)"OrbitFiles.delftFTP_ERS1_precise_remotePath");
                break;
            }
            case "ERS2": {
                orbitPathStr = Settings.getPath((String)"OrbitFiles.delftERS2OrbitPath");
                delftFTPPath = Settings.getPath((String)"OrbitFiles.delftFTP_ERS2_precise_remotePath");
            }
        }
        File orbitPath = new File(orbitPathStr);
        String delftFTP = Settings.instance().get("OrbitFiles.delftFTP");
        if (!orbitPath.exists() && !orbitPath.mkdirs()) {
            throw new IOException("Failed to create directory '" + orbitPath + "'.");
        }
        File arclistFile = new File(orbitPath, "arclist");
        if (!arclistFile.exists() && !this.getRemoteFile(delftFTP, delftFTPPath, arclistFile)) {
            return null;
        }
        int arcNum = OrbitalDataRecordReader.getArcNumber(arclistFile, productDate);
        if (arcNum == -1) {
            if (!this.getRemoteFile(delftFTP, delftFTPPath, arclistFile)) {
                return null;
            }
            arcNum = OrbitalDataRecordReader.getArcNumber(arclistFile, productDate);
            if (arcNum == -1) {
                return null;
            }
        }
        String orbitFileName = orbitPath.getAbsolutePath() + File.separator + "ODR.";
        orbitFileName = arcNum < 10 ? orbitFileName + "00" + arcNum : (arcNum < 100 ? orbitFileName + "0" + arcNum : orbitFileName + arcNum);
        File orbitFile = new File(orbitFileName);
        if (!orbitFile.exists() && !this.getRemoteFile(delftFTP, delftFTPPath, orbitFile)) {
            return null;
        }
        delftReader.readOrbitFile(orbitFile.toPath());
        return orbitFile;
    }
}

