/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons.utils;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadExecutor {
    private final ThreadPoolExecutor executor;

    public ThreadExecutor() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ThreadExecutor(int maxThreads) {
        this.executor = new ThreadPoolExecutor(maxThreads, maxThreads, 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void complete() {
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }
}

