/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons.test;

import java.io.File;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.util.TestUtils;

public class ReaderTest {
    protected final ProductReaderPlugIn readerPlugIn;
    protected final ProductReader reader;

    public ReaderTest(ProductReaderPlugIn readerPlugIn) {
        this.readerPlugIn = readerPlugIn;
        this.reader = readerPlugIn.createReaderInstance();
    }

    protected Product testReader(File inputFile) throws Exception {
        if (!inputFile.exists()) {
            TestUtils.skipTest((Object)this, (String)(inputFile + " not found"));
            return null;
        }
        DecodeQualification canRead = this.readerPlugIn.getDecodeQualification((Object)inputFile);
        if (canRead != DecodeQualification.INTENDED) {
            throw new Exception("Reader not intended");
        }
        Product product = this.reader.readProductNodes((Object)inputFile, null);
        if (product == null) {
            throw new Exception("Unable to read product");
        }
        TestUtils.verifyProduct((Product)product, (boolean)true, (boolean)true);
        this.validateMetadata(product);
        return product;
    }

    protected void validateMetadata(Product trgProduct) throws Exception {
        MetadataAttribute[] attribs;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)trgProduct);
        for (MetadataAttribute attrib : attribs = absRoot.getAttributes()) {
            System.out.println(attrib.getName() + "= " + attrib.getData().toString());
        }
    }

    static {
        TestUtils.initTestEnvironment();
    }
}

