/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons.io;

import java.io.File;
import java.io.IOException;
import org.esa.s1tbx.commons.io.AbstractProductDirectory;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.jdom2.Element;

public abstract class PropertyMapProductDirectory
extends AbstractProductDirectory {
    protected PropertyMap propertyMap = new DefaultPropertyMap();

    public PropertyMapProductDirectory(File headerFile) {
        super(headerFile);
    }

    @Override
    public void readProductDirectory() throws IOException {
        File headerFile = this.getFile(this.getRootFolder() + this.getHeaderFileName());
        this.propertyMap.load(headerFile.toPath());
    }

    @Override
    protected MetadataElement addMetaData() throws IOException {
        MetadataElement root = new MetadataElement("metadata");
        AbstractMetadataIO.AddXMLMetadata((Element)this.propertyMapToXML("ProductMetadata", this.propertyMap), (MetadataElement)AbstractMetadata.addOriginalProductMetadata((MetadataElement)root));
        this.addAbstractedMetadataHeader(root);
        return root;
    }

    protected Element propertyMapToXML(String elementName, PropertyMap propertyMap) {
        Element root = new Element(elementName);
        for (String key : propertyMap.getPropertyKeys()) {
            root.setAttribute(key, propertyMap.getPropertyString(key));
        }
        return root;
    }

    @Override
    protected abstract void addAbstractedMetadataHeader(MetadataElement var1) throws IOException;
}

